/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.render;

import java.util.Collections;
import java.util.HashMap;
import net.minecraft.class_2350;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_630;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

class CustomizableCube
extends class_630.class_628 {
    private final class_2350[] hidden;
    protected final Polygon[] polygons;
    protected int polygonCount = 0;
    public final float minX;
    public final float minY;
    public final float minZ;
    public final float maxX;
    public final float maxY;
    public final float maxZ;

    public CustomizableCube(int u, int v, float x, float y, float z, float sizeX, float sizeY, float sizeZ, float extraX, float extraY, float extraZ, boolean mirror, float textureWidth, float textureHeight, class_2350[] hide, class_2350[][] hideCorners) {
        super(u, v, x, y, z, sizeX, sizeY, sizeZ, extraX, extraY, extraZ, mirror, textureWidth, textureHeight, Collections.emptySet());
        this.hidden = hide;
        this.minX = x;
        this.minY = y;
        this.minZ = z;
        this.maxX = x + sizeX;
        this.maxY = y + sizeY;
        this.maxZ = z + sizeZ;
        this.polygons = new Polygon[6];
        float pX = x + sizeX;
        float pY = y + sizeY;
        float pZ = z + sizeZ;
        x -= extraX;
        y -= extraY;
        z -= extraZ;
        pX += extraX;
        pY += extraY;
        pZ += extraZ;
        if (mirror) {
            float i = pX;
            pX = x;
            x = i;
        }
        Vertex vertexNNN = new Vertex(x, y, z, 0.0f, 0.0f);
        Vertex vertexPNN = new Vertex(pX, y, z, 0.0f, 8.0f);
        Vertex vertexPPN = new Vertex(pX, pY, z, 8.0f, 8.0f);
        Vertex vertexNPN = new Vertex(x, pY, z, 8.0f, 0.0f);
        Vertex vertexNNP = new Vertex(x, y, pZ, 0.0f, 0.0f);
        Vertex vertexPNP = new Vertex(pX, y, pZ, 0.0f, 8.0f);
        Vertex vertexPPP = new Vertex(pX, pY, pZ, 8.0f, 8.0f);
        Vertex vertexNPP = new Vertex(x, pY, pZ, 8.0f, 0.0f);
        float minU = u;
        float maxU = (float)u + 1.0f;
        float minV = v;
        float maxV = (float)v + 1.0f;
        HashMap<class_2350.class_2351, class_2350[]> axisToCorner = new HashMap<class_2350.class_2351, class_2350[]>();
        block0: for (class_2350[] corner : hideCorners) {
            block1: for (class_2350.class_2351 axis : class_2350.class_2351.field_23780) {
                for (class_2350 dir : corner) {
                    if (dir.method_10166() == axis) continue block1;
                }
                axisToCorner.put(axis, corner);
                continue block0;
            }
        }
        if (this.visibleFace(class_2350.field_11033)) {
            this.polygons[this.polygonCount++] = new Polygon(CustomizableCube.removeCornerVertex(new Vertex[]{vertexPNP, vertexNNP, vertexNNN, vertexPNN}, (class_2350[])axisToCorner.get(class_2350.class_2351.field_11052)), minU, minV, maxU, maxV, textureWidth, textureHeight, mirror, class_2350.field_11033);
        }
        if (this.visibleFace(class_2350.field_11036)) {
            this.polygons[this.polygonCount++] = new Polygon(CustomizableCube.removeCornerVertex(new Vertex[]{vertexPPN, vertexNPN, vertexNPP, vertexPPP}, (class_2350[])axisToCorner.get(class_2350.class_2351.field_11052)), minU, minV, maxU, maxV, textureWidth, textureHeight, mirror, class_2350.field_11036);
        }
        if (this.visibleFace(class_2350.field_11043)) {
            this.polygons[this.polygonCount++] = new Polygon(CustomizableCube.removeCornerVertex(new Vertex[]{vertexPNN, vertexNNN, vertexNPN, vertexPPN}, (class_2350[])axisToCorner.get(class_2350.class_2351.field_11051)), minU, minV, maxU, maxV, textureWidth, textureHeight, mirror, class_2350.field_11043);
        }
        if (this.visibleFace(class_2350.field_11035)) {
            this.polygons[this.polygonCount++] = new Polygon(CustomizableCube.removeCornerVertex(new Vertex[]{vertexNNP, vertexPNP, vertexPPP, vertexNPP}, (class_2350[])axisToCorner.get(class_2350.class_2351.field_11051)), minU, minV, maxU, maxV, textureWidth, textureHeight, mirror, class_2350.field_11035);
        }
        if (this.visibleFace(class_2350.field_11039)) {
            this.polygons[this.polygonCount++] = new Polygon(CustomizableCube.removeCornerVertex(new Vertex[]{vertexNNN, vertexNNP, vertexNPP, vertexNPN}, (class_2350[])axisToCorner.get(class_2350.class_2351.field_11048)), minU, minV, maxU, maxV, textureWidth, textureHeight, mirror, class_2350.field_11039);
        }
        if (this.visibleFace(class_2350.field_11034)) {
            this.polygons[this.polygonCount++] = new Polygon(CustomizableCube.removeCornerVertex(new Vertex[]{vertexPNP, vertexPNN, vertexPPN, vertexPPP}, (class_2350[])axisToCorner.get(class_2350.class_2351.field_11048)), minU, minV, maxU, maxV, textureWidth, textureHeight, mirror, class_2350.field_11034);
        }
    }

    private boolean visibleFace(class_2350 face) {
        for (class_2350 dir : this.hidden) {
            if (dir != face) continue;
            return false;
        }
        return true;
    }

    private static Vertex[] removeCornerVertex(Vertex[] vertices, class_2350[] corner) {
        if (corner == null) {
            return vertices;
        }
        Vertex except = vertices[0];
        for (int i = 1; i < 4; ++i) {
            except = CustomizableCube.compareVertices(except, vertices[i], corner);
        }
        int index = 0;
        for (int i = 0; i < 4; ++i) {
            if (vertices[i] == except) continue;
            vertices[index++] = vertices[i];
        }
        vertices[3] = vertices[2];
        return vertices;
    }

    private static Vertex compareVertices(Vertex vertex1, Vertex vertex2, class_2350[] corner) {
        for (class_2350 dir : corner) {
            double d = dir.method_10166().method_10172((double)(vertex1.pos.x() - vertex2.pos.x()), (double)(vertex1.pos.y() - vertex2.pos.y()), (double)(vertex1.pos.z() - vertex2.pos.z())) * (double)dir.method_10171().method_10181();
            if (d > 0.0) {
                return vertex1;
            }
            if (!(d < 0.0)) continue;
            return vertex2;
        }
        return vertex1;
    }

    public void method_32089(class_4587.class_4665 pose, class_4588 vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        Matrix4f matrix4f = pose.method_23761();
        Matrix3f matrix3f = pose.method_23762();
        for (int id = 0; id < this.polygonCount; ++id) {
            Polygon polygon = this.polygons[id];
            Vector3f vector3f = new Vector3f((Vector3fc)polygon.normal);
            vector3f.mul((Matrix3fc)matrix3f);
            float x = vector3f.x();
            float y = vector3f.y();
            float z = vector3f.z();
            for (int i = 0; i < 4; ++i) {
                Vertex vertex = polygon.vertices[i];
                Vector4f vector4f = new Vector4f(vertex.scaledX, vertex.scaledY, vertex.scaledZ, 1.0f);
                vector4f.mul((Matrix4fc)matrix4f);
                vertexConsumer.method_23919(vector4f.x(), vector4f.y(), vector4f.z(), red, green, blue, alpha, vertex.u, vertex.v, overlay, light, x, y, z);
            }
        }
    }

    protected static class Polygon {
        public final Vertex[] vertices;
        public final Vector3f normal;

        public Polygon(Vertex[] vertexs, float minU, float minV, float maxU, float maxV, float textureWidth, float textureHeight, boolean mirror, class_2350 direction) {
            this.vertices = vertexs;
            float zeroWidth = 0.0f / textureWidth;
            float zeroHeight = 0.0f / textureHeight;
            vertexs[0] = vertexs[0].remap(maxU / textureWidth - zeroWidth, minV / textureHeight + zeroHeight);
            vertexs[1] = vertexs[1].remap(minU / textureWidth + zeroWidth, minV / textureHeight + zeroHeight);
            vertexs[2] = vertexs[2].remap(minU / textureWidth + zeroWidth, maxV / textureHeight - zeroHeight);
            vertexs[3] = vertexs[3].remap(maxU / textureWidth - zeroWidth, maxV / textureHeight - zeroHeight);
            if (mirror) {
                int vertexCount = vertexs.length;
                for (int i = 0; i < vertexCount / 2; ++i) {
                    Vertex vertex = vertexs[i];
                    vertexs[i] = vertexs[vertexCount - 1 - i];
                    vertexs[vertexCount - 1 - i] = vertex;
                }
            }
            this.normal = direction.method_23955();
            if (mirror) {
                this.normal.mul(-1.0f, 1.0f, 1.0f);
            }
        }
    }

    protected static class Vertex {
        public final Vector3f pos;
        public final float u;
        public final float v;
        public final float scaledX;
        public final float scaledY;
        public final float scaledZ;

        public Vertex(float x, float y, float z, float u, float v) {
            this(new Vector3f(x, y, z), u, v);
        }

        public Vertex remap(float u, float v) {
            return new Vertex(this.pos, u, v);
        }

        public Vertex(Vector3f vector3f, float u, float v) {
            this.pos = vector3f;
            this.u = u;
            this.v = v;
            this.scaledX = this.pos.x() / 16.0f;
            this.scaledY = this.pos.y() / 16.0f;
            this.scaledZ = this.pos.z() / 16.0f;
        }
    }
}

