/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.injection.mixins.fast_buffer_upload;

import java.nio.ByteBuffer;
import net.minecraft.class_291;
import net.raphimc.immediatelyfast.ImmediatelyFast;
import net.raphimc.immediatelyfast.feature.fast_buffer_upload.PersistentMappedStreamingBuffer;
import org.lwjgl.opengl.GL15C;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_291.class}, priority=500)
public abstract class MixinVertexBuffer {
    @Shadow
    private int field_1594;
    @Shadow
    private int field_27366;
    @Unique
    private int vertexBufferSize = -1;
    @Unique
    private int indexBufferSize = -1;

    @Redirect(method={"uploadVertexBuffer"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;glBufferData(ILjava/nio/ByteBuffer;I)V"))
    private void optimizeVertexDataUploading(int target, ByteBuffer data, int usage) {
        int dataSize = data.remaining();
        if (dataSize == 0 && this.vertexBufferSize != -1) {
            return;
        }
        if (dataSize <= this.vertexBufferSize) {
            PersistentMappedStreamingBuffer streamingBuffer = ImmediatelyFast.persistentMappedStreamingBuffer;
            if (streamingBuffer != null && (long)dataSize <= streamingBuffer.getSize()) {
                streamingBuffer.addUpload(this.field_1594, data);
                return;
            }
            if (ImmediatelyFast.runtimeConfig.legacy_fast_buffer_upload) {
                GL15C.glBufferSubData((int)target, (long)0L, (ByteBuffer)data);
                return;
            }
        }
        this.vertexBufferSize = dataSize;
        GL15C.glBufferData((int)target, (ByteBuffer)data, (int)usage);
    }

    @Redirect(method={"uploadIndexBuffer"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;glBufferData(ILjava/nio/ByteBuffer;I)V"))
    private void optimizeIndexDataUploading(int target, ByteBuffer data, int usage) {
        int dataSize = data.remaining();
        if (dataSize == 0 && this.indexBufferSize != -1) {
            return;
        }
        if (dataSize <= this.indexBufferSize) {
            PersistentMappedStreamingBuffer streamingBuffer = ImmediatelyFast.persistentMappedStreamingBuffer;
            if (streamingBuffer != null && (long)dataSize <= streamingBuffer.getSize()) {
                streamingBuffer.addUpload(this.field_27366, data);
                return;
            }
            if (ImmediatelyFast.runtimeConfig.legacy_fast_buffer_upload) {
                GL15C.glBufferSubData((int)target, (long)0L, (ByteBuffer)data);
                return;
            }
        }
        this.indexBufferSize = dataSize;
        GL15C.glBufferData((int)target, (ByteBuffer)data, (int)usage);
    }

    @Inject(method={"upload"}, at={@At(value="RETURN")})
    private void flushBuffers(CallbackInfo ci) {
        if (ImmediatelyFast.persistentMappedStreamingBuffer != null) {
            ImmediatelyFast.persistentMappedStreamingBuffer.flush();
        }
    }
}

