/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.injection.mixins.map_atlas_generation;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.class_22;
import net.minecraft.class_330;
import net.raphimc.immediatelyfast.feature.map_atlas_generation.MapAtlasTexture;
import net.raphimc.immediatelyfast.injection.interfaces.IMapRenderer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_330.class})
public abstract class MixinMapRenderer
implements IMapRenderer {
    @Unique
    private final Int2ObjectMap<MapAtlasTexture> mapAtlasTextures = new Int2ObjectOpenHashMap();
    @Unique
    private final Int2IntMap mapIdToAtlasMapping = new Int2IntOpenHashMap();

    @Inject(method={"clearStateTextures"}, at={@At(value="RETURN")})
    private void clearMapAtlasTextures(CallbackInfo ci) {
        for (MapAtlasTexture texture : this.mapAtlasTextures.values()) {
            texture.close();
        }
        this.mapAtlasTextures.clear();
        this.mapIdToAtlasMapping.clear();
    }

    @Inject(method={"getMapTexture"}, at={@At(value="HEAD")})
    private void createMapAtlasTexture(int id, class_22 state, CallbackInfoReturnable<class_330.class_331> cir) {
        this.mapIdToAtlasMapping.computeIfAbsent(id, k -> {
            for (MapAtlasTexture atlasTexture : this.mapAtlasTextures.values()) {
                int location = atlasTexture.getNextMapLocation();
                if (location == -1) continue;
                return location;
            }
            MapAtlasTexture atlasTexture = new MapAtlasTexture(this.mapAtlasTextures.size());
            this.mapAtlasTextures.put(atlasTexture.getId(), (Object)atlasTexture);
            return atlasTexture.getNextMapLocation();
        });
    }

    @Override
    public MapAtlasTexture getMapAtlasTexture(int id) {
        return (MapAtlasTexture)this.mapAtlasTextures.get(id);
    }

    @Override
    public int getAtlasMapping(int mapId) {
        return this.mapIdToAtlasMapping.getOrDefault(mapId, -1);
    }
}

