/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.zoomify.zoom;

import dev.isxander.zoomify.utils.TransitionType;
import dev.isxander.zoomify.zoom.TimedInterpolator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B?\u0012\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0017\u0012\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u0017\u0012\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017\u0012\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017\u00a2\u0006\u0004\b \u0010!J\u0017\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0005J'\u0010\n\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bR\u0016\u0010\r\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u001d\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u00178\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u001d\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u00178\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0019\u001a\u0004\b\u001d\u0010\u001b\u00a8\u0006\""}, d2={"Ldev/isxander/zoomify/zoom/TransitionInterpolator;", "Ldev/isxander/zoomify/zoom/TimedInterpolator;", "", "interpolation", "modifyInterpolation", "(D)D", "modifyPrevInterpolation", "targetInterpolation", "currentInterpolation", "tickDelta", "tickInterpolation", "(DDD)D", "Ldev/isxander/zoomify/utils/TransitionType;", "activeTransition", "Ldev/isxander/zoomify/utils/TransitionType;", "inactiveTransition", "", "isSmooth", "()Z", "justSwappedTransition", "Z", "prevTargetInterpolation", "D", "Lkotlin/Function0;", "transitionIn", "Lkotlin/jvm/functions/Function0;", "getTransitionIn", "()Lkotlin/jvm/functions/Function0;", "transitionOut", "getTransitionOut", "timeIn", "timeOut", "<init>", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "Zoomify"})
public final class TransitionInterpolator
extends TimedInterpolator {
    @NotNull
    private final Function0<TransitionType> transitionIn;
    @NotNull
    private final Function0<TransitionType> transitionOut;
    @NotNull
    private TransitionType activeTransition;
    @NotNull
    private TransitionType inactiveTransition;
    private double prevTargetInterpolation;
    private boolean justSwappedTransition;

    public TransitionInterpolator(@NotNull Function0<? extends TransitionType> transitionIn, @NotNull Function0<? extends TransitionType> transitionOut, @NotNull Function0<Double> timeIn, @NotNull Function0<Double> timeOut) {
        Intrinsics.checkNotNullParameter(transitionIn, (String)"transitionIn");
        Intrinsics.checkNotNullParameter(transitionOut, (String)"transitionOut");
        Intrinsics.checkNotNullParameter(timeIn, (String)"timeIn");
        Intrinsics.checkNotNullParameter(timeOut, (String)"timeOut");
        super(timeIn, timeOut);
        this.transitionIn = transitionIn;
        this.transitionOut = transitionOut;
        this.activeTransition = (TransitionType)this.transitionIn.invoke();
        this.inactiveTransition = (TransitionType)this.transitionOut.invoke();
    }

    @NotNull
    public final Function0<TransitionType> getTransitionIn() {
        return this.transitionIn;
    }

    @NotNull
    public final Function0<TransitionType> getTransitionOut() {
        return this.transitionOut;
    }

    @Override
    public double tickInterpolation(double targetInterpolation, double currentInterpolation, double tickDelta) {
        double currentInterpolationMod = currentInterpolation;
        if (targetInterpolation > currentInterpolation) {
            this.activeTransition = (TransitionType)this.transitionIn.invoke();
            this.inactiveTransition = (TransitionType)this.transitionOut.invoke();
            if (this.prevTargetInterpolation < targetInterpolation && this.activeTransition.hasInverse()) {
                this.justSwappedTransition = true;
                currentInterpolationMod = this.activeTransition.inverse(this.inactiveTransition.apply(currentInterpolationMod));
            }
        } else if (targetInterpolation < currentInterpolation) {
            this.activeTransition = (TransitionType)this.transitionOut.invoke();
            this.inactiveTransition = (TransitionType)this.transitionIn.invoke();
            if (this.prevTargetInterpolation > targetInterpolation && this.activeTransition.hasInverse()) {
                this.justSwappedTransition = true;
                currentInterpolationMod = this.activeTransition.inverse(this.inactiveTransition.apply(currentInterpolationMod));
            }
        }
        this.prevTargetInterpolation = targetInterpolation;
        if (this.activeTransition == TransitionType.INSTANT) {
            return targetInterpolation;
        }
        return super.tickInterpolation(targetInterpolation, currentInterpolationMod, tickDelta);
    }

    @Override
    public double modifyInterpolation(double interpolation) {
        return this.activeTransition.apply(interpolation);
    }

    @Override
    public double modifyPrevInterpolation(double interpolation) {
        if (this.justSwappedTransition) {
            this.justSwappedTransition = false;
            return this.activeTransition.inverse(this.inactiveTransition.apply(interpolation));
        }
        return interpolation;
    }

    @Override
    public boolean isSmooth() {
        return !this.justSwappedTransition && super.isSmooth() && this.activeTransition != TransitionType.INSTANT;
    }
}

