/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.flight;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;
import net.minecraft.class_3540;
import nl.enjarai.doabarrelroll.DoABarrelRoll;
import nl.enjarai.doabarrelroll.DoABarrelRollClient;
import nl.enjarai.doabarrelroll.ModKeybindings;
import nl.enjarai.doabarrelroll.api.event.RollContext;
import nl.enjarai.doabarrelroll.api.rotation.RotationInstant;
import nl.enjarai.doabarrelroll.config.ModConfig;
import nl.enjarai.doabarrelroll.config.Sensitivity;

@Environment(value=EnvType.CLIENT)
public class RotationModifiers {
    public static RollContext.ConfiguresRotation buttonControls(double power) {
        return (rotationInstant, context) -> {
            double delta = power * context.getRenderDelta();
            int pitch = 0;
            int yaw = 0;
            int roll = 0;
            if (ModKeybindings.PITCH_UP.method_1434()) {
                pitch = (int)((double)pitch - delta);
            }
            if (ModKeybindings.PITCH_DOWN.method_1434()) {
                pitch = (int)((double)pitch + delta);
            }
            if (ModKeybindings.YAW_LEFT.method_1434()) {
                yaw = (int)((double)yaw - delta);
            }
            if (ModKeybindings.YAW_RIGHT.method_1434()) {
                yaw = (int)((double)yaw + delta);
            }
            if (ModKeybindings.ROLL_LEFT.method_1434()) {
                roll = (int)((double)roll - delta);
            }
            if (ModKeybindings.ROLL_RIGHT.method_1434()) {
                roll = (int)((double)roll + delta);
            }
            return rotationInstant.add(pitch, yaw, roll);
        };
    }

    public static RollContext.ConfiguresRotation smoothing(class_3540 pitchSmoother, class_3540 yawSmoother, class_3540 rollSmoother, Sensitivity smoothness) {
        return (rotationInstant, context) -> RotationInstant.of(pitchSmoother.method_15429(rotationInstant.pitch(), smoothness.pitch * context.getRenderDelta()), yawSmoother.method_15429(rotationInstant.yaw(), smoothness.yaw * context.getRenderDelta()), rollSmoother.method_15429(rotationInstant.roll(), smoothness.roll * context.getRenderDelta()));
    }

    public static RotationInstant banking(RotationInstant rotationInstant, RollContext context) {
        double delta = context.getRenderDelta();
        RotationInstant currentRotation = context.getCurrentRotation();
        double currentRoll = currentRotation.roll() * (Math.PI / 180);
        double strength = 10.0 * Math.cos(currentRotation.pitch() * (Math.PI / 180)) * ModConfig.INSTANCE.getBankingStrength();
        double dX = Math.sin(currentRoll) * strength;
        double dY = -strength + Math.cos(currentRoll) * strength;
        if (Double.isNaN(dX)) {
            dX = 0.0;
        }
        if (Double.isNaN(dY)) {
            dY = 0.0;
        }
        return rotationInstant.addAbsolute(dX * delta, dY * delta, currentRoll);
    }

    public static RotationInstant manageThrottle(RotationInstant rotationInstant, RollContext context) {
        double delta = context.getRenderDelta();
        DoABarrelRollClient.throttle = ModKeybindings.THRUST_FORWARD.method_1434() ? (DoABarrelRollClient.throttle += 0.1 * delta) : (ModKeybindings.THRUST_BACKWARD.method_1434() ? (DoABarrelRollClient.throttle -= 0.1 * delta) : (DoABarrelRollClient.throttle -= DoABarrelRollClient.throttle * 0.95 * delta));
        DoABarrelRollClient.throttle = class_3532.method_15350((double)DoABarrelRollClient.throttle, (double)0.0, (double)ModConfig.INSTANCE.getMaxThrust());
        return rotationInstant;
    }

    public static RollContext.ConfiguresRotation fixNaN(String name) {
        return (rotationInstant, context) -> {
            if (Double.isNaN(rotationInstant.pitch())) {
                rotationInstant = RotationInstant.of(0.0, rotationInstant.yaw(), rotationInstant.roll());
                DoABarrelRoll.LOGGER.warn("NaN found in pitch for " + name + ", setting to 0 as fallback");
            }
            if (Double.isNaN(rotationInstant.yaw())) {
                rotationInstant = RotationInstant.of(rotationInstant.pitch(), 0.0, rotationInstant.roll());
                DoABarrelRoll.LOGGER.warn("NaN found in yaw for " + name + ", setting to 0 as fallback");
            }
            if (Double.isNaN(rotationInstant.roll())) {
                rotationInstant = RotationInstant.of(rotationInstant.pitch(), rotationInstant.yaw(), 0.0);
                DoABarrelRoll.LOGGER.warn("NaN found in roll for " + name + ", setting to 0 as fallback");
            }
            return rotationInstant;
        };
    }
}

