/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.net;

import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import nl.enjarai.doabarrelroll.DoABarrelRoll;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public class HandshakeClient<T> {
    private final Codec<? extends T> transferCodec;
    private final Codec<? extends T> limitedTransferCodec;
    private final Consumer<T> updateCallback;
    private T serverConfig = null;
    private boolean hasConnected = false;

    public HandshakeClient(Codec<? extends T> transferCodec, Codec<? extends T> limitedTransferCodec, Consumer<T> updateCallback) {
        this.transferCodec = transferCodec;
        this.limitedTransferCodec = limitedTransferCodec;
        this.updateCallback = updateCallback;
    }

    public Optional<T> getConfig() {
        return Optional.ofNullable(this.serverConfig);
    }

    public void setConfig(@Nullable T config) {
        this.serverConfig = config;
        this.updateCallback.accept(this.serverConfig);
        this.hasConnected = this.serverConfig != null;
    }

    public boolean hasConnected() {
        return this.hasConnected;
    }

    public class_2540 handleConfigSync(class_2540 buf) {
        try {
            int protocolVersion = buf.readInt();
            if (protocolVersion < 1 || protocolVersion > 2) {
                DoABarrelRoll.LOGGER.warn("Received config with unknown protocol version: {}, will attempt to load anyway", (Object)protocolVersion);
            }
            String data = buf.method_19772();
            boolean isLimited = true;
            if (protocolVersion >= 2) {
                isLimited = buf.readBoolean();
            }
            Codec<? extends T> codec = isLimited ? this.limitedTransferCodec : this.transferCodec;
            this.serverConfig = codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)data)).getOrThrow(false, arg_0 -> ((Logger)DoABarrelRoll.LOGGER).error(arg_0));
        }
        catch (RuntimeException e) {
            this.serverConfig = null;
            DoABarrelRoll.LOGGER.error("Failed to parse config from server", (Throwable)e);
        }
        if (this.serverConfig != null) {
            this.updateCallback.accept(this.serverConfig);
            this.hasConnected = true;
            DoABarrelRoll.LOGGER.info("Received config from server");
        }
        class_2540 returnBuf = new class_2540(Unpooled.buffer());
        returnBuf.writeInt(2);
        returnBuf.writeBoolean(this.serverConfig != null);
        return returnBuf;
    }

    public void reset() {
        this.serverConfig = null;
        this.hasConnected = false;
    }
}

