/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.net;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import nl.enjarai.doabarrelroll.DoABarrelRoll;
import nl.enjarai.doabarrelroll.net.ServerConfigHolder;
import nl.enjarai.doabarrelroll.net.SyncableConfig;
import nl.enjarai.doabarrelroll.net.ValidatableConfig;
import nl.enjarai.doabarrelroll.util.DelayedRunnable;
import org.slf4j.Logger;

public class HandshakeServer<T extends SyncableConfig<T> & ValidatableConfig> {
    private final ServerConfigHolder<T> configHolder;
    private final Map<class_3244, HandshakeState> syncStates = new WeakHashMap<class_3244, HandshakeState>();
    private final ArrayList<DelayedRunnable> scheduledTasks = new ArrayList();
    private final Function<class_3244, Boolean> getsLimitedCheck;
    private final Codec<T> transferCodec;
    private final Codec<? super T> limitedTransferCodec;

    public HandshakeServer(ServerConfigHolder<T> configHolder, Function<class_3244, Boolean> getsLimitedCheck, Codec<T> transferCodec, Codec<? super T> limitedTransferCodec) {
        this.configHolder = configHolder;
        this.getsLimitedCheck = getsLimitedCheck;
        this.transferCodec = transferCodec;
        this.limitedTransferCodec = limitedTransferCodec;
    }

    public void tick(MinecraftServer server) {
        this.scheduledTasks.removeIf(DelayedRunnable::isDone);
        this.scheduledTasks.forEach(DelayedRunnable::tick);
    }

    public HandshakeState getHandshakeState(class_3222 player) {
        return this.getHandshakeState(player.field_13987);
    }

    public HandshakeState getHandshakeState(class_3244 handler) {
        return this.syncStates.getOrDefault(handler, HandshakeState.NOT_SENT);
    }

    public class_2540 getConfigSyncBuf(class_3244 handler) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(2);
        SyncableConfig config = (SyncableConfig)this.configHolder.instance;
        Boolean isLimited = this.getsLimitedCheck.apply(handler);
        Object codec = isLimited != false ? this.limitedTransferCodec : this.transferCodec;
        DataResult data = codec.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)config);
        try {
            buf.method_10814(((JsonElement)data.getOrThrow(false, arg_0 -> ((Logger)DoABarrelRoll.LOGGER).error(arg_0))).toString());
        }
        catch (RuntimeException e) {
            DoABarrelRoll.LOGGER.error("Failed to encode config", (Throwable)e);
            buf.method_10814("{}");
        }
        buf.writeBoolean(isLimited.booleanValue());
        return buf;
    }

    public void configSentToClient(class_3244 handler) {
        this.syncStates.put(handler, HandshakeState.SENT);
        SyncableConfig config = (SyncableConfig)this.configHolder.instance;
        if (config.getSyncTimeout() != null) {
            this.scheduledTasks.add(new DelayedRunnable(config.getSyncTimeout(), () -> {
                if (this.syncStates.getOrDefault(handler, HandshakeState.NOT_SENT) != HandshakeState.ACCEPTED) {
                    DoABarrelRoll.LOGGER.warn("{} did not accept config syncing, config indicates we kick them.", (Object)handler.method_32311().method_5477().getString());
                    handler.method_14367(config.getSyncTimeoutMessage());
                }
            }));
        }
    }

    public HandshakeState clientReplied(class_3244 handler, class_2540 buf) {
        HandshakeState state = this.getHandshakeState(handler);
        class_3222 player = handler.method_32311();
        if (state == HandshakeState.SENT) {
            try {
                int protocolVersion = buf.readInt();
                if (protocolVersion < 1 || protocolVersion > 2) {
                    this.syncStates.put(handler, HandshakeState.FAILED);
                    DoABarrelRoll.LOGGER.warn("Client of {} sent unknown protocol version, expected range 1-2, got {}. Will attempt to proceed anyway.", (Object)player.method_5477().getString(), (Object)protocolVersion);
                }
                if (buf.readBoolean()) {
                    this.syncStates.put(handler, HandshakeState.ACCEPTED);
                    DoABarrelRoll.LOGGER.info("Client of {} accepted server config.", (Object)player.method_5477().getString());
                    return HandshakeState.ACCEPTED;
                }
                this.syncStates.put(handler, HandshakeState.FAILED);
                DoABarrelRoll.LOGGER.warn("Client of {} failed to process server config, check client logs find what went wrong.", (Object)player.method_5477().getString());
                return HandshakeState.FAILED;
            }
            catch (IndexOutOfBoundsException e) {
                this.syncStates.put(handler, HandshakeState.FAILED);
                DoABarrelRoll.LOGGER.warn("Client of {} sent invalid config reply.", (Object)player.method_5477().getString());
                return HandshakeState.FAILED;
            }
        }
        return state;
    }

    public void playerDisconnected(class_3244 handler) {
        this.syncStates.remove(handler);
    }

    public static enum HandshakeState {
        NOT_SENT,
        SENT,
        ACCEPTED,
        FAILED;

    }
}

