/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.server.network;

import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Pair;
import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nullable;

public class EmotePlayTracker {
    private KeyframeAnimation currentEmote = null;
    private Instant startTime = null;
    private boolean isForced = false;

    public void setPlayedEmote(@Nullable KeyframeAnimation data, boolean isForced) {
        this.currentEmote = data;
        if (data == null) {
            this.startTime = null;
            this.isForced = false;
        } else {
            this.startTime = Instant.now();
            this.isForced = isForced;
        }
    }

    public boolean isForced() {
        if (this.getPlayedEmote() != null) {
            return this.isForced;
        }
        return false;
    }

    @Nullable
    public Pair<KeyframeAnimation, Integer> getPlayedEmote() {
        if (this.currentEmote == null) {
            return null;
        }
        int tick = (int)(Duration.between(this.startTime, Instant.now()).toMillis() / 50L);
        if (!this.currentEmote.isInfinite() && this.currentEmote.getLength() <= tick) {
            this.currentEmote = null;
            this.startTime = null;
            this.isForced = false;
            return null;
        }
        return new Pair((Object)this.currentEmote, (Object)tick);
    }
}

