/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features;

import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_630;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.config.ETFConfig;
import traben.entity_texture_features.entity_handlers.ETFBlockEntityWrapper;
import traben.entity_texture_features.entity_handlers.ETFEntityWrapper;
import traben.entity_texture_features.texture_handlers.ETFManager;
import traben.entity_texture_features.texture_handlers.ETFTexture;
import traben.entity_texture_features.utils.ETFTexturePropertiesUtils;
import traben.entity_texture_features.utils.ETFUtils2;

public class ETFApi {
    public static final int ETFApiVersion = 6;
    @Deprecated
    public static ETFConfig getETFConfigObject = new ETFConfig();

    public static ETFConfig getETFConfigObject() {
        return ETFClientCommon.ETFConfigData;
    }

    public static ETFConfig getCopyOfETFConfigObject() {
        return ETFConfig.copyFrom(ETFClientCommon.ETFConfigData);
    }

    public static ETFConfig getDefaultETFConfigObject() {
        return new ETFConfig();
    }

    public static void setETFConfigObject(ETFConfig newETFConfig) {
        ETFClientCommon.ETFConfigData = newETFConfig;
        ETFApi.saveETFConfigChangesAndResetETF();
    }

    public static void saveETFConfigChangesAndResetETF() {
        ETFUtils2.saveConfig();
        ETFManager.resetInstance();
    }

    public static void resetETF() {
        ETFManager.resetInstance();
    }

    @NotNull
    public static class_2960 getCurrentETFVariantTextureOfEntity(@NotNull class_1297 entity, @NotNull class_2960 defaultTexture) {
        class_2960 etfIdentifier;
        ETFEntityWrapper etfEntity = new ETFEntityWrapper(entity);
        ETFTexture etfTexture = ETFManager.getInstance().getETFTexture(defaultTexture, etfEntity, ETFManager.TextureSource.ENTITY, ETFClientCommon.ETFConfigData.removePixelsUnderEmissiveMobs);
        if (etfTexture != null && (etfIdentifier = etfTexture.getTextureIdentifier(etfEntity)) != null) {
            return etfIdentifier;
        }
        return defaultTexture;
    }

    @NotNull
    public static class_2960 getCurrentETFVariantTextureOfEntity(@NotNull class_2586 entity, @NotNull class_2960 defaultTexture, UUID uuidForBlockEntity) {
        class_2960 etfIdentifier;
        ETFBlockEntityWrapper etfEntity = new ETFBlockEntityWrapper(entity, uuidForBlockEntity);
        ETFTexture etfTexture = ETFManager.getInstance().getETFTexture(defaultTexture, etfEntity, ETFManager.TextureSource.BLOCK_ENTITY, ETFClientCommon.ETFConfigData.removePixelsUnderEmissiveMobs);
        if (etfTexture != null && (etfIdentifier = etfTexture.getTextureIdentifier(etfEntity)) != null) {
            return etfIdentifier;
        }
        return defaultTexture;
    }

    @Nullable
    public static class_2960 getCurrentETFEmissiveTextureOfEntityOrNull(@NotNull class_1297 entity, @NotNull class_2960 defaultTexture) {
        ETFTexture etfTexture = ETFManager.getInstance().getETFTexture(defaultTexture, new ETFEntityWrapper(entity), ETFManager.TextureSource.ENTITY, ETFClientCommon.ETFConfigData.removePixelsUnderEmissiveMobs);
        if (etfTexture != null) {
            return etfTexture.getEmissiveIdentifierOfCurrentState();
        }
        return null;
    }

    public static void renderETFEmissiveModel(@NotNull class_1297 entity, @NotNull class_2960 defaultTextureOfEntity, @NotNull class_4587 matrixStack, @NotNull class_4597 vertexConsumerProvider, @NotNull class_3879 model) {
        ETFTexture etfTexture = ETFManager.getInstance().getETFTexture(defaultTextureOfEntity, new ETFEntityWrapper(entity), ETFManager.TextureSource.ENTITY, ETFClientCommon.ETFConfigData.removePixelsUnderEmissiveMobs);
        if (etfTexture != null) {
            etfTexture.renderEmissive(matrixStack, vertexConsumerProvider, model);
        }
    }

    public static void renderETFEmissiveModelPart(@NotNull class_1297 entity, @NotNull class_2960 defaultTextureOfEntity, @NotNull class_4587 matrixStack, @NotNull class_4597 vertexConsumerProvider, @NotNull class_630 modelPart) {
        ETFTexture etfTexture = ETFManager.getInstance().getETFTexture(defaultTextureOfEntity, new ETFEntityWrapper(entity), ETFManager.TextureSource.ENTITY, ETFClientCommon.ETFConfigData.removePixelsUnderEmissiveMobs);
        if (etfTexture != null) {
            etfTexture.renderEmissive(matrixStack, vertexConsumerProvider, modelPart);
        }
    }

    public static ETFRandomTexturePropertyInstance readRandomPropertiesFileAndReturnTestingObject2(class_2960 propertiesFileIdentifier, String suffixKeyName) {
        return ETFRandomTexturePropertyInstance.getInstance(propertiesFileIdentifier, suffixKeyName);
    }

    public static class ETFRandomTexturePropertyInstance {
        private final List<ETFTexturePropertiesUtils.ETFTexturePropertyCase> propertyCases;

        @Nullable
        private static ETFRandomTexturePropertyInstance getInstance(class_2960 propertiesFileIdentifier, String suffixKeyName) {
            Properties props = ETFUtils2.readAndReturnPropertiesElseNull(propertiesFileIdentifier);
            if (props == null) {
                return null;
            }
            List<ETFTexturePropertiesUtils.ETFTexturePropertyCase> etfs = ETFTexturePropertiesUtils.getAllValidPropertyObjects(props, suffixKeyName, propertiesFileIdentifier);
            if (etfs.isEmpty()) {
                return null;
            }
            return new ETFRandomTexturePropertyInstance(etfs);
        }

        private ETFRandomTexturePropertyInstance(List<ETFTexturePropertiesUtils.ETFTexturePropertyCase> etfs) {
            this.propertyCases = etfs;
        }

        public int getSuffixForEntity(class_1297 entityToBeTested, boolean isThisTheFirstTestForEntity, Object2BooleanOpenHashMap<UUID> cacheToMarkEntitiesWhoseVariantCanChangeAgain) {
            boolean isAnUpdate = !isThisTheFirstTestForEntity;
            for (ETFTexturePropertiesUtils.ETFTexturePropertyCase testCase : this.propertyCases) {
                if (!testCase.doesEntityMeetConditionsOfThisCase(entityToBeTested, isThisTheFirstTestForEntity, cacheToMarkEntitiesWhoseVariantCanChangeAgain)) continue;
                return testCase.getAnEntityVariantSuffixFromThisCase(entityToBeTested.method_5667());
            }
            return 0;
        }

        public int getSuffixForBlockEntity(class_2586 entityToBeTested, UUID uuidForBlockEntity, boolean isThisTheFirstTestForEntity, Object2BooleanOpenHashMap<UUID> cacheToMarkEntitiesWhoseVariantCanChangeAgain) {
            boolean isAnUpdate = !isThisTheFirstTestForEntity;
            for (ETFTexturePropertiesUtils.ETFTexturePropertyCase testCase : this.propertyCases) {
                if (!testCase.doesEntityMeetConditionsOfThisCase(entityToBeTested, uuidForBlockEntity, isThisTheFirstTestForEntity, cacheToMarkEntitiesWhoseVariantCanChangeAgain)) continue;
                return testCase.getAnEntityVariantSuffixFromThisCase(uuidForBlockEntity);
            }
            return 0;
        }
    }
}

