/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashSet;
import java.util.Set;
import traben.entity_texture_features.ETFVersionDifferenceHandler;
import traben.entity_texture_features.config.screens.ETFConfigScreenWarnings;
import traben.entity_texture_features.texture_handlers.ETFManager;

public class ETFConfig {
    public IllegalPathMode illegalPathSupportMode = IllegalPathMode.None;
    public boolean enableCustomTextures = true;
    public boolean enableCustomBlockEntities = true;
    public UpdateFrequency textureUpdateFrequency_V2 = UpdateFrequency.Fast;
    public boolean restrictUpdateProperties = true;
    public boolean restrictBiome = true;
    public boolean restrictHeight = true;
    public boolean restrictBlock = true;
    public boolean restrictWeather = true;
    public boolean restrictDayTime = true;
    public boolean restrictMoonPhase = true;
    public boolean enableEmissiveTextures = true;
    public boolean enableEmissiveBlockEntities = true;
    public ETFManager.EmissiveRenderModes emissiveRenderMode = ETFManager.EmissiveRenderModes.DULL;
    public boolean specialEmissiveShield = true;
    public boolean alwaysCheckVanillaEmissiveSuffix = true;
    public boolean skinFeaturesEnabled = true;
    public boolean skinFeaturesEnableTransparency = true;
    public boolean skinFeaturesEnableFullTransparency = false;
    public boolean tryETFTransparencyForAllSkins = false;
    public boolean enableEnemyTeamPlayersSkinFeatures = true;
    public boolean enableBlinking = true;
    public int blinkFrequency = 150;
    public int blinkLength = 1;
    public boolean enableTridents = true;
    public boolean enableElytra = true;
    public boolean elytraThicknessFix = false;
    public double advanced_IncreaseCacheSizeModifier = 1.0;
    public DebugLogMode debugLoggingMode = DebugLogMode.None;
    public boolean removePixelsUnderEmissiveElytra = true;
    public boolean removePixelsUnderEmissiveArmour = true;
    public boolean removePixelsUnderEmissivePlayers = true;
    public boolean removePixelsUnderEmissiveMobs = true;
    public boolean removePixelsUnderEmissiveBlockEntity = true;
    public boolean dontPatchPBRTextures = true;
    public boolean dontPatchAnimatedTextures = true;
    public Set<ETFConfigScreenWarnings.ConfigWarning> ignoredConfigs = new HashSet<ETFConfigScreenWarnings.ConfigWarning>();
    public boolean hideConfigButton = false;
    public boolean disableVanillaDirectoryVariantTextures = false;
    public boolean use3DSkinLayerPatch = true;
    public boolean enableFullBodyWardenTextures = true;

    public static ETFConfig copyFrom(ETFConfig source) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return (ETFConfig)gson.fromJson(gson.toJson((Object)source), ETFConfig.class);
    }

    public static enum IllegalPathMode {
        None("options.off"),
        Entity("config.entity_texture_features.illegal_path_mode.entity"),
        All("config.entity_texture_features.illegal_path_mode.all");

        private final String key;

        private IllegalPathMode(String key) {
            this.key = key;
        }

        public String toString() {
            return ETFVersionDifferenceHandler.getTextFromTranslation(this.key).getString();
        }

        public IllegalPathMode next() {
            switch (this) {
                case None: {
                    return Entity;
                }
                case Entity: {
                    return All;
                }
            }
            return None;
        }
    }

    public static enum UpdateFrequency {
        Never(-1),
        Slow(80),
        Average(20),
        Fast(5),
        Instant(1);

        private final int delay;

        private UpdateFrequency(int delay) {
            this.delay = delay;
        }

        public int getDelay() {
            return this.delay;
        }

        public String toString() {
            return ETFVersionDifferenceHandler.getTextFromTranslation(this.getKey()).getString();
        }

        private String getKey() {
            switch (this.delay) {
                case -1: {
                    return "config.entity_texture_features.update_frequency.never";
                }
                case 80: {
                    return "config.entity_texture_features.update_frequency.slow";
                }
                case 20: {
                    return "config.entity_texture_features.update_frequency.average";
                }
                case 5: {
                    return "config.entity_texture_features.update_frequency.fast";
                }
                case 1: {
                    return "config.entity_texture_features.update_frequency.instant";
                }
            }
            return "config.entity_texture_features.error";
        }

        public UpdateFrequency next() {
            switch (this) {
                case Never: {
                    return Slow;
                }
                case Slow: {
                    return Average;
                }
                case Fast: {
                    return Instant;
                }
                case Instant: {
                    return Never;
                }
            }
            return Fast;
        }
    }

    public static enum DebugLogMode {
        None("config.entity_texture_features.Debug_log_mode.none"),
        Log("config.entity_texture_features.Debug_log_mode.log"),
        Chat("config.entity_texture_features.Debug_log_mode.chat");

        private final String key;

        private DebugLogMode(String key) {
            this.key = key;
        }

        public String toString() {
            return ETFVersionDifferenceHandler.getTextFromTranslation(this.key).getString();
        }

        public DebugLogMode next() {
            switch (this) {
                case None: {
                    return Log;
                }
                case Log: {
                    return Chat;
                }
            }
            return None;
        }
    }
}

