/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.program;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntSupplier;
import net.coderbot.iris.gl.image.ImageBinding;
import net.coderbot.iris.gl.image.ImageHolder;
import net.coderbot.iris.gl.image.ImageLimits;
import net.coderbot.iris.gl.program.GlUniform1iCall;
import net.coderbot.iris.gl.texture.InternalTextureFormat;

public class ProgramImages {
    private final ImmutableList<ImageBinding> imageBindings;
    private List<GlUniform1iCall> initializer;

    private ProgramImages(ImmutableList<ImageBinding> immutableList, List<GlUniform1iCall> list) {
        this.imageBindings = immutableList;
        this.initializer = list;
    }

    public void update() {
        if (this.initializer != null) {
            for (GlUniform1iCall glUniform1iCall : this.initializer) {
                RenderSystem.glUniform1i((int)glUniform1iCall.getLocation(), (int)glUniform1iCall.getValue());
            }
            this.initializer = null;
        }
        for (ImageBinding imageBinding : this.imageBindings) {
            imageBinding.update();
        }
    }

    public int getActiveImages() {
        return this.imageBindings.size();
    }

    public static Builder builder(int n) {
        return new Builder(n);
    }

    public static final class Builder
    implements ImageHolder {
        private final int program;
        private final ImmutableList.Builder<ImageBinding> images;
        private final List<GlUniform1iCall> calls;
        private int nextImageUnit;
        private final int maxImageUnits;

        private Builder(int n) {
            this.program = n;
            this.images = ImmutableList.builder();
            this.calls = new ArrayList<GlUniform1iCall>();
            this.nextImageUnit = 0;
            this.maxImageUnits = ImageLimits.get().getMaxImageUnits();
        }

        @Override
        public boolean hasImage(String string) {
            return GlStateManager._glGetUniformLocation((int)this.program, (CharSequence)string) != -1;
        }

        @Override
        public void addTextureImage(IntSupplier intSupplier, InternalTextureFormat internalTextureFormat, String string) {
            int n = GlStateManager._glGetUniformLocation((int)this.program, (CharSequence)string);
            if (n == -1) {
                return;
            }
            if (this.nextImageUnit >= this.maxImageUnits) {
                if (this.maxImageUnits == 0) {
                    throw new IllegalStateException("Image units are not supported on this platform, but a shader program attempted to reference " + string + ".");
                }
                throw new IllegalStateException("No more available texture units while activating image " + string + ". Only " + this.maxImageUnits + " image units are available.");
            }
            if (internalTextureFormat == InternalTextureFormat.RGBA) {
                internalTextureFormat = InternalTextureFormat.RGBA8;
            }
            this.images.add((Object)new ImageBinding(this.nextImageUnit, internalTextureFormat.getGlFormat(), intSupplier));
            this.calls.add(new GlUniform1iCall(n, this.nextImageUnit));
            ++this.nextImageUnit;
        }

        public ProgramImages build() {
            return new ProgramImages((ImmutableList<ImageBinding>)this.images.build(), this.calls);
        }
    }
}

