/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.uniform;

import java.util.Arrays;
import java.util.function.Supplier;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.state.ValueUpdateNotifier;
import net.coderbot.iris.gl.uniform.Uniform;

public class Vector4ArrayUniform
extends Uniform {
    private float[] cachedValue = new float[4];
    private final Supplier<float[]> value;

    Vector4ArrayUniform(int n, Supplier<float[]> supplier) {
        this(n, supplier, null);
    }

    Vector4ArrayUniform(int n, Supplier<float[]> supplier, ValueUpdateNotifier valueUpdateNotifier) {
        super(n, valueUpdateNotifier);
        this.value = supplier;
    }

    @Override
    public void update() {
        this.updateValue();
        if (this.notifier != null) {
            this.notifier.setListener(this::updateValue);
        }
    }

    private void updateValue() {
        float[] fArray = this.value.get();
        if (!Arrays.equals(fArray, this.cachedValue)) {
            this.cachedValue = fArray;
            IrisRenderSystem.uniform4f(this.location, this.cachedValue[0], this.cachedValue[1], this.cachedValue[2], this.cachedValue[3]);
        }
    }
}

