/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla;

import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.library.plugins.vanilla.anvil.AnvilRecipe;
import mezz.jei.library.plugins.vanilla.brewing.BrewingRecipeUtil;
import mezz.jei.library.plugins.vanilla.brewing.JeiBrewingRecipe;
import net.minecraft.class_1799;

public class VanillaRecipeFactory
implements IVanillaRecipeFactory {
    private final BrewingRecipeUtil brewingRecipeUtil;

    public VanillaRecipeFactory(IIngredientManager ingredientManager) {
        IIngredientHelper<class_1799> ingredientHelper = ingredientManager.getIngredientHelper(VanillaTypes.ITEM_STACK);
        this.brewingRecipeUtil = new BrewingRecipeUtil(ingredientHelper);
    }

    @Override
    public AnvilRecipe createAnvilRecipe(class_1799 leftInput, List<class_1799> rightInputs, List<class_1799> outputs) {
        ErrorUtil.checkNotEmpty(leftInput, "leftInput");
        ErrorUtil.checkNotNull(rightInputs, "rightInputs");
        ErrorUtil.checkNotEmpty(outputs, "outputs");
        return new AnvilRecipe(List.of(leftInput), rightInputs, outputs);
    }

    @Override
    public AnvilRecipe createAnvilRecipe(List<class_1799> leftInputs, List<class_1799> rightInputs, List<class_1799> outputs) {
        ErrorUtil.checkNotEmpty(leftInputs, "leftInput");
        ErrorUtil.checkNotNull(rightInputs, "rightInputs");
        ErrorUtil.checkNotEmpty(outputs, "outputs");
        return new AnvilRecipe(leftInputs, rightInputs, outputs);
    }

    @Override
    public IJeiBrewingRecipe createBrewingRecipe(List<class_1799> ingredients, class_1799 potionInput, class_1799 potionOutput) {
        ErrorUtil.checkNotEmpty(ingredients, "ingredients");
        ErrorUtil.checkNotEmpty(potionInput, "potionInput");
        ErrorUtil.checkNotEmpty(potionOutput, "potionOutput");
        List<class_1799> potionInputs = List.of(potionInput);
        return new JeiBrewingRecipe(ingredients, potionInputs, potionOutput, this.brewingRecipeUtil);
    }

    @Override
    public IJeiBrewingRecipe createBrewingRecipe(List<class_1799> ingredients, List<class_1799> potionInputs, class_1799 potionOutput) {
        ErrorUtil.checkNotEmpty(ingredients, "ingredients");
        ErrorUtil.checkNotEmpty(potionInputs, "potionInputs");
        ErrorUtil.checkNotEmpty(potionOutput, "potionOutput");
        return new JeiBrewingRecipe(ingredients, potionInputs, potionOutput, this.brewingRecipeUtil);
    }
}

