/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor;

import com.luneruniverse.minecraft.mod.nbteditor.NBTEditor;
import com.luneruniverse.minecraft.mod.nbteditor.addons.NBTEditorAPI;
import com.luneruniverse.minecraft.mod.nbteditor.addons.NBTEditorAddon;
import com.luneruniverse.minecraft.mod.nbteditor.async.HeadRefreshThread;
import com.luneruniverse.minecraft.mod.nbteditor.clientchest.ClientChest;
import com.luneruniverse.minecraft.mod.nbteditor.clientchest.LargeClientChest;
import com.luneruniverse.minecraft.mod.nbteditor.clientchest.SmallClientChest;
import com.luneruniverse.minecraft.mod.nbteditor.commands.CommandHandler;
import com.luneruniverse.minecraft.mod.nbteditor.misc.NbtTypeModifier;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.containers.ClientChestScreen;
import com.luneruniverse.minecraft.mod.nbteditor.util.Enchants;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_490;
import tsp.headdb.ported.HeadAPI;

public class NBTEditorClient
implements ClientModInitializer {
    public static boolean CLIENT_LOADED = false;
    public static final File SETTINGS_FOLDER = new File("nbteditor");
    public static ClientChest CLIENT_CHEST;
    private static final Map<String, NBTEditorAddon> addons;

    public static NBTEditorAddon getAddon(String modId) {
        return addons.get(modId);
    }

    public static Map<String, NBTEditorAddon> getAddons() {
        return Collections.unmodifiableMap(addons);
    }

    public void onInitializeClient() {
        if (!SETTINGS_FOLDER.exists()) {
            SETTINGS_FOLDER.mkdir();
        }
        NbtTypeModifier.loadClass();
        Enchants.checkCap();
        CommandHandler.registerCommands();
        try {
            HeadAPI.loadFavorites();
        }
        catch (IOException e) {
            NBTEditor.LOGGER.error("Error while loading HeadDB favorites", (Throwable)e);
        }
        new HeadRefreshThread().start();
        ConfigScreen.loadSettings();
        CLIENT_CHEST = ConfigScreen.isLargeClientChest() ? new LargeClientChest(5) : new SmallClientChest(100);
        CLIENT_CHEST.loadAync();
        NBTEditorAPI.registerInventoryTab(new class_1799((class_1935)class_1802.field_8466).method_7977((class_2561)TextInst.translatable("itemGroup.nbteditor.client_chest", new Object[0])), ClientChestScreen::show);
        NBTEditorAPI.registerInventoryTab(new class_1799((class_1935)class_1802.field_20390).method_7977((class_2561)TextInst.translatable("itemGroup.nbteditor.creative", new Object[0])), () -> MainUtil.client.method_1507((class_437)new class_490((class_1657)MainUtil.client.field_1724)), screen -> screen instanceof ClientChestScreen);
        for (EntrypointContainer container : FabricLoader.getInstance().getEntrypointContainers("nbteditor", NBTEditorAddon.class)) {
            addons.put(container.getProvider().getMetadata().getId(), (NBTEditorAddon)container.getEntrypoint());
        }
        addons.forEach((id, addon) -> addon.onInit());
    }

    static {
        addons = new HashMap<String, NBTEditorAddon>();
    }
}

