/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.addons;

import com.luneruniverse.minecraft.mod.nbteditor.NBTEditorClient;
import com.luneruniverse.minecraft.mod.nbteditor.addons.NBTEditorAddon;
import com.luneruniverse.minecraft.mod.nbteditor.commands.ClientCommand;
import com.luneruniverse.minecraft.mod.nbteditor.commands.factories.FactoryCommand;
import com.luneruniverse.minecraft.mod.nbteditor.commands.get.GetCommand;
import com.luneruniverse.minecraft.mod.nbteditor.commands.get.GetPresetCommand;
import com.luneruniverse.minecraft.mod.nbteditor.containers.ContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.itemreferences.ItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.misc.NbtTypeModifier;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.commands.FabricClientCommandSource;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.CreativeTab;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigCategory;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigPath;
import com.luneruniverse.minecraft.mod.nbteditor.screens.factories.ItemFactoryScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.nbtmenugenerators.MenuGenerator;
import com.luneruniverse.minecraft.mod.nbteditor.util.NbtFormatter;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_4614;
import net.minecraft.class_4615;
import net.minecraft.class_481;

public class NBTEditorAPI {
    public static NBTEditorAddon getAddon(String modId) {
        return NBTEditorClient.getAddon(modId);
    }

    public static Map<String, NBTEditorAddon> getAddons() {
        return NBTEditorClient.getAddons();
    }

    public static void registerAdvancedItemFactory(final String name, final Consumer<LiteralArgumentBuilder<FabricClientCommandSource>> onRegister) {
        FactoryCommand.INSTANCE.getChildren().add(new ClientCommand(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public void register(LiteralArgumentBuilder<FabricClientCommandSource> builder) {
                onRegister.accept(builder);
            }
        });
    }

    public static void registerItemFactory(String name, Consumer<ItemReference> factory) {
        NBTEditorAPI.registerAdvancedItemFactory(name, builder -> builder.executes(context -> {
            factory.accept(ItemReference.getHeldItem());
            return 1;
        }));
    }

    public static void registerItemFactory(String name, class_2561 buttonMsg, Predicate<ItemReference> supported, Consumer<ItemReference> factory) {
        NBTEditorAPI.registerItemFactory(name, factory);
        ItemFactoryScreen.BASIC_FACTORIES.add(new ItemFactoryScreen.ItemFactoryReference(buttonMsg, supported, factory));
    }

    public static void registerGetCommand(final String name, final Consumer<LiteralArgumentBuilder<FabricClientCommandSource>> onRegister) {
        GetCommand.INSTANCE.getChildren().add(new ClientCommand(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public void register(LiteralArgumentBuilder<FabricClientCommandSource> builder) {
                onRegister.accept(builder);
            }
        });
    }

    public static void registerPresetItem(String name, Supplier<class_1799> item) {
        GetPresetCommand.registerPresetItem(name, item);
    }

    public static Supplier<class_1799> registerPresetItem(String name, boolean reloadable) {
        Supplier<class_1799> item;
        Supplier<class_1799> reloadHandledItem = item = GetPresetCommand.registerPresetItem(name);
        if (!reloadable) {
            reloadHandledItem = new Supplier<class_1799>(){
                private class_1799 value;

                @Override
                public class_1799 get() {
                    if (this.value == null) {
                        this.value = (class_1799)item.get();
                    }
                    return this.value;
                }
            };
            GetPresetCommand.registerPresetItem(name, reloadHandledItem);
        }
        return reloadHandledItem;
    }

    public static void registerContainer(class_1792 item, ContainerIO container) {
        ContainerIO.registerContainer(item, container);
    }

    public static void registerNBTMenuGenerator(byte type, MenuGenerator generator) {
        MenuGenerator.TYPES.put(type, generator);
    }

    public static class_4614<?> makeMutable(byte type) {
        return NbtTypeModifier.makeMutable(class_4615.method_23265((int)type));
    }

    public static void registerConfigItem(Consumer<ConfigCategory> item) {
        ConfigScreen.ADDED_OPTIONS.add(item);
    }

    public static void registerConfigItem(String name, Supplier<ConfigPath> item) {
        NBTEditorAPI.registerConfigItem(config -> config.setConfigurable(name, (ConfigPath)item.get()));
    }

    public static void registerInventoryTab(class_1799 item, Runnable onClick, Predicate<class_437> whenToShow) {
        CreativeTab.TABS.add(new CreativeTab.CreativeTabData(item, onClick, whenToShow));
    }

    public static void registerInventoryTab(class_1799 item, Runnable onClick) {
        NBTEditorAPI.registerInventoryTab(item, onClick, screen -> screen instanceof class_481);
    }

    public static void setNBTFormatter(NbtFormatter.Impl formatter) {
        NbtFormatter.FORMATTER = formatter;
    }
}

