/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.clientchest;

import com.luneruniverse.minecraft.mod.nbteditor.NBTEditor;
import com.luneruniverse.minecraft.mod.nbteditor.NBTEditorClient;
import com.luneruniverse.minecraft.mod.nbteditor.misc.MixinLink;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2558;
import net.minecraft.class_2561;

public abstract class ClientChest {
    protected static final File CLIENT_CHEST_FOLDER = new File(NBTEditorClient.SETTINGS_FOLDER, "client_chest");

    public void loadAync() {
        Thread loader = new Thread(() -> {
            try {
                this.loadSync();
            }
            catch (Exception e) {
                NBTEditor.LOGGER.error("Unable to load the client chest!", (Throwable)e);
            }
        }, "NBTEditor/Async/ClientChestLoader");
        loader.setDaemon(true);
        loader.start();
    }

    public abstract void loadSync() throws Exception;

    public class_1799[] loadSync(int page) throws Exception {
        File file = new File(CLIENT_CHEST_FOLDER, "page" + page + ".nbt");
        if (!file.exists()) {
            this.cacheEmptyPage(page);
            return null;
        }
        class_2499 pageNbt = class_2507.method_10633((File)file).method_10554("items", 10);
        class_1799[] items = new class_1799[54];
        boolean empty = true;
        int i = -1;
        for (class_2520 item : pageNbt) {
            items[++i] = class_1799.method_7915((class_2487)((class_2487)item));
            if (!empty || items[i] == null || items[i].method_7960()) continue;
            empty = false;
        }
        if (empty) {
            this.cacheEmptyPage(page);
            file.delete();
            return null;
        }
        this.cachePage(page, items);
        return items;
    }

    public void backupCorruptPage(int page) {
        File file = new File(CLIENT_CHEST_FOLDER, "page" + page + ".nbt");
        if (!file.exists()) {
            return;
        }
        file.renameTo(new File(CLIENT_CHEST_FOLDER, "corrupt_page" + page + "_" + System.currentTimeMillis() + ".nbt"));
        this.warnCorrupt();
    }

    public void warnIfCorrupt() {
        if (!CLIENT_CHEST_FOLDER.exists()) {
            return;
        }
        try {
            if (Files.list(CLIENT_CHEST_FOLDER.toPath()).anyMatch(path -> path.toFile().getName().startsWith("corrupt_page"))) {
                this.warnCorrupt();
            }
        }
        catch (IOException e) {
            NBTEditor.LOGGER.error("Error checking for corrupt pages", (Throwable)e);
        }
    }

    private void warnCorrupt() {
        if (MainUtil.client.field_1724 == null) {
            return;
        }
        MainUtil.client.field_1724.method_7353((class_2561)TextInst.translatable("nbteditor.client_chest.corrupt_warning", new Object[0]).append(" ").append(TextInst.translatable("nbteditor.file_options.show", new Object[0]).styled(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11746, CLIENT_CHEST_FOLDER.getAbsolutePath())))), false);
    }

    public abstract boolean isLoaded();

    protected void checkLoaded() {
        if (!this.isLoaded()) {
            throw new IllegalStateException("The client chest isn't loaded yet!");
        }
    }

    public abstract int getPageCount();

    public abstract class_1799[] getPage(int var1);

    public void setPage(int page, class_1799[] items) throws IOException {
        this.checkLoaded();
        if (!CLIENT_CHEST_FOLDER.exists()) {
            CLIENT_CHEST_FOLDER.mkdir();
        }
        File file = new File(CLIENT_CHEST_FOLDER, "page" + page + ".nbt");
        boolean allAir = true;
        for (class_1799 item : items) {
            if (item == null || item.method_7960()) continue;
            allAir = false;
            break;
        }
        if (allAir) {
            this.cacheEmptyPage(page);
            Files.deleteIfExists(file.toPath());
            return;
        }
        this.cachePage(page, items);
        class_2487 nbt = new class_2487();
        class_2499 pageNbt = new class_2499();
        for (int i = 0; i < items.length; ++i) {
            pageNbt.add((Object)(items[i] == null ? class_1799.field_8037 : items[i]).method_7953(new class_2487()));
        }
        nbt.method_10566("items", (class_2520)pageNbt);
        try {
            MixinLink.throwHiddenException(() -> class_2507.method_10630((class_2487)nbt, (File)file));
        }
        catch (Throwable e) {
            throw new IOException("Error saving client chest page", e);
        }
    }

    protected abstract void cachePage(int var1, class_1799[] var2);

    protected abstract void cacheEmptyPage(int var1);

    public abstract int[] getNearestItems(int var1);
}

