/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.clientchest;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.luneruniverse.minecraft.mod.nbteditor.NBTEditor;
import com.luneruniverse.minecraft.mod.nbteditor.clientchest.ClientChest;
import java.io.File;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1799;

public class LargeClientChest
extends ClientChest {
    private final int importantPages;
    private final Cache<Integer, Optional<class_1799[]>> pages;
    private volatile boolean loaded;

    public LargeClientChest(int importantPages) {
        this.importantPages = importantPages;
        this.pages = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build();
    }

    @Override
    public void loadSync() throws Exception {
        this.loaded = false;
        Exception toThrow = new Exception("Error loading page(s)");
        for (int i = 0; i < this.importantPages; ++i) {
            try {
                this.loadSync(i);
                continue;
            }
            catch (Exception e) {
                this.backupCorruptPage(i);
                this.pages.invalidate((Object)i);
                toThrow.addSuppressed(new Exception("Page " + (i + 1), e));
            }
        }
        this.loaded = true;
        if (toThrow.getSuppressed().length > 0) {
            throw toThrow;
        }
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public int getPageCount() {
        return Integer.MAX_VALUE;
    }

    @Override
    public class_1799[] getPage(int page) {
        try {
            return ((Optional)this.pages.get((Object)page, () -> Optional.ofNullable(this.loadSync(page)))).orElseGet(() -> new class_1799[54]);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            this.backupCorruptPage(page);
            this.pages.invalidate((Object)page);
            NBTEditor.LOGGER.error("Error loading large client chest page " + (page + 1), e);
            return new class_1799[54];
        }
    }

    @Override
    protected void cachePage(int page, class_1799[] items) {
        this.pages.put((Object)page, Optional.of(items));
    }

    @Override
    protected void cacheEmptyPage(int page) {
        this.pages.put((Object)page, Optional.empty());
    }

    @Override
    public int[] getNearestItems(int page) {
        int prev = -1;
        int next = -1;
        for (File file : CLIENT_CHEST_FOLDER.listFiles()) {
            if (!file.getName().matches("page[0-9]+\\.nbt")) continue;
            int i = Integer.parseInt(file.getName().substring("page".length(), file.getName().indexOf(46)));
            if (i < page && i > prev) {
                prev = i;
            }
            if (i <= page || i >= next && next != -1) continue;
            next = i;
        }
        return new int[]{prev, next};
    }
}

