/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.clientchest;

import com.luneruniverse.minecraft.mod.nbteditor.clientchest.ClientChest;
import java.util.HashMap;
import net.minecraft.class_1799;

public class SmallClientChest
extends ClientChest {
    private final int maxPages;
    private final HashMap<Integer, class_1799[]> pages;
    private volatile boolean loaded;

    public SmallClientChest(int maxPages) {
        this.maxPages = maxPages;
        this.pages = new HashMap();
        this.loaded = false;
    }

    @Override
    public void loadSync() throws Exception {
        this.loaded = false;
        Exception toThrow = new Exception("Error loading page(s)");
        for (int i = 0; i < this.maxPages; ++i) {
            try {
                this.loadSync(i);
                continue;
            }
            catch (Exception e) {
                this.backupCorruptPage(i);
                this.pages.remove(i);
                toThrow.addSuppressed(new Exception("Page " + (i + 1), e));
            }
        }
        this.loaded = true;
        if (toThrow.getSuppressed().length > 0) {
            throw toThrow;
        }
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public int getPageCount() {
        return this.maxPages;
    }

    @Override
    public class_1799[] getPage(int page) {
        this.checkLoaded();
        return this.pages.getOrDefault(page, new class_1799[54]);
    }

    @Override
    protected void cachePage(int page, class_1799[] items) {
        this.pages.put(page, items);
    }

    @Override
    protected void cacheEmptyPage(int page) {
        this.pages.remove(page);
    }

    @Override
    public int[] getNearestItems(int page) {
        this.checkLoaded();
        int prev = -1;
        int next = -1;
        for (int i : this.pages.keySet()) {
            if (i < page && i > prev) {
                prev = i;
            }
            if (i <= page || i >= next && next != -1) continue;
            next = i;
        }
        return new int[]{prev, next};
    }
}

