/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.commands;

import com.luneruniverse.minecraft.mod.nbteditor.multiversion.commands.ClientCommandManager;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.commands.FabricClientCommandSource;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.function.Consumer;

public abstract class ClientCommand {
    public static <T> T getDefaultArg(CommandContext<FabricClientCommandSource> context, String name, T defaultValue, Class<T> type) {
        try {
            return (T)context.getArgument(name, type);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public void registerAll(Consumer<LiteralArgumentBuilder<FabricClientCommandSource>> commandHandler) {
        LiteralArgumentBuilder<FabricClientCommandSource> builder = ClientCommandManager.literal(this.getName());
        this.register(builder);
        commandHandler.accept(builder);
        List<String> aliases = this.getAliases();
        if (aliases != null) {
            for (String alias : aliases) {
                builder = ClientCommandManager.literal(alias);
                this.register(builder);
                commandHandler.accept(builder);
            }
        }
    }

    public abstract String getName();

    public List<String> getAliases() {
        return null;
    }

    public abstract void register(LiteralArgumentBuilder<FabricClientCommandSource> var1);

    public ClientCommand getShortcut(List<String> path, int index) {
        if (path.size() == index) {
            return this;
        }
        return null;
    }
}

