/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.commands.arguments;

import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVRegistry;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2960;

public class EffectListArgumentType
implements ArgumentType<Collection<class_1293>> {
    private static final Collection<String> EXAMPLES = Arrays.asList("minecraft:blindness duration:1 showparticles:false", "minecraft:jump_boost");
    public static final DynamicCommandExceptionType INVALID_EFFECT_EXCEPTION = new DynamicCommandExceptionType(id -> TextInst.translatable("effect.effectNotFound", id));

    public static EffectListArgumentType effectList() {
        return new EffectListArgumentType();
    }

    public static Collection<class_1293> getStatusEffectInstance(CommandContext<class_2168> context, String name) {
        return (Collection)context.getArgument(name, Collection.class);
    }

    public Collection<class_1293> parse(StringReader stringReader) throws CommandSyntaxException {
        ArrayList<class_1293> effects = new ArrayList<class_1293>();
        while (stringReader.canRead()) {
            class_2960 identifier = class_2960.method_12835((StringReader)stringReader);
            class_1291 type = MVRegistry.STATUS_EFFECT.getOrEmpty(identifier).orElseThrow(() -> INVALID_EFFECT_EXCEPTION.create((Object)identifier));
            if (!stringReader.canRead()) {
                effects.add(new class_1293(type, 100));
                break;
            }
            if (stringReader.read() != ' ') {
                throw new SimpleCommandExceptionType((Message)TextInst.translatable("nbteditor.effect_list_arg_type.expected.space", new Object[0])).createWithContext((ImmutableStringReader)stringReader);
            }
            class_1293 effect = new class_1293(type, 100);
            while (stringReader.canRead() && stringReader.peek() == '-') {
                StringBuilder arg = new StringBuilder();
                while (stringReader.canRead() && stringReader.peek() != ':') {
                    arg.append(stringReader.read());
                }
                Arg key = Arrays.stream(Arg.values()).filter(test -> test.name.equalsIgnoreCase(arg.toString())).findFirst().orElse(null);
                if (key == null) {
                    throw new SimpleCommandExceptionType((Message)TextInst.translatable("nbteditor.effect_list_arg_type.invalid.arg", new Object[0])).createWithContext((ImmutableStringReader)stringReader);
                }
                if (!stringReader.canRead()) {
                    throw new SimpleCommandExceptionType((Message)TextInst.translatable("nbteditor.effect_list_arg_type.expected.colon", new Object[0])).createWithContext((ImmutableStringReader)stringReader);
                }
                stringReader.read();
                StringBuilder value = new StringBuilder();
                while (stringReader.canRead() && stringReader.peek() != ' ') {
                    value.append(stringReader.read());
                }
                try {
                    effect = key.apply.apply(effect, value.toString());
                }
                catch (Exception e) {
                    throw new SimpleCommandExceptionType((Message)TextInst.translatable("nbteditor.effect_list_arg_type.invalid.value", new Object[0])).createWithContext((ImmutableStringReader)stringReader);
                }
                if (!stringReader.canRead()) continue;
                stringReader.read();
            }
            effects.add(effect);
        }
        return effects;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        boolean afterFirstEffect = builder.getRemaining().contains(" ");
        builder = builder.createOffset(builder.getInput().lastIndexOf(" ") + 1);
        if (afterFirstEffect) {
            int colonPos;
            for (Arg arg : Arg.values()) {
                if (!(arg.name + ":").startsWith(builder.getRemainingLowerCase())) continue;
                builder.suggest(arg.name + ":");
            }
            if (builder.getRemaining().startsWith("-") && (colonPos = builder.getRemaining().indexOf(":")) != -1) {
                String argStr = builder.getRemaining().substring(0, colonPos);
                for (Arg arg : Arg.values()) {
                    if (!arg.name.equals(argStr)) continue;
                    if (!arg.isBoolean) break;
                    String value = builder.getRemaining().substring(colonPos + 1);
                    if ("true".startsWith(value.toLowerCase())) {
                        builder.suggest(argStr + ":true");
                    }
                    if (!"false".startsWith(value.toLowerCase())) break;
                    builder.suggest(argStr + ":false");
                    break;
                }
            }
        }
        return class_2172.method_9270(MVRegistry.STATUS_EFFECT.getIds(), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static enum Arg {
        DURATION("-duration", (effect, str) -> new class_1293(effect.method_5579(), Integer.parseInt(str) * 20, effect.method_5578(), effect.method_5591(), effect.method_5581(), effect.method_5592()), false),
        AMPLIFIER("-amplifier", (effect, str) -> new class_1293(effect.method_5579(), effect.method_5584(), Integer.parseInt(str), effect.method_5591(), effect.method_5581(), effect.method_5592()), false),
        AMBIENT("-ambient", (effect, str) -> new class_1293(effect.method_5579(), effect.method_5584(), effect.method_5578(), Arg.parseBoolean(str), effect.method_5581(), effect.method_5592()), true),
        PERMANENT("-permanent", (effect, str) -> new class_1293(effect.method_5579(), Integer.MAX_VALUE, effect.method_5578(), effect.method_5591(), effect.method_5581(), effect.method_5592()), true),
        SHOW_PARTICLES("-showparticles", (effect, str) -> new class_1293(effect.method_5579(), effect.method_5584(), effect.method_5578(), effect.method_5591(), Arg.parseBoolean(str), effect.method_5592()), true),
        SHOW_ICON("-showicon", (effect, str) -> new class_1293(effect.method_5579(), effect.method_5584(), effect.method_5578(), effect.method_5591(), effect.method_5581(), Arg.parseBoolean(str)), true);

        private final String name;
        private final BiFunction<class_1293, String, class_1293> apply;
        private final boolean isBoolean;

        private static boolean parseBoolean(String str) {
            if (str.equalsIgnoreCase("true")) {
                return true;
            }
            if (str.equalsIgnoreCase("false")) {
                return false;
            }
            throw new IllegalArgumentException("Expected true or false");
        }

        private Arg(String name, BiFunction<class_1293, String, class_1293> apply, boolean isBoolean) {
            this.name = name;
            this.apply = apply;
            this.isBoolean = isBoolean;
        }
    }
}

