/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.commands.arguments;

import com.google.gson.JsonElement;
import com.luneruniverse.minecraft.mod.nbteditor.itemreferences.ItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.EditableText;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import java.util.stream.StreamSupport;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2178;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;

public class FancyTextArgumentType
implements ArgumentType<class_2561> {
    private static final class_2583 BLANK_STYLE = class_2583.field_24360.method_10977(class_124.field_1068).method_10982(Boolean.valueOf(false)).method_10978(Boolean.valueOf(false)).method_30938(Boolean.valueOf(false)).method_36140(Boolean.valueOf(false)).method_36141(Boolean.valueOf(false));
    private static final List<String> eventTypes = List.of("[open_url]", "[run_command]", "[suggest_command]", "[change_page]", "[copy_to_clipboard]", "[show_text]", "[show_item]", "[show_entity]");
    private final boolean jsonAllowed;

    public static FancyTextArgumentType fancyText(boolean jsonAllowed) {
        return new FancyTextArgumentType(jsonAllowed);
    }

    public static FancyTextArgumentType fancyText() {
        return FancyTextArgumentType.fancyText(true);
    }

    public static String stringifyFancyText(class_2561 text, boolean jsonAllowed, boolean printErrors) {
        if (jsonAllowed && ConfigScreen.isJsonText()) {
            return class_2561.class_2562.method_10867((class_2561)text);
        }
        StringBuilder output = new StringBuilder();
        if (FancyTextArgumentType.stringifyFancyText(text, output) && printErrors) {
            MainUtil.client.field_1724.method_7353((class_2561)TextInst.translatable("nbteditor.fancy_text_arg_type.stringify_unsupported", new Object[0]), false);
        }
        return output.toString();
    }

    private static boolean stringifyFancyText(class_2561 text, StringBuilder output) {
        boolean errors = false;
        int numEvents = 0;
        class_2558 click = text.method_10866().method_10970();
        class_2568 hover = text.method_10866().method_10969();
        if (click != null) {
            ++numEvents;
            output.append("[" + click.method_10845().method_10846() + "]");
            output.append("{");
            output.append(click.method_10844().replace("\\", "\\\\").replace("{", "\\{").replace("}", "\\}"));
            output.append("}");
            output.append("(");
        }
        if (hover != null) {
            ++numEvents;
            output.append("[" + hover.method_10892().method_27674() + "]");
            if (hover.method_10892() == class_2568.class_5247.field_24342) {
                StringBuilder buffer = new StringBuilder();
                errors |= FancyTextArgumentType.stringifyFancyText((class_2561)hover.method_10891(class_2568.class_5247.field_24342), buffer);
                output.append("{" + buffer.toString().replace("}", "\\}") + "}");
            } else if (hover.method_10892() == class_2568.class_5247.field_24343) {
                errors = true;
            } else if (hover.method_10892() == class_2568.class_5247.field_24344) {
                output.append("{" + ((class_2568.class_5248)hover.method_10891((class_2568.class_5247)class_2568.class_5247.field_24344)).field_24352.toString() + "}");
                errors = true;
            }
            output.append("(");
        }
        StringBuilder color = new StringBuilder();
        StringBuilder formats = new StringBuilder();
        boolean needsReset = false;
        for (Map.Entry entry : class_2561.class_2562.method_10868((class_2561)text).getAsJsonObject().entrySet()) {
            switch ((String)entry.getKey()) {
                case "color": {
                    class_124 colorFormatting = class_124.method_533((String)text.method_10866().method_10973().method_27721());
                    if (colorFormatting == null) {
                        color.append("&c");
                        errors = true;
                        break;
                    }
                    color.append("&" + colorFormatting.method_36145());
                    break;
                }
                case "bold": 
                case "italic": 
                case "strikethrough": 
                case "obfuscated": {
                    if (((JsonElement)entry.getValue()).getAsBoolean()) {
                        formats.append("&" + class_124.method_533((String)((String)entry.getKey())).method_36145());
                        break;
                    }
                    needsReset = true;
                    break;
                }
                case "underlined": {
                    if (((JsonElement)entry.getValue()).getAsBoolean()) {
                        formats.append("&" + class_124.field_1073.method_36145());
                        break;
                    }
                    needsReset = true;
                    break;
                }
                case "insertion": 
                case "font": {
                    errors = true;
                }
            }
        }
        if (needsReset) {
            output.append("&r");
        }
        if (!needsReset || !color.toString().equals("&f")) {
            output.append((CharSequence)color);
        }
        output.append((CharSequence)formats);
        StringBuilder content = new StringBuilder();
        text.method_10851().method_27659(str -> {
            content.append(str);
            return Optional.empty();
        });
        output.append(content.toString().replace("\\", "\\\\").replace("&", "\\&").replace("\u00a7", "\\\u00a7").replace("[", "\\["));
        for (class_2561 child : text.method_10855()) {
            errors |= FancyTextArgumentType.stringifyFancyText(child, output);
        }
        output.append(")".repeat(numEvents));
        return errors;
    }

    private FancyTextArgumentType(boolean jsonAllowed) {
        this.jsonAllowed = jsonAllowed;
    }

    public class_2561 parse(StringReader reader) throws CommandSyntaxException {
        if (this.jsonAllowed && ConfigScreen.isJsonText()) {
            return class_2178.method_9281().method_9283(reader);
        }
        return this.parseInternal(reader);
    }

    private EditableText parseInternal(StringReader reader) throws CommandSyntaxException {
        Object str = "";
        boolean event = false;
        boolean escaped = false;
        while (reader.canRead()) {
            char c = reader.read();
            if (escaped) {
                str = (String)str + "\\";
                str = (String)str + c;
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == '[') {
                event = true;
                break;
            }
            str = (String)str + c;
        }
        EditableText output = this.parseColors((String)str);
        if (event) {
            String eventType;
            UnaryOperator eventAdder = switch (eventType = reader.readStringUntil(']')) {
                case "open_url", "run_command", "suggest_command", "change_page", "copy_to_clipboard" -> {
                    reader.expect('{');
                    String value = this.readUntilClosed(reader, '{', '}');
                    yield style -> style.method_10958(new class_2558(class_2558.class_2559.method_10848((String)eventType), value));
                }
                case "show_text" -> {
                    reader.expect('{');
                    EditableText tooltip = this.parseInternal(new StringReader(this.readUntilClosed(reader, '{', '}')));
                    yield style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)tooltip));
                }
                case "show_item" -> {
                    class_1799 item;
                    if (reader.peek() == '{') {
                        reader.skip();
                        int slot = reader.readInt();
                        reader.expect('}');
                        item = MainUtil.client.field_1724.method_31548().method_5438(slot);
                    } else {
                        item = ItemReference.getHeldItem().getItem();
                    }
                    yield style -> style.method_10949(new class_2568(class_2568.class_5247.field_24343, (Object)new class_2568.class_5249(item)));
                }
                case "show_entity" -> {
                    Object entity;
                    if (reader.peek() == '{') {
                        reader.skip();
                        String uuid = reader.readStringUntil('}');
                        if (!uuid.contains("-")) {
                            uuid = uuid.replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5");
                        }
                        UUID uuidObj = UUID.fromString(uuid);
                        entity = StreamSupport.stream(MainUtil.client.field_1687.method_18112().spliterator(), false).filter(testEntity -> testEntity.method_5667().equals(uuidObj)).findFirst().orElseThrow(() -> new SimpleCommandExceptionType((Message)TextInst.translatable("nbteditor.fancy_text_arg_type.invalid.entity", new Object[0])).createWithContext((ImmutableStringReader)reader));
                    } else {
                        entity = MainUtil.client.field_1692 != null ? MainUtil.client.field_1692 : MainUtil.client.field_1724;
                    }
                    yield arg_0 -> FancyTextArgumentType.lambda$parseInternal$6((class_1297)entity, arg_0);
                }
                default -> throw new SimpleCommandExceptionType((Message)TextInst.translatable("nbteditor.fancy_text_arg_type.invalid.event_type", new Object[0])).createWithContext((ImmutableStringReader)reader);
            };
            reader.expect('(');
            EditableText affectedText = this.parseInternal(new StringReader(this.readUntilClosed(reader, '(', ')')));
            affectedText.styled(eventAdder);
            output.append(affectedText);
        }
        if (reader.canRead()) {
            output.append(this.parseInternal(reader));
        }
        return output;
    }

    private EditableText parseColors(String str) {
        ArrayList<EditableText> parts = new ArrayList<EditableText>();
        Object part = "";
        class_124 color = null;
        ArrayList<class_124> format = new ArrayList<class_124>();
        boolean reset = false;
        boolean escaped = false;
        boolean formatting = false;
        for (char c : str.toCharArray()) {
            if (formatting) {
                formatting = false;
                class_124 newFormat = class_124.method_544((char)c);
                if (newFormat == null) {
                    part = (String)part + c;
                    continue;
                }
                if (!((String)part).isEmpty()) {
                    EditableText partText = TextInst.literal((String)part);
                    if (reset) {
                        partText.styled(style -> BLANK_STYLE);
                        if (parts.isEmpty()) {
                            reset = false;
                        }
                    }
                    if (color != null) {
                        partText.formatted(color);
                    }
                    format.forEach(xva$0 -> partText.formatted((class_124)xva$0));
                    parts.add(partText);
                    part = "";
                }
                if (newFormat == class_124.field_1070) {
                    color = null;
                    format.clear();
                    reset = true;
                    continue;
                }
                if (newFormat.method_543()) {
                    color = newFormat;
                    format.clear();
                    continue;
                }
                format.add(newFormat);
                continue;
            }
            if (escaped) {
                part = (String)part + c;
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == '&' || c == '\u00a7') {
                formatting = true;
                continue;
            }
            part = (String)part + c;
        }
        if (!((String)part).isEmpty()) {
            EditableText partText = TextInst.literal((String)part);
            if (reset) {
                partText.styled(style -> BLANK_STYLE);
            }
            if (color != null) {
                partText.formatted(color);
            }
            format.forEach(xva$0 -> partText.formatted((class_124)xva$0));
            parts.add(partText);
        }
        if (parts.isEmpty()) {
            return TextInst.literal("");
        }
        EditableText output = (EditableText)parts.get(0);
        for (int i = 1; i < parts.size(); ++i) {
            output.append((class_2561)parts.get(i));
        }
        return output;
    }

    private String readUntilClosed(StringReader reader, char open, char close) throws CommandSyntaxException {
        StringBuilder output = new StringBuilder();
        int level = 0;
        boolean escaped = false;
        while (reader.canRead()) {
            char c = reader.read();
            if (escaped) {
                escaped = false;
            } else if (c == '\\') {
                escaped = true;
            } else if (c == open) {
                ++level;
            } else if (c == close && --level == -1) break;
            output.append(c);
        }
        if (level != -1) {
            reader.expect(close);
        }
        return output.toString();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        block7: {
            int lastCloseEvent;
            int lastEvent;
            block9: {
                String event;
                int lastIndex;
                block8: {
                    int lastCloseValue;
                    int lastValue;
                    block6: {
                        if (this.jsonAllowed && ConfigScreen.isJsonText()) {
                            return class_2178.method_9281().listSuggestions(context, builder);
                        }
                        if (builder.getRemaining().isEmpty()) {
                            return builder.buildFuture();
                        }
                        int lastColor = Math.max(builder.getRemaining().lastIndexOf(38), builder.getRemaining().lastIndexOf(167));
                        lastEvent = builder.getRemaining().lastIndexOf(91);
                        lastCloseEvent = builder.getRemaining().lastIndexOf(93);
                        lastValue = builder.getRemaining().lastIndexOf(123);
                        lastCloseValue = builder.getRemaining().lastIndexOf(125);
                        lastIndex = builder.getRemaining().length() - 1;
                        if (lastColor != lastIndex) break block6;
                        builder = builder.createOffset(builder.getStart() + lastColor + 1);
                        for (class_124 format : class_124.values()) {
                            builder.suggest("" + format.method_36145(), () -> format.method_537());
                        }
                        break block7;
                    }
                    if (lastCloseValue != lastIndex) break block8;
                    if (lastValue == -1) break block7;
                    builder = builder.createOffset(builder.getStart() + lastCloseValue + 1);
                    builder.suggest("(");
                    break block7;
                }
                if (lastCloseEvent != lastIndex) break block9;
                if (lastEvent == -1 || !eventTypes.contains(event = builder.getRemaining().substring(lastEvent, lastCloseEvent + 1))) break block7;
                builder = builder.createOffset(builder.getStart() + lastCloseEvent + 1);
                builder.suggest("{");
                if (event.equals("[show_item]") || event.equals("[show_entity]")) {
                    builder.suggest("(");
                }
                break block7;
            }
            if (lastEvent > lastCloseEvent) {
                builder = builder.createOffset(builder.getStart() + lastEvent);
                String event = builder.getRemaining();
                for (String suggestEvent : eventTypes) {
                    if (!suggestEvent.startsWith(event)) continue;
                    builder.suggest(suggestEvent);
                }
            }
        }
        return builder.buildFuture();
    }

    private static /* synthetic */ class_2583 lambda$parseInternal$6(class_1297 entity, class_2583 style) {
        return style.method_10949(new class_2568(class_2568.class_5247.field_24344, (Object)new class_2568.class_5248(entity.method_5864(), entity.method_5667(), entity.method_5477())));
    }
}

