/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.commands.factories;

import com.luneruniverse.minecraft.mod.nbteditor.NBTEditor;
import com.luneruniverse.minecraft.mod.nbteditor.NBTEditorClient;
import com.luneruniverse.minecraft.mod.nbteditor.commands.ClientCommand;
import com.luneruniverse.minecraft.mod.nbteditor.commands.arguments.FancyTextArgumentType;
import com.luneruniverse.minecraft.mod.nbteditor.itemreferences.ItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.commands.ClientCommandManager;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.commands.FabricClientCommandSource;
import com.luneruniverse.minecraft.mod.nbteditor.util.Lore;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2561;

public class SignatureCommand
extends ClientCommand {
    private static final File SIGNATURE_FILE = new File(NBTEditorClient.SETTINGS_FOLDER, "signature.json");
    private static class_2561 signature;

    @Override
    public String getName() {
        return "signature";
    }

    @Override
    public List<String> getAliases() {
        return List.of("sign");
    }

    @Override
    public void register(LiteralArgumentBuilder<FabricClientCommandSource> builder) {
        Command addSignature = context -> {
            ItemReference ref = ItemReference.getHeldItem();
            class_1799 item = ref.getItem();
            Lore lore = new Lore(item);
            if (SignatureCommand.hasSignature(lore)) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback(TextInst.translatable("nbteditor.sign.already_added", new Object[0]));
                return 1;
            }
            lore.addLine(signature);
            ref.saveItem(item, TextInst.translatable("nbteditor.sign.added", new Object[0]));
            return 1;
        };
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.executes(addSignature)).then(ClientCommandManager.literal("add").executes(addSignature))).then(ClientCommandManager.literal("remove").executes(context -> {
            ItemReference ref = ItemReference.getHeldItem();
            class_1799 item = ref.getItem();
            Lore lore = new Lore(item);
            if (!SignatureCommand.hasSignature(lore)) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback(TextInst.translatable("nbteditor.sign.not_added", new Object[0]));
                return 1;
            }
            lore.removeLine(-1);
            ref.saveItem(item, TextInst.translatable("nbteditor.sign.removed", new Object[0]));
            return 1;
        }))).then(ClientCommandManager.literal("edit").then(ClientCommandManager.argument("signature", FancyTextArgumentType.fancyText()).executes(context -> {
            class_2561 oldSignature = signature;
            try {
                signature = (class_2561)context.getArgument("signature", class_2561.class);
            }
            catch (IllegalArgumentException e) {
                throw new SimpleCommandExceptionType((Message)TextInst.translatable("nbteditor.sign.new.missing_arg", new Object[0])).create();
            }
            try {
                Files.write(SIGNATURE_FILE.toPath(), class_2561.class_2562.method_10867((class_2561)signature).getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                NBTEditor.LOGGER.error("Error while saving signature", (Throwable)e);
                throw new SimpleCommandExceptionType((Message)TextInst.translatable("nbteditor.sign.save_error", new Object[0])).create();
            }
            ItemReference ref = ItemReference.getHeldItem();
            class_1799 item = ref.getItem();
            Lore lore = new Lore(item);
            if (SignatureCommand.hasSignature(lore, oldSignature)) {
                lore.setLine(signature, -1);
                ref.saveItem(item, TextInst.translatable("nbteditor.sign.edited", new Object[0]));
            }
            return 1;
        })));
    }

    private static boolean hasSignature(Lore lore, class_2561 signature) {
        if (lore.isEmpty()) {
            return false;
        }
        return lore.getLine(-1).getString().equals(signature.getString());
    }

    private static boolean hasSignature(Lore lore) {
        return SignatureCommand.hasSignature(lore, signature);
    }

    static {
        if (!SIGNATURE_FILE.exists()) {
            signature = TextInst.translatable("nbteditor.sign.default", new Object[0]);
        } else {
            try {
                signature = class_2561.class_2562.method_10877((String)new String(Files.readAllBytes(SIGNATURE_FILE.toPath())));
            }
            catch (IOException e) {
                NBTEditor.LOGGER.error("Error while loading signature", (Throwable)e);
                signature = TextInst.translatable("nbteditor.sign.load_error", new Object[0]);
            }
        }
    }
}

