/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.commands.get;

import com.luneruniverse.minecraft.mod.nbteditor.commands.ClientCommand;
import com.luneruniverse.minecraft.mod.nbteditor.commands.arguments.EnumArgumentType;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.commands.ClientCommandManager;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.commands.FabricClientCommandSource;
import com.luneruniverse.minecraft.mod.nbteditor.util.ItemChest;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import net.minecraft.class_124;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2480;
import tsp.headdb.ported.Category;
import tsp.headdb.ported.Head;
import tsp.headdb.ported.HeadAPI;
import tsp.headdb.ported.inventory.InventoryUtils;

public class GetHdbCommand
extends ClientCommand {
    @Override
    public String getName() {
        return "hdb";
    }

    @Override
    public void register(LiteralArgumentBuilder<FabricClientCommandSource> builder) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.then(ClientCommandManager.literal("search").then(ClientCommandManager.argument("query", StringArgumentType.greedyString()).executes(context -> {
            HeadAPI.openSearchDatabase((String)context.getArgument("query", String.class));
            return 1;
        })))).then(ClientCommandManager.literal("tagsearch").then(ClientCommandManager.argument("query", StringArgumentType.greedyString()).executes(context -> {
            HeadAPI.openTagSearchDatabase((String)context.getArgument("query", String.class));
            return 1;
        })))).then(ClientCommandManager.literal("id").then(((RequiredArgumentBuilder)ClientCommandManager.argument("id", IntegerArgumentType.integer((int)1)).then(ClientCommandManager.argument("amount", IntegerArgumentType.integer((int)1)).executes(context -> {
            Head head = HeadAPI.getHeadByID((Integer)context.getArgument("id", Integer.class));
            if (head == null) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback(TextInst.translatable("nbteditor.hdb.head_not_found", new Object[0]));
            } else {
                InventoryUtils.purchaseHead(head, (Integer)context.getArgument("amount", Integer.class), "", "");
            }
            return 1;
        }))).executes(context -> {
            Head head = HeadAPI.getHeadByID((Integer)context.getArgument("id", Integer.class));
            if (head == null) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback(TextInst.translatable("nbteditor.hdb.head_not_found", new Object[0]));
            } else {
                InventoryUtils.purchaseHead(head, 1, "", "");
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)ClientCommandManager.literal("all").then(ClientCommandManager.argument("category", EnumArgumentType.options(Category.class)).executes(context -> {
            Category category = (Category)((Object)((Object)context.getArgument("category", Category.class)));
            class_1799 shulker = class_2480.method_10529((class_1767)MainUtil.getDyeColor(category.getColor()));
            shulker.method_7977(TextInst.of(class_124.field_1070.toString() + category.getColor() + class_124.field_1067 + category.getTranslatedName().toUpperCase()));
            shulker.method_7948().method_10567("HideFlags", (byte)32);
            ItemChest.writeDatabase(shulker, HeadAPI.getHeads(category), Head::getItemStack);
            MainUtil.getWithMessage(shulker);
            return 1;
        }))).then(ClientCommandManager.literal("search").then(ClientCommandManager.argument("query", StringArgumentType.greedyString()).executes(context -> {
            String query = (String)context.getArgument("query", String.class);
            class_1799 shulker = new class_1799((class_1935)class_1802.field_8584);
            shulker.method_7977(TextInst.of(class_124.field_1070.toString() + class_124.field_1065 + class_124.field_1067 + TextInst.translatable("nbteditor.hdb.search", new Object[0]).getString() + ": " + query));
            shulker.method_7948().method_10567("HideFlags", (byte)32);
            ItemChest.writeDatabase(shulker, HeadAPI.getHeadsByName(query), Head::getItemStack);
            MainUtil.getWithMessage(shulker);
            return 1;
        }))))).then(ClientCommandManager.literal("update").executes(context -> {
            ((FabricClientCommandSource)context.getSource()).sendFeedback(TextInst.translatable("nbteditor.hdb.updating_database", new Object[0]));
            Thread thread = new Thread(() -> {
                HeadAPI.updateDatabase();
                ((FabricClientCommandSource)context.getSource()).sendFeedback(TextInst.translatable("nbteditor.hdb.updated_database", new Object[0]));
            }, "NBTEditor/Async/HeadRefresh/Manual");
            thread.setDaemon(true);
            thread.start();
            return 1;
        }))).executes(context -> {
            if (HeadAPI.checkUpdated()) {
                HeadAPI.openDatabase();
            }
            return 1;
        });
    }
}

