/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.commands.nbt;

import com.luneruniverse.minecraft.mod.nbteditor.NBTEditor;
import com.luneruniverse.minecraft.mod.nbteditor.NBTEditorClient;
import com.luneruniverse.minecraft.mod.nbteditor.commands.ClientCommand;
import com.luneruniverse.minecraft.mod.nbteditor.itemreferences.ItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVRegistry;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.commands.ClientCommandManager;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.commands.FabricClientCommandSource;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import com.luneruniverse.minecraft.mod.nbteditor.util.TextUtil;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_4239;

public class NBTExportCommand
extends ClientCommand {
    private static final File exportDir = new File(NBTEditorClient.SETTINGS_FOLDER, "exported");

    private static class_1799 getItemToExport() throws CommandSyntaxException {
        return ItemReference.getHeldItem(item -> true, TextInst.translatable("nbteditor.no_hand.no_item.to_export", new Object[0])).getItem();
    }

    private static String getItemToExportStr() throws CommandSyntaxException {
        class_1799 item = NBTExportCommand.getItemToExport();
        return MVRegistry.ITEM.getId(item.method_7909()).toString() + (item.method_7969() == null ? "" : item.method_7969().method_10714()) + " " + item.method_7947();
    }

    private static void exportToClipboard(String str) {
        MainUtil.client.field_1774.method_1455(str);
        MainUtil.client.field_1724.method_7353((class_2561)TextInst.translatable("nbteditor.nbt.export.copied", new Object[0]), false);
    }

    private static void exportToFile(class_1799 item, String name) {
        try {
            if (!exportDir.exists()) {
                Files.createDirectory(exportDir.toPath(), new FileAttribute[0]);
            }
            File output = new File(exportDir, class_4239.method_19773((Path)exportDir.toPath(), (String)name, (String)".nbt"));
            class_2507.method_30614((class_2487)item.method_7953(new class_2487()), (File)output);
            MainUtil.client.field_1724.method_7353(TextUtil.attachFileTextOptions(TextInst.translatable("nbteditor.nbt.export.file.success", TextInst.literal(output.getName()).formatted(class_124.field_1073).styled(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11746, output.getAbsolutePath())))), output), false);
        }
        catch (Exception e) {
            NBTEditor.LOGGER.error("Error while exporting item", (Throwable)e);
            MainUtil.client.field_1724.method_7353((class_2561)TextInst.translatable("nbteditor.nbt.export.file.error", e.getMessage()), false);
        }
    }

    @Override
    public String getName() {
        return "export";
    }

    @Override
    public void register(LiteralArgumentBuilder<FabricClientCommandSource> builder) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.then(ClientCommandManager.literal("give").executes(context -> {
            NBTExportCommand.exportToClipboard("/give @p " + NBTExportCommand.getItemToExportStr());
            return 1;
        }))).then(ClientCommandManager.literal("get").executes(context -> {
            NBTExportCommand.exportToClipboard("/get item " + NBTExportCommand.getItemToExportStr());
            return 1;
        }))).then(ClientCommandManager.literal("cmdblock").executes(context -> {
            class_1799 cmdBlock = new class_1799((class_1935)class_1802.field_8866);
            cmdBlock.method_7911("BlockEntityTag").method_10582("Command", "/give @p " + NBTExportCommand.getItemToExportStr());
            MainUtil.getWithMessage(cmdBlock);
            return 1;
        }))).then(((LiteralArgumentBuilder)ClientCommandManager.literal("file").then(ClientCommandManager.argument("name", StringArgumentType.greedyString()).executes(context -> {
            NBTExportCommand.exportToFile(NBTExportCommand.getItemToExport(), (String)context.getArgument("name", String.class));
            return 1;
        }))).executes(context -> {
            class_1799 item = NBTExportCommand.getItemToExport();
            NBTExportCommand.exportToFile(item, item.method_7964().getString() + "_" + MainUtil.getFormattedCurrentTime());
            return 1;
        }));
    }
}

