/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.itemreferences;

import com.luneruniverse.minecraft.mod.nbteditor.NBTEditor;
import com.luneruniverse.minecraft.mod.nbteditor.NBTEditorClient;
import com.luneruniverse.minecraft.mod.nbteditor.itemreferences.ItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.containers.ClientChestScreen;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import com.luneruniverse.minecraft.mod.nbteditor.util.SaveQueue;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_2561;

public class ClientChestItemReference
implements ItemReference {
    private final int page;
    private final int slot;
    private final SaveQueue save;

    public ClientChestItemReference(int page, int slot) {
        this.page = page;
        this.slot = slot;
        this.save = new SaveQueue("Client Chest", toSave -> {
            class_1799[] items = NBTEditorClient.CLIENT_CHEST.getPage(page);
            items[slot] = toSave;
            try {
                NBTEditorClient.CLIENT_CHEST.setPage(page, items);
                if (MainUtil.client.field_1755 instanceof ClientChestScreen && ClientChestScreen.PAGE == page) {
                    ((class_1707)((ClientChestScreen)MainUtil.client.field_1755).method_17577()).method_7611(slot).method_7673(toSave);
                }
            }
            catch (Exception e) {
                NBTEditor.LOGGER.error("Error while saving client chest", (Throwable)e);
                MainUtil.client.field_1724.method_7353((class_2561)TextInst.translatable("nbteditor.client_chest.save_error", new Object[0]), false);
            }
        }, true);
    }

    public int getPage() {
        return this.page;
    }

    public int getSlot() {
        return this.slot;
    }

    @Override
    public class_1799 getItem() {
        return NBTEditorClient.CLIENT_CHEST.getPage(this.page)[this.slot];
    }

    @Override
    public void saveItem(class_1799 toSave, Runnable onFinished) {
        this.save.save(onFinished, toSave.method_7972());
    }

    @Override
    public boolean isLocked() {
        return ConfigScreen.isLockSlots();
    }

    @Override
    public boolean isLockable() {
        return true;
    }

    @Override
    public int getBlockedInvSlot() {
        return -1;
    }

    @Override
    public int getBlockedHotbarSlot() {
        return -1;
    }

    @Override
    public void showParent() {
        ClientChestScreen.show();
    }
}

