/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.itemreferences;

import com.luneruniverse.minecraft.mod.nbteditor.containers.ContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.itemreferences.ItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.screens.containers.ContainerScreen;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import com.luneruniverse.minecraft.mod.nbteditor.util.SaveQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_437;

public class ContainerItemReference
implements ItemReference {
    private final ItemReference container;
    private final int slot;
    private final SaveQueue save;

    public ContainerItemReference(ItemReference container, int slot) {
        this.container = container;
        this.slot = slot;
        this.save = new SaveQueue("Container", toSave -> {
            ContainerScreen screen;
            class_1799 containerItem = container.getItem().method_7972();
            class_1799[] contents = ContainerIO.read(containerItem);
            contents[slot] = toSave;
            ContainerIO.write(containerItem, contents);
            class_437 patt1156$temp = MainUtil.client.field_1755;
            if (patt1156$temp instanceof ContainerScreen && (screen = (ContainerScreen)patt1156$temp).getReference() == container) {
                ((class_1707)screen.method_17577()).method_7611(slot).method_7673(toSave);
            }
            AtomicBoolean done = new AtomicBoolean();
            Object lock = new Object();
            container.saveItem(containerItem, () -> {
                done.set(true);
                Object object = lock;
                synchronized (object) {
                    lock.notify();
                }
            });
            Object object = lock;
            synchronized (object) {
                while (!done.get()) {
                    try {
                        lock.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }, true);
    }

    public ItemReference getContainer() {
        return this.container;
    }

    public int getSlot() {
        return this.slot;
    }

    @Override
    public class_1799 getItem() {
        return ContainerIO.read(this.container.getItem())[this.slot];
    }

    @Override
    public void saveItem(class_1799 toSave, Runnable onFinished) {
        this.save.save(onFinished, toSave.method_7972());
    }

    @Override
    public boolean isLocked() {
        return this.container.isLocked();
    }

    @Override
    public boolean isLockable() {
        return this.container.isLockable();
    }

    @Override
    public int getBlockedInvSlot() {
        return this.container.getBlockedInvSlot();
    }

    @Override
    public int getBlockedHotbarSlot() {
        return this.container.getBlockedHotbarSlot();
    }

    @Override
    public void showParent() {
        ContainerScreen.show(this.container);
    }
}

