/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.misc;

import com.luneruniverse.minecraft.mod.nbteditor.mixin.ChatScreenAccessor;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.EditableText;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawableHelper;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.CreativeTab;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1799;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2558;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_3872;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5684;

public class MixinLink {
    private static final Map<String, Runnable> events = new HashMap<String, Runnable>();
    public static File screenshotTarget;
    public static final Set<Thread> hiddenExceptionHandlers;
    public static final Set<Thread> actualBookContents;
    public static final Set<Thread> specialNumbers;

    public static void addCreativeTabs(class_437 source) {
        int i = -1;
        ArrayList<CreativeTab> tabs = new ArrayList<CreativeTab>();
        for (CreativeTab.CreativeTabData tab : CreativeTab.TABS) {
            if (!tab.whenToShow().test(source)) continue;
            tabs.add(new CreativeTab(source, ++i * (CreativeTab.WIDTH + 2) + 10, tab.item(), tab.onClick()));
        }
        if (!tabs.isEmpty()) {
            source.method_37063((class_364)new CreativeTab.CreativeTabGroup(tabs));
        }
    }

    public static class_2583 withRunClickEvent(class_2583 style, Runnable onClick) {
        String id = "\u0000nbteditor_runnable@" + new Random().nextLong();
        events.put(id, onClick);
        return style.method_10958(new class_2558(class_2558.class_2559.field_11746, id));
    }

    public static boolean tryRunClickEvent(String id) {
        Runnable onClick = events.get(id);
        if (onClick != null) {
            onClick.run();
            return true;
        }
        return false;
    }

    public static int[] getTooltipSize(List<class_5684> tooltip) {
        int width = 0;
        int height = tooltip.size() == 1 ? -2 : 0;
        for (class_5684 line : tooltip) {
            width = Math.max(width, line.method_32664(MainUtil.client.field_1772));
            height += line.method_32661();
        }
        return new int[]{width, height};
    }

    public static void renderTooltipFromComponents(class_4587 matrices, int x, int y, int width, int height, int screenWidth, int screenHeight) {
        int newX = x -= 5;
        int newY = y -= 5;
        int newWidth = width += 10;
        int newHeight = height += 10;
        if (width > screenWidth || height > screenHeight) {
            double scale = Math.min((double)screenWidth / (double)width, (double)screenHeight / (double)height);
            newWidth = (int)((double)width * scale);
            newHeight = (int)((double)height * scale);
            int[] mousePos = MainUtil.getMousePos();
            newX = mousePos[0] + 12;
            newY = mousePos[1] - 12;
        }
        if (newX < 0) {
            newX = 0;
        } else if (newX + newWidth > screenWidth) {
            newX = screenWidth - newWidth;
        }
        if (newY < 0) {
            newY = 0;
        } else if (newY + newHeight > screenHeight) {
            newY = screenHeight - newHeight;
        }
        MainUtil.mapMatrices(matrices, x, y, width, height, newX, newY, newWidth, newHeight);
    }

    public static void throwHiddenException(DangerousRunnable toRun) throws Throwable {
        hiddenExceptionHandlers.add(Thread.currentThread());
        try {
            toRun.run();
        }
        catch (HiddenException e) {
            throw e.getCause();
        }
        finally {
            hiddenExceptionHandlers.remove(Thread.currentThread());
        }
    }

    public static class_3872.class_3933 getActualContents(class_1799 item) {
        actualBookContents.add(Thread.currentThread());
        try {
            class_3872.class_3933 class_39332 = new class_3872.class_3933(item);
            return class_39332;
        }
        finally {
            actualBookContents.remove(Thread.currentThread());
        }
    }

    public static void renderChatLimitWarning(class_408 source, class_4587 matrices) {
        if (!ConfigScreen.isChatLimitExtended()) {
            return;
        }
        class_342 chatField = ((ChatScreenAccessor)source).getChatField();
        if (chatField.method_1882().length() > 256) {
            MVDrawableHelper.fill(matrices, source.field_22789 - 202, source.field_22790 - 40, source.field_22789 - 2, source.field_22790 - 14, -1426085376);
            class_327 textRenderer = MainUtil.client.field_1772;
            EditableText editableText = TextInst.translatable("nbteditor.chat_length_warning_1", new Object[0]);
            int n = source.field_22789 - 102;
            int n2 = source.field_22790 - 40;
            Objects.requireNonNull(textRenderer);
            MVDrawableHelper.drawCenteredTextWithShadow(matrices, textRenderer, editableText, n, n2 + 9 / 2, -5614336);
            EditableText editableText2 = TextInst.translatable("nbteditor.chat_length_warning_2", new Object[0]);
            int n3 = source.field_22789 - 102;
            int n4 = source.field_22790 - 28;
            Objects.requireNonNull(textRenderer);
            MVDrawableHelper.drawCenteredTextWithShadow(matrices, textRenderer, editableText2, n3, n4 + 9 / 2, -5614336);
        }
    }

    public static class_2520 parseSpecialElement(StringReader reader) throws CommandSyntaxException {
        specialNumbers.add(Thread.currentThread());
        try {
            class_2520 class_25202 = new class_2522(reader).method_10723();
            return class_25202;
        }
        finally {
            specialNumbers.remove(Thread.currentThread());
        }
    }

    static {
        hiddenExceptionHandlers = Collections.synchronizedSet(new HashSet());
        actualBookContents = Collections.synchronizedSet(new HashSet());
        specialNumbers = Collections.synchronizedSet(new HashSet());
    }

    public static interface DangerousRunnable {
        public void run() throws Throwable;
    }

    public static class HiddenException
    extends RuntimeException {
        public HiddenException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

