/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.mixin;

import com.luneruniverse.minecraft.mod.nbteditor.NBTEditor;
import com.luneruniverse.minecraft.mod.nbteditor.commands.get.GetLostItemCommand;
import com.luneruniverse.minecraft.mod.nbteditor.itemreferences.ArmorItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.itemreferences.InventoryItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.itemreferences.ItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.mixin.HandledScreenAccessor;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.containers.ClientHandledScreen;
import com.luneruniverse.minecraft.mod.nbteditor.util.Enchants;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import net.minecraft.class_1304;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_437;
import net.minecraft.class_481;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_481.class})
public class CreativeInventoryScreenMixin {
    @Inject(at={@At(value="HEAD")}, method={"onMouseClick(Lnet/minecraft/screen/slot/Slot;IILnet/minecraft/screen/slot/SlotActionType;)V"}, cancellable=true)
    private void onMouseClick(class_1735 slot, int slotId, int button, class_1713 actionType, CallbackInfo info) {
        try {
            class_481 source;
            if (slot != null && slot instanceof class_481.class_484) {
                slot = ((class_481.class_484)slot).field_2898;
            }
            if (!((class_481.class_483)(source = (class_481)this).method_17577()).method_34255().method_7960()) {
                GetLostItemCommand.addToHistory(((class_481.class_483)source.method_17577()).method_34255());
            }
            if (!class_437.method_25441()) {
                return;
            }
            if (actionType == class_1713.field_7790 && slot != null && slot.field_7871 == MainUtil.client.field_1724.method_31548()) {
                class_1799 cursor = ((class_481.class_483)source.method_17577()).method_34255();
                class_1799 item = slot.method_7677();
                if (cursor == null || cursor.method_7960() || item == null || item.method_7960()) {
                    return;
                }
                if (cursor.method_7909() == class_1802.field_8598 || item.method_7909() == class_1802.field_8598) {
                    if (cursor.method_7909() != class_1802.field_8598) {
                        class_1799 temp = cursor;
                        cursor = item;
                        item = temp;
                    }
                    slotId = slot.field_7874;
                    boolean armor = false;
                    if (source instanceof class_481 && !MVMisc.isCreativeInventoryTabSelected()) {
                        slotId -= 9;
                    } else if (slotId < 9) {
                        armor = true;
                    }
                    new Enchants(item).addEnchants(new Enchants(cursor).getEnchants());
                    if (armor) {
                        MainUtil.saveItem(class_1304.method_20234((class_1304.class_1305)class_1304.class_1305.field_6178, (int)(8 - slotId)), item);
                    } else {
                        MainUtil.saveItemInvSlot(slotId, item);
                    }
                    ((class_481.class_483)source.method_17577()).method_34254(class_1799.field_8037);
                    info.cancel();
                }
            }
        }
        catch (Exception e) {
            NBTEditor.LOGGER.error("Error while handling slot click", (Throwable)e);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"keyPressed"}, cancellable=true)
    private void keyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> info) {
        class_1735 hoveredSlot;
        class_481 source = (class_481)this;
        if (keyCode == 32 && (hoveredSlot = ((HandledScreenAccessor)source).getFocusedSlot()) != null && hoveredSlot.field_7871 == MainUtil.client.field_1724.method_31548() && (ConfigScreen.isAirEditable() || hoveredSlot.method_7677() != null && !hoveredSlot.method_7677().method_7960())) {
            int slot = hoveredSlot.method_34266();
            if (!MVMisc.isCreativeInventoryTabSelected()) {
                slot += 36;
            }
            ItemReference ref = slot < 9 ? new ArmorItemReference(slot) : new InventoryItemReference(slot == 45 ? 45 : (slot >= 36 ? slot - 36 : slot));
            ClientHandledScreen.handleKeybind(hoveredSlot, ref);
            info.setReturnValue((Object)true);
        }
    }
}

