/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.multiversion;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.Reflection;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.Version;
import java.lang.invoke.MethodType;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import net.minecraft.class_1291;
import net.minecraft.class_1320;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_1887;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_5321;

public class MVRegistry<T>
implements Iterable<T> {
    private static final Cache<String, Reflection.MethodInvoker> methodCache = CacheBuilder.newBuilder().build();
    private static final Class<?> REGISTRY_CLASS = Reflection.getClass("net.minecraft.class_2378");
    private static final Class<?> REGISTRIES_CLASS = (Class)((Object)Version.newSwitch().range("1.19.3", (String)null, () -> Reflection.getClass("net.minecraft.class_7923")).range((String)null, "1.19.2", () -> REGISTRY_CLASS).get());
    public static final MVRegistry<class_3917<?>> SCREEN_HANDLER = MVRegistry.getRegistry("field_17429", "field_41187", false);
    public static final MVRegistry<class_1792> ITEM = MVRegistry.getRegistry("field_11142", "field_41178", true);
    public static final MVRegistry<class_1887> ENCHANTMENT = MVRegistry.getRegistry("field_11160", "field_41176", false);
    public static final MVRegistry<class_1320> ATTRIBUTE = MVRegistry.getRegistry("field_23781", "field_41190", false);
    public static final MVRegistry<class_1842> POTION = MVRegistry.getRegistry("field_11143", "field_41179", true);
    public static final MVRegistry<class_1291> STATUS_EFFECT = MVRegistry.getRegistry("field_11159", "field_41174", false);
    private final Object value;

    private static <R> R call(Object registry, String method, MethodType type, Object ... args) {
        try {
            return (R)((Reflection.MethodInvoker)methodCache.get((Object)method, () -> Reflection.getMethod(class_2378.class, method, type))).invoke(registry, args);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw new RuntimeException("Error invoking method", e);
        }
    }

    private static <T> MVRegistry<T> getRegistry(String oldName, String newName, boolean defaulted) {
        return new MVRegistry<T>(Reflection.getField(REGISTRIES_CLASS, Version.newSwitch().range("1.19.3", null, newName).range(null, "1.19.2", oldName).get(), defaulted ? Version.newSwitch().range("1.19.3", null, "Lnet/minecraft/class_7922;").range(null, "1.19.2", "Lnet/minecraft/class_2348;").get() : "Lnet/minecraft/class_2378;").get(null));
    }

    public static <V, T extends V> T register(MVRegistry<V> registry, class_2960 id, T entry) {
        return (T)MVRegistry.call(null, "method_10230", MethodType.methodType(Object.class, REGISTRY_CLASS, class_2960.class, Object.class), registry.value, id, entry);
    }

    private MVRegistry(Object value) {
        this.value = value;
    }

    @Override
    public Iterator<T> iterator() {
        return ((Iterable)this.value).iterator();
    }

    public Optional<T> getOrEmpty(class_2960 id) {
        return (Optional)MVRegistry.call(this.value, "method_17966", MethodType.methodType(Optional.class, class_2960.class), id);
    }

    public class_2960 getId(T entry) {
        return (class_2960)MVRegistry.call(this.value, "method_10221", MethodType.methodType(class_2960.class, Object.class), entry);
    }

    public T get(class_2960 id) {
        return (T)MVRegistry.call(this.value, "method_10223", MethodType.methodType(Object.class, class_2960.class), id);
    }

    public Set<class_2960> getIds() {
        return (Set)MVRegistry.call(this.value, "method_10235", MethodType.methodType(Set.class), new Object[0]);
    }

    public Set<Map.Entry<class_2960, T>> getEntrySet() {
        Set output = (Set)MVRegistry.call(this.value, "method_29722", MethodType.methodType(Set.class), new Object[0]);
        return output.stream().map(entry -> Map.entry(MVRegistry.getRegistryKeyValue(entry.getKey()), entry.getValue())).collect(Collectors.toUnmodifiableSet());
    }

    private static class_2960 getRegistryKeyValue(Object key) {
        return ((class_5321)key).method_29177();
    }

    public boolean containsId(class_2960 id) {
        return (Boolean)MVRegistry.call(this.value, "method_10250", MethodType.methodType(Boolean.TYPE, class_2960.class), id);
    }
}

