/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.multiversion;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;

public class Reflection {
    public static final MappingResolver mappings = FabricLoader.getInstance().getMappingResolver();
    private static final Cache<String, Class<?>> classCache = CacheBuilder.newBuilder().build();

    public static Class<?> getClass(String name) {
        try {
            return (Class)classCache.get((Object)name, () -> {
                MappingResolver mappingResolver = mappings;
                synchronized (mappingResolver) {
                    return Class.forName(mappings.mapClassName("intermediary", name));
                }
            });
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw new RuntimeException("Error getting class", e);
        }
    }

    public static <T> T newInstance(Class<?> clazz, Class<?>[] parameters, Object ... args) {
        try {
            return (T)clazz.getConstructor(parameters).newInstance(args);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating new instance of class", e);
        }
    }

    public static <T> T newInstance(String clazz, Class<?>[] parameters, Object ... args) {
        return Reflection.newInstance(Reflection.getClass(clazz), parameters, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFieldName(Class<?> clazz, String field, String descriptor) {
        MappingResolver mappingResolver = mappings;
        synchronized (mappingResolver) {
            return mappings.mapFieldName("intermediary", mappings.unmapClassName("intermediary", clazz.getName()), field, descriptor);
        }
    }

    public static FieldReference getField(Class<?> clazz, String field, String descriptor) {
        try {
            return new FieldReference(clazz.getField(Reflection.getFieldName(clazz, field, descriptor)));
        }
        catch (Exception e) {
            throw new RuntimeException("Error getting field", e);
        }
    }

    public static Supplier<FieldReference> getOptionalField(Class<?> clazz, String field, String descriptor) {
        return Reflection.jitSupplier(() -> Reflection.getField(clazz, field, descriptor));
    }

    private static String getIntermediaryDescriptor(MethodType type) {
        StringBuilder output = new StringBuilder("(");
        for (Class<?> param : type.parameterArray()) {
            output.append(Reflection.getIntermediaryDescriptor(param));
        }
        output.append(")");
        output.append(Reflection.getIntermediaryDescriptor(type.returnType()));
        return output.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getIntermediaryDescriptor(Class<?> clazz) {
        String descriptor = ((Class)clazz).descriptorString();
        StringBuilder arrays = new StringBuilder();
        int typeStart = 0;
        while (descriptor.charAt(typeStart) == '[') {
            arrays.append('[');
            clazz = ((Class)clazz).componentType();
            ++typeStart;
        }
        if (descriptor.charAt(typeStart) == 'L') {
            MappingResolver mappingResolver = mappings;
            synchronized (mappingResolver) {
                return arrays + "L" + mappings.unmapClassName("intermediary", ((Class)clazz).getName()).replace('.', '/') + ";";
            }
        }
        return descriptor;
    }

    public static String getMethodName(Class<?> clazz, String method, MethodType type) {
        return mappings.mapMethodName("intermediary", mappings.unmapClassName("intermediary", clazz.getName()), method, Reflection.getIntermediaryDescriptor(type));
    }

    public static MethodInvoker getMethod(Class<?> clazz, String method, MethodType type) {
        try {
            return new MethodInvoker(clazz, Reflection.getMethodName(clazz, method, type), type);
        }
        catch (Exception e) {
            throw new RuntimeException("Error getting method", e);
        }
    }

    public static Supplier<MethodInvoker> getOptionalMethod(Supplier<Class<?>> clazz, Supplier<String> method, Supplier<MethodType> type) {
        return Reflection.jitSupplier(() -> Reflection.getMethod((Class)clazz.get(), (String)method.get(), (MethodType)type.get()));
    }

    public static Supplier<MethodInvoker> getOptionalMethod(Class<?> clazz, String method, MethodType type) {
        return Reflection.getOptionalMethod(() -> clazz, () -> method, () -> type);
    }

    private static <T> Supplier<T> jitSupplier(final Supplier<T> supplier) {
        return new Supplier<T>(){
            private T value;

            @Override
            public T get() {
                if (this.value == null) {
                    this.value = supplier.get();
                }
                return this.value;
            }
        };
    }

    public static class FieldReference {
        private final Field field;

        public FieldReference(Field field) {
            this.field = field;
        }

        public void set(Object obj, Object value) {
            try {
                this.field.set(obj, value);
            }
            catch (Exception e) {
                throw new RuntimeException("Error setting field", e);
            }
        }

        public <T> T get(Object obj) {
            try {
                return (T)this.field.get(obj);
            }
            catch (Exception e) {
                throw new RuntimeException("Error getting field value", e);
            }
        }
    }

    public static class MethodInvoker {
        private final Method method;

        public MethodInvoker(Class<?> clazz, String method, MethodType type) throws Exception {
            this.method = clazz.getMethod(method, type.parameterArray());
            if (!((Class)type.returnType()).isAssignableFrom(this.method.getReturnType())) {
                throw new NoSuchMethodException("Mismatched return types! Expected " + ((Class)type.returnType()).getName() + " but found " + this.method.getReturnType().getName());
            }
        }

        public <T> T invoke(Object obj, Object ... args) {
            try {
                return (T)this.method.invoke(obj, args);
            }
            catch (Exception e) {
                throw new RuntimeException("Error invoking method", e);
            }
        }
    }
}

