/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.multiversion;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class Version {
    private static volatile int[] CURRENT;
    private static String releaseTarget;

    public static <T> VersionSwitch<T> newSwitch() {
        return new VersionSwitch();
    }

    public static int[] get() {
        if (CURRENT == null) {
            CURRENT = Version.parseVersion(Version.getReleaseTarget());
        }
        return CURRENT;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String getReleaseTarget() {
        if (releaseTarget != null) {
            return releaseTarget;
        }
        try (InputStream in = Version.class.getResourceAsStream("/version.json");){
            JsonObject data;
            InputStreamReader reader;
            block16: {
                String string;
                reader = new InputStreamReader(in);
                try {
                    data = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                    if (!data.has("release_target")) break block16;
                    string = releaseTarget = data.get("release_target").getAsString();
                }
                catch (Throwable throwable) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                reader.close();
                return string;
            }
            String id = data.get("id").getAsString();
            String string = releaseTarget = id.split("\\+|-")[0];
            reader.close();
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error trying to read game version", e);
        }
    }

    private static int[] parseVersion(String version) {
        int[] parts = Stream.of(version.split("\\.")).mapToInt(Integer::parseInt).toArray();
        if (parts[0] != 1 || parts.length < 2 || parts.length > 3) {
            throw new IllegalArgumentException("Unsupported Minecraft version: " + version);
        }
        if (parts.length == 3) {
            return parts;
        }
        return new int[]{parts[0], parts[1], 0};
    }

    public static class VersionSwitch<T> {
        private Supplier<T> match;

        private VersionSwitch() {
        }

        public VersionSwitch<T> range(String min, String max, Supplier<T> value) {
            int[] minParts = min == null ? null : Version.parseVersion(min);
            int[] maxParts = max == null ? null : Version.parseVersion(max);
            int[] actualParts = Version.get();
            boolean minMatch = min != null;
            boolean maxMatch = max != null;
            for (int i = 0; i < 3; ++i) {
                if (minMatch) {
                    if (minParts[i] < actualParts[i]) {
                        minMatch = false;
                    } else if (minParts[i] > actualParts[i]) {
                        return this;
                    }
                }
                if (!maxMatch) continue;
                if (actualParts[i] < maxParts[i]) {
                    maxMatch = false;
                    continue;
                }
                if (actualParts[i] <= maxParts[i]) continue;
                return this;
            }
            if (this.match != null) {
                throw new IllegalArgumentException("Overlapping versions!");
            }
            this.match = value;
            return this;
        }

        public VersionSwitch<T> range(String min, String max, T value) {
            return this.range(min, max, (T)((Supplier<Object>)() -> value));
        }

        public VersionSwitch<T> range(String min, String max, Runnable run) {
            return this.range(min, max, (T)((Supplier<Object>)() -> {
                run.run();
                return null;
            }));
        }

        public T get() {
            if (this.match == null) {
                throw new IllegalStateException("Missing version!");
            }
            return this.match.get();
        }

        public void run() {
            this.get();
        }
    }
}

