/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.multiversion.commands;

import com.google.common.collect.Iterables;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.Version;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.commands.ClientCommandManager;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.commands.FabricClientCommandSource;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.commands.mixin.HelpCommandAccessor;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.BuiltInExceptionProvider;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2164;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public final class ClientCommandInternals {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientCommandInternals.class);
    private static final String API_COMMAND_NAME = Version.newSwitch().range("1.19.0", null, "fabric-command-api-v2:client").range(null, "1.18.2", "fabric-command-api-v1:client").get();
    private static final String SHORT_API_COMMAND_NAME = "fcc";
    @Nullable
    private static CommandDispatcher<FabricClientCommandSource> activeDispatcher = (CommandDispatcher)Version.newSwitch().range("1.19.0", (String)null, () -> null).range((String)null, "1.18.2", () -> new CommandDispatcher()).get();

    public static void setActiveDispatcher(@Nullable CommandDispatcher<FabricClientCommandSource> dispatcher) {
        activeDispatcher = dispatcher;
    }

    @Nullable
    public static CommandDispatcher<FabricClientCommandSource> getActiveDispatcher() {
        return activeDispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean executeCommand(String command) {
        class_310 client = class_310.method_1551();
        FabricClientCommandSource commandSource = (FabricClientCommandSource)client.method_1562().method_2875();
        client.method_16011().method_15396(command);
        try {
            activeDispatcher.execute(command, (Object)commandSource);
            boolean bl = true;
            return bl;
        }
        catch (CommandSyntaxException e) {
            boolean ignored = ClientCommandInternals.isIgnoredException(e.getType());
            if (ignored) {
                LOGGER.debug("Syntax exception for client-sided command '{}'", (Object)command, (Object)e);
                boolean bl = false;
                return bl;
            }
            LOGGER.warn("Syntax exception for client-sided command '{}'", (Object)command, (Object)e);
            commandSource.sendError(ClientCommandInternals.getErrorMessage(e));
            boolean bl = true;
            return bl;
        }
        catch (class_2164 e) {
            LOGGER.warn("Error while executing client-sided command '{}'", (Object)command, (Object)e);
            commandSource.sendError(e.method_9199());
            boolean bl = true;
            return bl;
        }
        catch (RuntimeException e) {
            LOGGER.warn("Error while executing client-sided command '{}'", (Object)command, (Object)e);
            commandSource.sendError(TextInst.of(e.getMessage()));
            boolean bl = true;
            return bl;
        }
        finally {
            client.method_16011().method_15407();
        }
    }

    private static boolean isIgnoredException(CommandExceptionType type) {
        BuiltInExceptionProvider builtins = CommandSyntaxException.BUILT_IN_EXCEPTIONS;
        return type == builtins.dispatcherUnknownCommand() || type == builtins.dispatcherParseException();
    }

    private static class_2561 getErrorMessage(CommandSyntaxException e) {
        class_2561 msg = class_2564.method_10883((Message)e.getRawMessage());
        String context = e.getContext();
        if (context == null) {
            return msg;
        }
        return TextInst.translatable("command.context.parse_error", msg, e.getCursor(), context);
    }

    public static void finalizeInit() {
        if (!activeDispatcher.getRoot().getChildren().isEmpty()) {
            LiteralArgumentBuilder<FabricClientCommandSource> help = ClientCommandManager.literal("help");
            help.executes(ClientCommandInternals::executeRootHelp);
            help.then(ClientCommandManager.argument("command", StringArgumentType.greedyString()).executes(ClientCommandInternals::executeArgumentHelp));
            LiteralCommandNode mainNode = activeDispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal(API_COMMAND_NAME).then(help));
            activeDispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal(SHORT_API_COMMAND_NAME).redirect((CommandNode)mainNode));
        }
        activeDispatcher.findAmbiguities((parent, child, sibling, inputs) -> LOGGER.warn("Ambiguity between arguments {} and {} with inputs: {}", new Object[]{activeDispatcher.getPath(child), activeDispatcher.getPath(sibling), inputs}));
    }

    private static int executeRootHelp(CommandContext<FabricClientCommandSource> context) {
        return ClientCommandInternals.executeHelp((CommandNode<FabricClientCommandSource>)activeDispatcher.getRoot(), context);
    }

    private static int executeArgumentHelp(CommandContext<FabricClientCommandSource> context) throws CommandSyntaxException {
        ParseResults parseResults = activeDispatcher.parse(StringArgumentType.getString(context, (String)"command"), (Object)((FabricClientCommandSource)context.getSource()));
        List nodes = parseResults.getContext().getNodes();
        if (nodes.isEmpty()) {
            throw HelpCommandAccessor.getFailedException().create();
        }
        return ClientCommandInternals.executeHelp((CommandNode<FabricClientCommandSource>)((ParsedCommandNode)Iterables.getLast((Iterable)nodes)).getNode(), context);
    }

    private static int executeHelp(CommandNode<FabricClientCommandSource> startNode, CommandContext<FabricClientCommandSource> context) {
        Map commands = activeDispatcher.getSmartUsage(startNode, (Object)((FabricClientCommandSource)context.getSource()));
        for (String command : commands.values()) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback(TextInst.literal("/" + command));
        }
        return commands.size();
    }

    public static void addCommands(CommandDispatcher<FabricClientCommandSource> target, FabricClientCommandSource source) {
        HashMap<CommandNode<FabricClientCommandSource>, CommandNode<FabricClientCommandSource>> originalToCopy = new HashMap<CommandNode<FabricClientCommandSource>, CommandNode<FabricClientCommandSource>>();
        originalToCopy.put((CommandNode<FabricClientCommandSource>)activeDispatcher.getRoot(), (CommandNode<FabricClientCommandSource>)target.getRoot());
        ClientCommandInternals.copyChildren((CommandNode<FabricClientCommandSource>)activeDispatcher.getRoot(), (CommandNode<FabricClientCommandSource>)target.getRoot(), source, originalToCopy);
    }

    private static void copyChildren(CommandNode<FabricClientCommandSource> origin, CommandNode<FabricClientCommandSource> target, FabricClientCommandSource source, Map<CommandNode<FabricClientCommandSource>, CommandNode<FabricClientCommandSource>> originalToCopy) {
        for (CommandNode child : origin.getChildren()) {
            if (!child.canUse((Object)source)) continue;
            ArgumentBuilder builder = child.createBuilder();
            builder.requires(s -> true);
            if (builder.getCommand() != null) {
                builder.executes(context -> 0);
            }
            if (builder.getRedirect() != null) {
                builder.redirect(originalToCopy.get(builder.getRedirect()));
            }
            CommandNode result = builder.build();
            originalToCopy.put((CommandNode<FabricClientCommandSource>)child, (CommandNode<FabricClientCommandSource>)result);
            target.addChild(result);
            if (child.getChildren().isEmpty()) continue;
            ClientCommandInternals.copyChildren((CommandNode<FabricClientCommandSource>)child, (CommandNode<FabricClientCommandSource>)result, source, originalToCopy);
        }
    }
}

