/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.luneruniverse.minecraft.mod.nbteditor.NBTEditor;
import com.luneruniverse.minecraft.mod.nbteditor.NBTEditorClient;
import com.luneruniverse.minecraft.mod.nbteditor.clientchest.LargeClientChest;
import com.luneruniverse.minecraft.mod.nbteditor.clientchest.SmallClientChest;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.EditableText;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVTooltip;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.ScreenTexts;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ShortcutsScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.TickableSupportingScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigButton;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigCategory;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigItem;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigPanel;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigTooltipSupplier;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigValue;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigValueBoolean;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigValueDropdown;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigValueDropdownEnum;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigValueSlider;
import com.luneruniverse.minecraft.mod.nbteditor.screens.containers.ClientChestScreen;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.class_124;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.apache.commons.lang3.SystemUtils;

public class ConfigScreen
extends TickableSupportingScreen {
    private static EnchantLevelMax enchantLevelMax;
    private static boolean enchantNumberTypeArabic;
    private static double keyTextSize;
    private static boolean keybindsHidden;
    private static boolean lockSlots;
    private static boolean chatLimitExtended;
    private static boolean singleQuotesAllowed;
    private static boolean macScrollPatch;
    private static double scrollSpeed;
    private static boolean airEditable;
    private static boolean jsonText;
    private static List<String> shortcuts;
    private static CheckUpdatesLevel checkUpdates;
    private static boolean largeClientChest;
    private static boolean screenshotOptions;
    private static boolean tooltipOverflowFix;
    private static boolean noArmorRestriction;
    private static boolean hideFormatButtons;
    private static boolean specialNumbers;
    public static final List<Consumer<ConfigCategory>> ADDED_OPTIONS;
    private final class_437 parent;
    private final ConfigCategory config;
    private ConfigPanel panel;

    public static void loadSettings() {
        enchantLevelMax = EnchantLevelMax.NEVER;
        enchantNumberTypeArabic = false;
        keyTextSize = 0.5;
        keybindsHidden = false;
        chatLimitExtended = false;
        singleQuotesAllowed = false;
        macScrollPatch = class_310.field_1703;
        scrollSpeed = 1.0;
        airEditable = false;
        jsonText = false;
        shortcuts = new ArrayList<String>();
        checkUpdates = CheckUpdatesLevel.MINOR;
        largeClientChest = false;
        screenshotOptions = true;
        tooltipOverflowFix = true;
        noArmorRestriction = false;
        hideFormatButtons = false;
        specialNumbers = true;
        try {
            JsonObject settings = (JsonObject)new Gson().fromJson(new String(Files.readAllBytes(new File(NBTEditorClient.SETTINGS_FOLDER, "settings.json").toPath())), JsonObject.class);
            enchantLevelMax = EnchantLevelMax.valueOf(settings.get("maxEnchantLevelDisplay").getAsString());
            enchantNumberTypeArabic = settings.get("useArabicEnchantLevels").getAsBoolean();
            keyTextSize = settings.get("keyTextSize").getAsDouble();
            keybindsHidden = settings.get("hideKeybinds").getAsBoolean();
            lockSlots = settings.get("lockSlots").getAsBoolean();
            chatLimitExtended = settings.get("extendChatLimit").getAsBoolean();
            singleQuotesAllowed = settings.get("allowSingleQuotes").getAsBoolean();
            macScrollPatch = !settings.get("keySkizzers").getAsBoolean();
            scrollSpeed = settings.get("scrollSpeed").getAsDouble();
            airEditable = settings.get("airEditable").getAsBoolean();
            jsonText = settings.get("jsonText").getAsBoolean();
            shortcuts = StreamSupport.stream(settings.get("shortcuts").getAsJsonArray().spliterator(), false).map(cmd -> cmd.getAsString()).collect(Collectors.toList());
            JsonPrimitive checkUpdatesLegacy = settings.get("checkUpdates").getAsJsonPrimitive();
            checkUpdates = checkUpdatesLegacy.isBoolean() ? (checkUpdatesLegacy.getAsBoolean() ? CheckUpdatesLevel.MINOR : CheckUpdatesLevel.NONE) : CheckUpdatesLevel.valueOf(checkUpdatesLegacy.getAsString());
            largeClientChest = settings.get("largeClientChest").getAsBoolean();
            screenshotOptions = settings.get("screenshotOptions").getAsBoolean();
            tooltipOverflowFix = settings.get("tooltipOverflowFix").getAsBoolean();
            noArmorRestriction = settings.get("noArmorRestriction").getAsBoolean();
            hideFormatButtons = settings.get("hideFormatButtons").getAsBoolean();
            specialNumbers = settings.get("specialNumbers").getAsBoolean();
        }
        catch (ClassCastException | NullPointerException | NoSuchFileException e) {
            NBTEditor.LOGGER.info("Missing some settings from settings.json, fixing ...");
            ConfigScreen.saveSettings();
        }
        catch (Exception e) {
            NBTEditor.LOGGER.error("Error while loading settings", (Throwable)e);
        }
    }

    private static void saveSettings() {
        JsonObject settings = new JsonObject();
        settings.addProperty("maxEnchantLevelDisplay", enchantLevelMax.name());
        settings.addProperty("useArabicEnchantLevels", Boolean.valueOf(enchantNumberTypeArabic));
        settings.addProperty("keyTextSize", (Number)keyTextSize);
        settings.addProperty("hideKeybinds", Boolean.valueOf(keybindsHidden));
        settings.addProperty("lockSlots", Boolean.valueOf(lockSlots));
        settings.addProperty("extendChatLimit", Boolean.valueOf(chatLimitExtended));
        settings.addProperty("allowSingleQuotes", Boolean.valueOf(singleQuotesAllowed));
        settings.addProperty("keySkizzers", Boolean.valueOf(!macScrollPatch));
        settings.addProperty("scrollSpeed", (Number)scrollSpeed);
        settings.addProperty("airEditable", Boolean.valueOf(airEditable));
        settings.addProperty("jsonText", Boolean.valueOf(jsonText));
        settings.add("shortcuts", (JsonElement)shortcuts.stream().collect(JsonArray::new, JsonArray::add, JsonArray::addAll));
        settings.addProperty("checkUpdates", checkUpdates.name());
        settings.addProperty("largeClientChest", Boolean.valueOf(largeClientChest));
        settings.addProperty("screenshotOptions", Boolean.valueOf(screenshotOptions));
        settings.addProperty("tooltipOverflowFix", Boolean.valueOf(tooltipOverflowFix));
        settings.addProperty("noArmorRestriction", Boolean.valueOf(noArmorRestriction));
        settings.addProperty("hideFormatButtons", Boolean.valueOf(hideFormatButtons));
        settings.addProperty("specialNumbers", Boolean.valueOf(specialNumbers));
        try {
            Files.write(new File(NBTEditorClient.SETTINGS_FOLDER, "settings.json").toPath(), new Gson().toJson((JsonElement)settings).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            NBTEditor.LOGGER.error("Error while saving settings", (Throwable)e);
        }
    }

    public static EnchantLevelMax getEnchantLevelMax() {
        return enchantLevelMax;
    }

    public static boolean isEnchantNumberTypeArabic() {
        return enchantNumberTypeArabic;
    }

    public static double getKeyTextSize() {
        return keyTextSize;
    }

    public static boolean isKeybindsHidden() {
        return keybindsHidden;
    }

    public static void setLockSlots(boolean lockSlots) {
        ConfigScreen.lockSlots = lockSlots;
        ConfigScreen.saveSettings();
    }

    public static boolean isLockSlots() {
        return lockSlots || ConfigScreen.isLockSlotsRequired();
    }

    public static boolean isLockSlotsRequired() {
        return MainUtil.client.field_1761 != null && !MainUtil.client.field_1761.method_2920().method_8386();
    }

    public static boolean isChatLimitExtended() {
        return chatLimitExtended;
    }

    public static boolean isSingleQuotesAllowed() {
        return singleQuotesAllowed;
    }

    public static boolean isMacScrollPatch() {
        return macScrollPatch;
    }

    public static double getScrollSpeed() {
        return scrollSpeed;
    }

    public static boolean isAirEditable() {
        return airEditable;
    }

    public static boolean isJsonText() {
        return jsonText;
    }

    public static List<String> getShortcuts() {
        return shortcuts;
    }

    public static CheckUpdatesLevel getCheckUpdates() {
        return checkUpdates;
    }

    public static boolean isLargeClientChest() {
        return largeClientChest;
    }

    public static boolean isScreenshotOptions() {
        return screenshotOptions;
    }

    public static boolean isTooltipOverflowFix() {
        return tooltipOverflowFix;
    }

    public static boolean isNoArmorRestriction() {
        return noArmorRestriction;
    }

    public static boolean isHideFormatButtons() {
        return hideFormatButtons;
    }

    public static boolean isSpecialNumbers() {
        return specialNumbers;
    }

    private static EditableText getEnchantName(class_1887 enchant, int level) {
        EditableText output = TextInst.translatable(enchant.method_8184(), new Object[0]);
        if (enchant.method_8195()) {
            output.formatted(class_124.field_1061);
        } else {
            output.formatted(class_124.field_1080);
        }
        if (level != 1 || enchant.method_8183() != 1 || enchantLevelMax == EnchantLevelMax.ALWAYS) {
            output.append(" ");
            if (ConfigScreen.isEnchantNumberTypeArabic()) {
                output.append("" + level);
            } else {
                output.append(TextInst.translatable("enchantment.level." + level, new Object[0]));
            }
        }
        return output;
    }

    public static class_2561 getEnchantNameWithMax(class_1887 enchant, int level, EnchantLevelMax display) {
        EditableText text = ConfigScreen.getEnchantName(enchant, level);
        if (display.shouldShowMax(level, enchant.method_8183())) {
            text = text.append("/").append((class_2561)(ConfigScreen.isEnchantNumberTypeArabic() ? TextInst.of("" + enchant.method_8183()) : TextInst.translatable("enchantment.level." + enchant.method_8183(), new Object[0])));
        }
        return text.getInternalValue();
    }

    public static class_2561 getEnchantNameWithMax(class_1887 enchant, int level) {
        return ConfigScreen.getEnchantNameWithMax(enchant, level, enchantLevelMax);
    }

    public ConfigScreen(class_437 parent) {
        super(TextInst.translatable("nbteditor.config", new Object[0]));
        this.parent = parent;
        this.config = new ConfigCategory(TextInst.translatable("nbteditor.config", new Object[0]));
        ConfigCategory mc = new ConfigCategory(TextInst.translatable("nbteditor.config.category.mc", new Object[0]));
        ConfigCategory guis = new ConfigCategory(TextInst.translatable("nbteditor.config.category.guis", new Object[0]));
        ConfigCategory functional = new ConfigCategory(TextInst.translatable("nbteditor.config.category.functional", new Object[0]));
        this.config.setConfigurable("mc", mc);
        this.config.setConfigurable("guis", guis);
        this.config.setConfigurable("functional", functional);
        mc.setConfigurable("extendChatLimit", new ConfigItem<ConfigValue>(TextInst.translatable("nbteditor.config.chat_limit", new Object[0]), new ConfigValueBoolean(chatLimitExtended, false, 100, TextInst.translatable("nbteditor.config.chat_limit.extended", new Object[0]), TextInst.translatable("nbteditor.config.chat_limit.normal", new Object[0])).addValueListener(value -> {
            chatLimitExtended = (Boolean)value.getValidValue();
        })).setTooltip("nbteditor.config.chat_limit.desc"));
        mc.setConfigurable("tooltipOverflowFix", new ConfigItem<ConfigValue>(TextInst.translatable("nbteditor.config.tooltip_overflow_fix", new Object[0]), new ConfigValueBoolean(tooltipOverflowFix, true, 100, TextInst.translatable("nbteditor.config.tooltip_overflow_fix.enabled", new Object[0]), TextInst.translatable("nbteditor.config.tooltip_overflow_fix.disabled", new Object[0])).addValueListener(value -> {
            tooltipOverflowFix = (Boolean)value.getValidValue();
        })).setTooltip("nbteditor.config.tooltip_overflow_fix.desc"));
        mc.setConfigurable("maxEnchantLevelDisplay", new ConfigItem<ConfigValueDropdown>(TextInst.translatable("nbteditor.config.enchant_level_max", new Object[0]), new ConfigValueDropdownEnum<EnchantLevelMax>(enchantLevelMax, EnchantLevelMax.NEVER, EnchantLevelMax.class).addValueListener(value -> {
            enchantLevelMax = (EnchantLevelMax)value.getValidValue();
        })).setTooltip("nbteditor.config.enchant_level_max.desc"));
        mc.setConfigurable("useArabicEnchantLevels", new ConfigItem<ConfigValue>(TextInst.translatable("nbteditor.config.enchant_number_type", new Object[0]), new ConfigValueBoolean(enchantNumberTypeArabic, false, 100, TextInst.translatable("nbteditor.config.enchant_number_type.arabic", new Object[0]), (class_2561)TextInst.translatable("nbteditor.config.enchant_number_type.roman", new Object[0]), new MVTooltip(TextInst.translatable("nbteditor.config.enchant_number_type.desc2", new Object[0]))).addValueListener(value -> {
            enchantNumberTypeArabic = (Boolean)value.getValidValue();
        })).setTooltip("nbteditor.config.enchant_number_type.desc"));
        mc.setConfigurable("noArmorRestriction", new ConfigItem<ConfigValue>(TextInst.translatable("nbteditor.config.no_armor_restriction", new Object[0]), new ConfigValueBoolean(noArmorRestriction, false, 100, TextInst.translatable("nbteditor.config.no_armor_restriction.enabled", new Object[0]), TextInst.translatable("nbteditor.config.no_armor_restriction.disabled", new Object[0])).addValueListener(value -> {
            noArmorRestriction = (Boolean)value.getValidValue();
        })).setTooltip("nbteditor.config.no_armor_restriction.desc"));
        mc.setConfigurable("screenshotOptions", new ConfigItem<ConfigValue>(TextInst.translatable("nbteditor.config.screenshot_options", new Object[0]), new ConfigValueBoolean(screenshotOptions, true, 100, TextInst.translatable("nbteditor.config.screenshot_options.enabled", new Object[0]), TextInst.translatable("nbteditor.config.screenshot_options.disabled", new Object[0])).addValueListener(value -> {
            screenshotOptions = (Boolean)value.getValidValue();
        })).setTooltip(new MVTooltip(TextInst.translatable("nbteditor.config.screenshot_options.desc", TextInst.translatable("nbteditor.file_options.show", new Object[0]), TextInst.translatable("nbteditor.file_options.delete", new Object[0])))));
        guis.setConfigurable("scrollSpeed", new ConfigItem<ConfigValue>(TextInst.translatable("nbteditor.config.scroll_speed", new Object[0]), ConfigValueSlider.forDouble(100, scrollSpeed, 1.0, 0.5, 2.0, 0.05, value -> TextInst.literal(String.format("%.2f", value))).addValueListener(value -> {
            scrollSpeed = (Double)value.getValidValue();
        })).setTooltip("nbteditor.config.scroll_speed.desc"));
        guis.setConfigurable("hideFormatButtons", new ConfigItem<ConfigValue>(TextInst.translatable("nbteditor.config.hide_format_buttons", new Object[0]), new ConfigValueBoolean(hideFormatButtons, false, 100, TextInst.translatable("nbteditor.config.hide_format_buttons.enabled", new Object[0]), TextInst.translatable("nbteditor.config.hide_format_buttons.disabled", new Object[0])).addValueListener(value -> {
            hideFormatButtons = (Boolean)value.getValidValue();
        })).setTooltip("nbteditor.config.hide_format_buttons.desc"));
        guis.setConfigurable("macScrollPatch", new ConfigItem<ConfigValue>(TextInst.translatable("nbteditor.config.mac_scroll_patch" + (SystemUtils.IS_OS_MAC ? ".on_mac" : ""), new Object[0]), new ConfigValueBoolean(macScrollPatch, SystemUtils.IS_OS_MAC, 100, TextInst.translatable("nbteditor.config.mac_scroll_patch.enabled", new Object[0]), TextInst.translatable("nbteditor.config.mac_scroll_patch.disabled", new Object[0])).addValueListener(value -> {
            macScrollPatch = (Boolean)value.getValidValue();
        })).setTooltip("nbteditor.config.mac_scroll_patch.desc"));
        guis.setConfigurable("hideKeybinds", new ConfigItem<ConfigValue>(TextInst.translatable("nbteditor.config.keybinds", new Object[0]), new ConfigValueBoolean(keybindsHidden, false, 100, TextInst.translatable("nbteditor.config.keybinds.hidden", new Object[0]), (class_2561)TextInst.translatable("nbteditor.config.keybinds.shown", new Object[0]), new MVTooltip("nbteditor.keybind.edit", "nbteditor.keybind.item_factory", "nbteditor.keybind.container", "nbteditor.keybind.enchant")).addValueListener(value -> {
            keybindsHidden = (Boolean)value.getValidValue();
        })).setTooltip("nbteditor.config.keybinds.desc"));
        guis.setConfigurable("keyTextSize", new ConfigItem<ConfigValue>(TextInst.translatable("nbteditor.config.key_text_size", new Object[0]), ConfigValueSlider.forDouble(100, keyTextSize, 0.5, 0.5, 1.0, 0.05, value -> TextInst.literal(String.format("%.2f", value))).addValueListener(value -> {
            keyTextSize = (Double)value.getValidValue();
        })).setTooltip("nbteditor.config.key_text_size.desc"));
        guis.setConfigurable("checkUpdates", new ConfigItem<ConfigValueDropdown>(TextInst.translatable("nbteditor.config.check_updates", new Object[0]), new ConfigValueDropdownEnum<CheckUpdatesLevel>(checkUpdates, CheckUpdatesLevel.MINOR, CheckUpdatesLevel.class).addValueListener(value -> {
            checkUpdates = (CheckUpdatesLevel)value.getValidValue();
        })).setTooltip("nbteditor.config.check_updates.desc"));
        functional.setConfigurable("shortcuts", new ConfigButton(100, TextInst.translatable("nbteditor.config.shortcuts", new Object[0]), btn -> this.field_22787.method_1507((class_437)new ShortcutsScreen(this)), new MVTooltip("nbteditor.config.shortcuts.desc")));
        functional.setConfigurable("largeClientChest", new ConfigItem<ConfigValue>(TextInst.translatable("nbteditor.config.client_chest_size", new Object[0]), new ConfigValueBoolean(largeClientChest, false, 100, TextInst.translatable("nbteditor.config.client_chest_size.large", new Object[0]), TextInst.translatable("nbteditor.config.client_chest_size.small", new Object[0])).addValueListener(value -> {
            largeClientChest = (Boolean)value.getValidValue();
        })).setTooltip("nbteditor.config.client_chest_size.desc"));
        functional.setConfigurable("airEditable", new ConfigItem<ConfigValue>(TextInst.translatable("nbteditor.config.air_editable", new Object[0]), new ConfigValueBoolean(airEditable, false, 100, TextInst.translatable("nbteditor.config.air_editable.yes", new Object[0]), TextInst.translatable("nbteditor.config.air_editable.no", new Object[0])).addValueListener(value -> {
            airEditable = (Boolean)value.getValidValue();
        })).setTooltip("nbteditor.config.air_editable.desc"));
        functional.setConfigurable("specialNumbers", new ConfigItem<ConfigValue>(TextInst.translatable("nbteditor.config.special_numbers", new Object[0]), new ConfigValueBoolean(specialNumbers, true, 100, TextInst.translatable("nbteditor.config.special_numbers.enabled", new Object[0]), TextInst.translatable("nbteditor.config.special_numbers.disabled", new Object[0])).addValueListener(value -> {
            specialNumbers = (Boolean)value.getValidValue();
        })).setTooltip("nbteditor.config.special_numbers.desc"));
        functional.setConfigurable("jsonText", new ConfigItem<ConfigValue>(TextInst.translatable("nbteditor.config.json_text", new Object[0]), new ConfigValueBoolean(jsonText, false, 100, TextInst.translatable("nbteditor.config.json_text.yes", new Object[0]), TextInst.translatable("nbteditor.config.json_text.no", new Object[0])).addValueListener(value -> {
            jsonText = (Boolean)value.getValidValue();
        })).setTooltip("nbteditor.config.json_text.desc"));
        functional.setConfigurable("allowSingleQuotes", new ConfigItem<ConfigValue>(TextInst.translatable("nbteditor.config.single_quotes", new Object[0]), new ConfigValueBoolean(singleQuotesAllowed, false, 100, TextInst.translatable("nbteditor.config.single_quotes.allowed", new Object[0]), (class_2561)TextInst.translatable("nbteditor.config.single_quotes.not_allowed", new Object[0]), new MVTooltip("nbteditor.config.single_quotes.example")).addValueListener(value -> {
            singleQuotesAllowed = (Boolean)value.getValidValue();
        })).setTooltip("nbteditor.config.single_quotes.desc"));
        ADDED_OPTIONS.forEach(option -> option.accept(this.config));
    }

    protected void method_25426() {
        ConfigPanel newPanel = (ConfigPanel)this.method_37063(new ConfigPanel(16, 16, this.field_22789 - 32, this.field_22790 - 32, this.config){

            @Override
            protected boolean shouldScissor() {
                return false;
            }
        });
        if (this.panel != null) {
            newPanel.setScroll(this.panel.getScroll());
        }
        this.panel = newPanel;
        this.method_37063((class_364)MVMisc.newButton(this.field_22789 - 134, this.field_22790 - 36, 100, 20, ScreenTexts.DONE, btn -> this.method_25419()));
    }

    @Override
    public void render(class_4587 matrices, int mouseX, int mouseY, float delta) {
        super.renderBackground(matrices);
        super.render(matrices, mouseX, mouseY, delta);
    }

    @Override
    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public void method_25432() {
        ConfigScreen.saveSettings();
        if (largeClientChest != NBTEditorClient.CLIENT_CHEST instanceof LargeClientChest) {
            NBTEditorClient.CLIENT_CHEST = largeClientChest ? new LargeClientChest(5) : new SmallClientChest(100);
            ClientChestScreen.PAGE = Math.min(ClientChestScreen.PAGE, NBTEditorClient.CLIENT_CHEST.getPageCount() - 1);
            NBTEditorClient.CLIENT_CHEST.loadAync();
        }
    }

    static {
        ADDED_OPTIONS = new ArrayList<Consumer<ConfigCategory>>();
    }

    public static enum EnchantLevelMax implements ConfigTooltipSupplier
    {
        NEVER("nbteditor.config.enchant_level_max.never", (level, maxLevel) -> false),
        NOT_MAXED_EXACT("nbteditor.config.enchant_level_max.not_exact", (level, maxLevel) -> level != maxLevel),
        NOT_MAXED("nbteditor.config.enchant_level_max.not_max", (level, maxLevel) -> level < maxLevel),
        ALWAYS("nbteditor.config.enchant_level_max.always", (level, maxLevel) -> true);

        private final class_2561 label;
        private final BiFunction<Integer, Integer, Boolean> showMax;

        private EnchantLevelMax(String key, BiFunction<Integer, Integer, Boolean> showMax) {
            this.label = TextInst.translatable(key, new Object[0]);
            this.showMax = showMax;
        }

        public boolean shouldShowMax(int level, int maxLevel) {
            return this.showMax.apply(level, maxLevel);
        }

        public EnchantLevelMax next() {
            return EnchantLevelMax.values()[(this.ordinal() + 1) % EnchantLevelMax.values().length];
        }

        public String toString() {
            return this.label.getString();
        }

        @Override
        public MVTooltip getTooltip() {
            ArrayList<class_2561> output = new ArrayList<class_2561>();
            for (int lvl = 1; lvl <= 3; ++lvl) {
                output.add(ConfigScreen.getEnchantNameWithMax(class_1893.field_9124, lvl, this));
            }
            return new MVTooltip(output);
        }
    }

    public static enum CheckUpdatesLevel implements ConfigTooltipSupplier
    {
        MINOR("nbteditor.config.check_updates.minor", 1),
        PATCH("nbteditor.config.check_updates.patch", 2),
        NONE("nbteditor.config.check_updates.none", -1);

        private final class_2561 label;
        private final class_2561 desc;
        private final int level;

        private CheckUpdatesLevel(String key, int level) {
            this.label = TextInst.translatable(key, new Object[0]);
            this.desc = TextInst.translatable(key + ".desc", new Object[0]);
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }

        public String toString() {
            return this.label.getString();
        }

        @Override
        public MVTooltip getTooltip() {
            return new MVTooltip(this.desc);
        }
    }
}

