/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens;

import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawable;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawableHelper;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVElement;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.Version;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

public class CreativeTab {
    public static final List<CreativeTabData> TABS = new ArrayList<CreativeTabData>();
    public static final int WIDTH = Version.newSwitch().range("1.19.3", null, 26).range(null, "1.19.2", 28).get();
    private static final class_2960 TEXTURE = new class_2960("textures/gui/container/creative_inventory/tabs.png");
    private final class_437 screen;
    private final int x;
    private final class_1799 item;
    private final Runnable onClick;

    public CreativeTab(class_437 screen, int x, class_1799 item, Runnable onClick) {
        this.screen = screen;
        this.x = x;
        this.item = item;
        this.onClick = onClick;
    }

    private void renderTab(class_4587 matrices) {
        boolean j = false;
        boolean k = false;
        int y = this.screen.field_22790 - 32;
        MVDrawableHelper.drawTexture(matrices, TEXTURE, this.x, y, (float)j, (float)k, WIDTH, 32);
        int xOffset = Version.newSwitch().range("1.19.3", null, 5).range(null, "1.19.2", 6).get();
        MVDrawableHelper.renderItem(matrices, 100.0f, false, this.item, this.x + xOffset, y + 9);
    }

    private void renderTooltip(class_4587 matrices, int mouseX, int mouseY) {
        int y = this.screen.field_22790 - 32;
        if (this.isHoveringOverTab(this.x, y, mouseX, mouseY)) {
            MVDrawableHelper.renderTooltip(matrices, this.item.method_7964(), mouseX, mouseY);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int y = this.screen.field_22790 - 32;
        if (this.isHoveringOverTab(this.x, y, (int)mouseX, (int)mouseY)) {
            this.onClick.run();
            return true;
        }
        return false;
    }

    private boolean isHoveringOverTab(int x, int y, int mouseX, int mouseY) {
        return mouseX >= x + 3 && mouseX <= x + 3 + 23 && mouseY >= y + 3 && mouseY <= y + 3 + 27;
    }

    public record CreativeTabData(class_1799 item, Runnable onClick, Predicate<class_437> whenToShow) {
    }

    public static class CreativeTabGroup
    implements MVDrawable,
    MVElement,
    class_6379 {
        private final List<CreativeTab> tabs;

        public CreativeTabGroup(List<CreativeTab> tabs) {
            this.tabs = tabs;
        }

        @Override
        public void render(class_4587 matrices, int mouseX, int mouseY, float delta) {
            for (CreativeTab tab : this.tabs) {
                tab.renderTab(matrices);
            }
            for (CreativeTab tab : this.tabs) {
                tab.renderTooltip(matrices, mouseX, mouseY);
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            for (CreativeTab tab : this.tabs) {
                if (!tab.mouseClicked(mouseX, mouseY, button)) continue;
                return true;
            }
            return false;
        }

        public class_6379.class_6380 method_37018() {
            return class_6379.class_6380.field_33784;
        }

        public void method_37020(class_6382 builder) {
        }
    }
}

