/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens;

import com.luneruniverse.minecraft.mod.nbteditor.itemreferences.ItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawableHelper;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVTooltip;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.Version;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.OverlaySupportingScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.factories.ItemFactoryScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.util.FancyConfirmScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.NamedTextFieldWidget;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public abstract class ItemEditorScreen
extends OverlaySupportingScreen {
    protected final ItemReference ref;
    protected class_1799 item;
    protected class_1799 savedItem;
    private boolean saved;
    protected NamedTextFieldWidget name;
    private class_4185 saveBtn;

    protected ItemEditorScreen(class_2561 title, ItemReference ref) {
        super(title);
        this.ref = ref;
        this.savedItem = MainUtil.copyAirable(ref.getItem());
        this.item = MainUtil.copyAirable(this.savedItem);
        this.saved = true;
    }

    protected boolean isNameEditable() {
        return false;
    }

    protected boolean isSaveRequried() {
        return true;
    }

    protected FactoryLink getFactoryLink() {
        return new FactoryLink("nbteditor.item_factory", ItemFactoryScreen::new);
    }

    @Override
    protected final void method_25426() {
        FactoryLink link;
        super.method_25426();
        this.name = new NamedTextFieldWidget(this.field_22793, 96, 24, 100, 16, TextInst.of("")){

            public boolean method_25402(double mouseX, double mouseY, int button) {
                if (ItemEditorScreen.this.isNameEditable()) {
                    return super.method_25402(mouseX, mouseY, button);
                }
                return false;
            }
        }.name(TextInst.translatable("nbteditor.editor.name", new Object[0]));
        this.name.method_1880(Integer.MAX_VALUE);
        this.name.method_1852(MainUtil.getItemNameSafely(this.item).getString());
        this.name.method_1888(this.isNameEditable());
        this.method_37063((class_364)this.name);
        if (this.isSaveRequried()) {
            this.saveBtn = (class_4185)this.method_37063((class_364)MVMisc.newButton(204, 22, 100, 20, TextInst.translatable("nbteditor.editor.save", new Object[0]), btn -> this.save()));
            boolean bl = this.saveBtn.field_22763 = !this.saved;
        }
        if ((link = this.getFactoryLink()) != null) {
            this.method_37063((class_364)MVMisc.newTexturedButton(this.field_22789 - 36, 22, 20, 20, 20, ItemFactoryScreen.FACTORY_ICON, btn -> this.closeSafely(() -> this.field_22787.method_1507(link.factory().apply(this.ref))), new MVTooltip(link.langName())));
        }
        this.initEditor();
    }

    protected void initEditor() {
    }

    @Override
    public final void renderMain(class_4587 matrices, int mouseX, int mouseY, float delta) {
        super.renderBackground(matrices);
        this.preRenderEditor(matrices, mouseX, mouseY, delta);
        super.renderMain(matrices, mouseX, mouseY, delta);
        this.renderEditor(matrices, mouseX, mouseY, delta);
        MainUtil.renderLogo(matrices);
        this.renderItemPreview(matrices);
    }

    private void renderItemPreview(class_4587 matrices) {
        int x = 56;
        int y = 16;
        int scaleX = 2;
        int scaleY = 2;
        x /= scaleX;
        y /= scaleY;
        boolean oldMatrix = Version.newSwitch().range("1.19.4", null, false).range(null, "1.19.3", true).get();
        if (oldMatrix) {
            matrices = RenderSystem.getModelViewStack();
        }
        matrices.method_22903();
        matrices.method_22904(0.0, 0.0, 32.0);
        matrices.method_22905((float)scaleX, (float)scaleY, 1.0f);
        if (oldMatrix) {
            RenderSystem.applyModelViewMatrix();
        }
        MVDrawableHelper.renderItem(matrices, 200.0f, true, this.item, x, y);
        matrices.method_22909();
        if (oldMatrix) {
            RenderSystem.applyModelViewMatrix();
        }
    }

    protected void preRenderEditor(class_4587 matrices, int mouseX, int mouseY, float delta) {
    }

    protected void renderEditor(class_4587 matrices, int mouseX, int mouseY, float delta) {
    }

    protected void renderTip(class_4587 matrices, String langHint) {
        if (!ConfigScreen.isKeybindsHidden()) {
            int x = 312;
            MainUtil.drawWrappingString(matrices, this.field_22793, TextInst.translatable(langHint, new Object[0]).getString(), 312, 32, this.field_22789 - x - 8 - 20 - 8, -1, false, true);
        }
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (ItemEditorScreen.method_25441() && !ItemEditorScreen.method_25442() && !ItemEditorScreen.method_25443() && keyCode == 83) {
            this.save();
            return true;
        }
        return this.name.method_25404(keyCode, scanCode, modifiers);
    }

    protected void setSaved(boolean saved) {
        this.saved = saved;
        if (this.saveBtn != null) {
            this.saveBtn.field_22763 = !saved;
        }
    }

    public boolean isSaved() {
        return this.saved;
    }

    protected void save() {
        this.savedItem = this.item.method_7972();
        this.saveBtn.method_25355((class_2561)TextInst.translatable("nbteditor.editor.saving", new Object[0]));
        this.setSaved(true);
        this.ref.saveItem(this.savedItem, () -> this.saveBtn.method_25355((class_2561)TextInst.translatable("nbteditor.editor.save", new Object[0])));
    }

    protected void checkSave() {
        this.item.method_7948();
        this.savedItem.method_7948();
        this.setSaved(class_1799.method_7973((class_1799)this.item, (class_1799)this.savedItem));
    }

    @Override
    public void method_25419() {
        this.closeSafely(() -> this.ref.showParent());
    }

    public void closeSafely(Runnable onClose) {
        if (this.saved) {
            onClose.run();
        } else {
            this.field_22787.method_1507((class_437)new FancyConfirmScreen(value -> {
                if (value) {
                    this.save();
                }
                onClose.run();
            }, TextInst.translatable("nbteditor.editor.unsaved.title", new Object[0]), TextInst.translatable("nbteditor.editor.unsaved.desc", new Object[0]), TextInst.translatable("nbteditor.editor.unsaved.yes", new Object[0]), TextInst.translatable("nbteditor.editor.unsaved.no", new Object[0])));
        }
    }

    protected record FactoryLink(String langName, Function<ItemReference, class_437> factory) {
    }
}

