/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens;

import com.luneruniverse.minecraft.mod.nbteditor.NBTEditor;
import com.luneruniverse.minecraft.mod.nbteditor.itemreferences.ItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.misc.MixinLink;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVElement;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVRegistry;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ItemEditorScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.NBTValue;
import com.luneruniverse.minecraft.mod.nbteditor.screens.nbtmenugenerators.MenuGenerator;
import com.luneruniverse.minecraft.mod.nbteditor.screens.util.FancyConfirmScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.util.StringInputScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.util.TextAreaScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.List2D;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.NamedTextFieldWidget;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import com.luneruniverse.minecraft.mod.nbteditor.util.NbtFormatter;
import com.luneruniverse.minecraft.mod.nbteditor.util.TextUtil;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_151;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_437;

public class NBTEditorScreen
extends ItemEditorScreen {
    private static String copiedKey;
    private static class_2520 copiedValue;
    private NamedTextFieldWidget type;
    private NamedTextFieldWidget count;
    private NamedTextFieldWidget path;
    private NamedTextFieldWidget value;
    private List2D editor;
    private Map<String, Integer> scrollPerFolder = new HashMap<String, Integer>();
    private List<String> realPath = new ArrayList<String>(){

        @Override
        public String toString() {
            return String.join((CharSequence)"/", this);
        }
    };
    private NBTValue selectedValue;
    private MenuGenerator currentGen;
    private final MenuGenerator gen = new RecursiveMenuGenerator();
    private class_2520 nbt = this.item.method_7948();

    public NBTEditorScreen(ItemReference ref) {
        super(TextInst.of("NBT Editor"), ref);
    }

    @Override
    protected void initEditor() {
        if (this.realPath.isEmpty() && ((class_2487)this.nbt).method_10545("")) {
            this.field_22787.method_1507((class_437)new class_410(value -> {
                if (value) {
                    ((class_2487)this.nbt).method_10551("");
                    this.item.method_7980((class_2487)this.nbt);
                    this.save();
                    this.field_22787.method_1507((class_437)this);
                } else {
                    this.method_25419();
                }
            }, (class_2561)TextInst.translatable("nbteditor.nbt.empty_key.title", new Object[0]), (class_2561)TextInst.translatable("nbteditor.nbt.empty_key.desc", new Object[0]), (class_2561)TextInst.translatable("nbteditor.nbt.empty_key.yes", new Object[0]), (class_2561)TextInst.translatable("nbteditor.nbt.empty_key.no", new Object[0])));
            return;
        }
        MVMisc.setKeyboardRepeatEvents(true);
        this.name.method_1863(str -> {
            if (str.equals(this.item.method_7909().method_7848().getString())) {
                this.item.method_7977(null);
            } else {
                this.item.method_7977(TextInst.of(str));
            }
            this.genEditor();
        });
        this.method_37063((class_364)MVMisc.newButton(16, this.field_22790 - 32, 20, 20, TextInst.translatable("nbteditor.nbt.add", new Object[0]), btn -> this.add()));
        this.method_37063((class_364)MVMisc.newButton(40, this.field_22790 - 32, 20, 20, TextInst.translatable("nbteditor.nbt.remove", new Object[0]), btn -> this.remove()));
        this.method_37063((class_364)MVMisc.newButton(64, this.field_22790 - 32, 48, 20, TextInst.translatable("nbteditor.nbt.copy", new Object[0]), btn -> this.copy()));
        this.method_37063((class_364)MVMisc.newButton(116, this.field_22790 - 32, 48, 20, TextInst.translatable("nbteditor.nbt.cut", new Object[0]), btn -> this.cut()));
        this.method_37063((class_364)MVMisc.newButton(168, this.field_22790 - 32, 48, 20, TextInst.translatable("nbteditor.nbt.paste", new Object[0]), btn -> this.paste()));
        this.method_37063((class_364)MVMisc.newButton(220, this.field_22790 - 32, 48, 20, TextInst.translatable("nbteditor.nbt.rename", new Object[0]), btn -> this.rename()));
        this.type = new NamedTextFieldWidget(this.field_22793, 96, 56, 208, 16, TextInst.of("")).name(TextInst.translatable("nbteditor.nbt.identifier", new Object[0]));
        this.type.method_1880(Integer.MAX_VALUE);
        this.type.method_1852(MVRegistry.ITEM.getId(this.item.method_7909()).toString());
        this.type.method_1863(str -> {
            try {
                if (!MVRegistry.ITEM.containsId(new class_2960(str))) {
                    return;
                }
            }
            catch (class_151 e) {
                return;
            }
            boolean airEditable = ConfigScreen.isAirEditable();
            if (!airEditable && MVRegistry.ITEM.get(new class_2960(str)) == class_1802.field_8162) {
                return;
            }
            class_1799 editedItem = MainUtil.setType(MVRegistry.ITEM.get(new class_2960(str)), this.item, this.count.method_1882().isEmpty() ? 1 : Integer.parseInt(this.count.method_1882()));
            if (editedItem == class_1799.field_8037) {
                return;
            }
            this.item = editedItem;
            this.genEditor();
        });
        this.method_37063((class_364)this.type);
        this.count = new NamedTextFieldWidget(this.field_22793, 16, 56, 72, 16, TextInst.of("")).name(TextInst.translatable("nbteditor.nbt.count", new Object[0]));
        this.count.method_1880(Integer.MAX_VALUE);
        this.count.method_1852("" + (ConfigScreen.isAirEditable() ? Math.max(1, this.item.method_7947()) : this.item.method_7947()));
        this.count.method_1863(str -> {
            if (str.isEmpty()) {
                return;
            }
            this.item.method_7939(Integer.parseInt(str));
        });
        this.count.method_1890(MainUtil.intPredicate(1, Integer.MAX_VALUE, true));
        this.method_37063((class_364)this.count);
        this.path = new NamedTextFieldWidget(this.field_22793, 16, 80, 288, 16, TextInst.translatable("nbteditor.nbt.path", new Object[0])).name(TextInst.translatable("nbteditor.nbt.path", new Object[0]));
        this.path.method_1880(Integer.MAX_VALUE);
        this.path.method_1852(this.realPath.toString());
        this.path.method_1863(str -> {
            String[] parts = str.split("/");
            class_2487 nbt = this.item.method_7948();
            for (String part : parts) {
                MenuGenerator gen = MenuGenerator.TYPES.get(nbt.method_10711());
                if (gen == null) {
                    return;
                }
                if ((nbt = gen.getElement((class_2520)nbt, part)) != null) continue;
                return;
            }
            this.realPath.clear();
            this.realPath.addAll(Arrays.asList(parts));
            this.genEditor();
        });
        this.method_37063((class_364)this.path);
        this.value = new NamedTextFieldWidget(this.field_22793, 16, 104, 288, 16, TextInst.translatable("nbteditor.nbt.value", new Object[0])).name(TextInst.translatable("nbteditor.nbt.value", new Object[0]));
        this.value.method_1854((str, index) -> TextUtil.substring(NbtFormatter.FORMATTER.formatSafely(this.value.method_1882()).text(), index, index + str.length()).method_30937());
        this.value.method_1880(Integer.MAX_VALUE);
        this.value.method_1852("");
        this.value.method_1888(false);
        this.value.method_1863(str -> {
            if (this.selectedValue != null) {
                this.selectedValue.setUnsafe(!NbtFormatter.FORMATTER.formatSafely(this.value.method_1882()).isSuccess());
                if (this.selectedValue.isUnsafe()) {
                    return;
                }
                this.selectedValue.valueChanged((String)str, nbt -> {
                    this.gen.setElement(this.nbt, this.selectedValue.getKey(), (class_2520)nbt);
                    this.updateName();
                });
            }
        });
        this.method_37063((class_364)this.value);
        this.method_37063((class_364)MVMisc.newButton(314, 102, 75, 20, TextInst.translatable("nbteditor.nbt.value_expand", new Object[0]), btn -> {
            if (this.selectedValue == null) {
                this.field_22787.method_1507((class_437)new TextAreaScreen(this, this.nbt.toString(), NbtFormatter.FORMATTER, false, str -> {
                    try {
                        class_2520 newNbt = MixinLink.parseSpecialElement(new StringReader(str));
                        if (this.realPath.isEmpty()) {
                            if (newNbt instanceof class_2487) {
                                this.nbt = newNbt;
                            } else {
                                this.nbt = new class_2487();
                                ((class_2487)this.nbt).method_10566("value", newNbt);
                            }
                            this.item.method_7980((class_2487)this.nbt);
                        } else {
                            String lastPathPart = this.realPath.remove(this.realPath.size() - 1);
                            this.genEditor();
                            this.gen.setElement(this.nbt, lastPathPart, newNbt);
                            this.realPath.add(lastPathPart);
                        }
                    }
                    catch (CommandSyntaxException e) {
                        NBTEditor.LOGGER.error("Error parsing nbt from Expand", (Throwable)e);
                    }
                }));
            } else {
                this.field_22787.method_1507((class_437)new TextAreaScreen(this, this.selectedValue.getValueText(), NbtFormatter.FORMATTER, false, str -> this.value.method_1852((String)str)));
            }
        }));
        int editorY = 128;
        this.editor = new List2D(16, 128, this.field_22789 - 32, this.field_22790 - 128 - 32 - 8, 4, 32, 32, 8).setFinalEventHandler(new MVElement(){

            public boolean method_25402(double mouseX, double mouseY, int button) {
                NBTEditorScreen.this.selectedValue = null;
                NBTEditorScreen.this.value.method_1852("");
                NBTEditorScreen.this.value.method_1888(false);
                return true;
            }
        });
        this.genEditor();
        this.method_37063(this.editor);
    }

    private void genEditor() {
        List<NBTValue> elements;
        this.selectedValue = null;
        this.value.method_1852("");
        this.value.method_1888(false);
        this.updateName();
        this.editor.clearElements();
        this.nbt = this.item.method_7948();
        this.currentGen = MenuGenerator.TYPES.get((byte)10);
        Iterator<String> keys = this.realPath.iterator();
        boolean removing = false;
        class_2520 value = null;
        MenuGenerator generator = null;
        while (keys.hasNext()) {
            String key2 = keys.next();
            if (removing) {
                keys.remove();
                continue;
            }
            value = this.currentGen.getElement(this.nbt, key2);
            if (value != null && (generator = MenuGenerator.TYPES.get(value.method_10711())) != null) {
                this.nbt = value;
                this.currentGen = generator;
                continue;
            }
            keys.remove();
            removing = true;
        }
        if (removing) {
            this.path.field_2092 = this.realPath.toString();
            this.path.method_1875(this.path.method_1882().length());
            this.path.method_1884(this.path.method_1882().length());
        }
        if (!this.realPath.isEmpty()) {
            this.editor.addElement(new NBTValue(this, null, null));
        }
        if ((elements = this.gen.getElements(this, this.nbt)) == null) {
            this.selectNbt(null, true);
        } else {
            elements.sort((a, b) -> a.getKey().compareToIgnoreCase(b.getKey()));
            elements.forEach(this.editor::addElement);
        }
        this.editor.setScroll(Math.max(this.editor.getMaxScroll(), this.scrollPerFolder.computeIfAbsent(this.realPath.toString(), key -> 0)));
    }

    private void updateName() {
        String newName = MainUtil.getItemNameSafely(this.item).getString();
        if (!this.name.field_2092.equals(newName)) {
            this.name.field_2092 = newName;
            this.name.method_1875(this.name.method_1882().length());
            this.name.method_1884(this.name.method_1882().length());
        }
    }

    @Override
    protected boolean isNameEditable() {
        return true;
    }

    void selectNbt(NBTValue key, boolean isFolder) {
        if (isFolder) {
            if (key == null) {
                this.realPath.remove(this.realPath.size() - 1);
            } else {
                this.realPath.add(key.getKey());
            }
            this.selectedValue = null;
            this.value.method_1852("");
            this.value.method_1888(false);
            this.path.method_1852(this.realPath.toString());
            this.genEditor();
        } else {
            this.selectedValue = key;
            this.value.method_1852(key.getValueText());
            this.value.method_1888(true);
        }
    }

    public void method_25432() {
        MVMisc.setKeyboardRepeatEvents(false);
    }

    @Override
    public void method_25393() {
        super.method_25393();
        this.checkSave();
    }

    @Override
    protected void save() {
        if (!this.item.method_7960() || this.item.method_7969() == null || this.item.method_7969().method_33133()) {
            super.save();
            return;
        }
        MainUtil.client.method_1507((class_437)new FancyConfirmScreen(value -> {
            if (value) {
                super.save();
            }
            MainUtil.client.method_1507((class_437)this);
        }, TextInst.translatable("nbteditor.nbt.saving_air.title", new Object[0]), TextInst.translatable("nbteditor.nbt.saving_air.desc", new Object[0]), TextInst.translatable("nbteditor.nbt.saving_air.yes", new Object[0]), TextInst.translatable("nbteditor.nbt.saving_air.no", new Object[0])));
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.method_25419();
            return true;
        }
        return !this.type.method_25404(keyCode, scanCode, modifiers) && !this.type.method_20315() && !this.count.method_25404(keyCode, scanCode, modifiers) && !this.count.method_20315() && !this.path.method_25404(keyCode, scanCode, modifiers) && !this.path.method_20315() && !this.value.method_25404(keyCode, scanCode, modifiers) && !this.value.method_20315() ? this.keyPressed2(keyCode, scanCode, modifiers) : true;
    }

    private boolean keyPressed2(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 261 || keyCode == 259) {
            this.remove();
        } else if (keyCode == 257 && !this.realPath.isEmpty()) {
            this.selectNbt(null, true);
        }
        if ((modifiers & 2) != 0) {
            if (keyCode == 67) {
                this.copy();
            } else if (keyCode == 88) {
                this.cut();
            } else if (keyCode == 86) {
                this.paste();
            } else if (keyCode == 82) {
                this.rename();
            } else if (keyCode == 78) {
                this.add();
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double amount) {
        boolean output = super.method_25401(mouseX, mouseY, amount);
        this.scrollPerFolder.put(this.realPath.toString(), this.editor.getScroll());
        return output;
    }

    public void method_29638(List<Path> paths) {
        if (!(this.nbt instanceof class_2487)) {
            return;
        }
        for (Path path : paths) {
            File file = path.toFile();
            if (!file.isFile() || !file.getName().endsWith(".nbt")) continue;
            try (FileInputStream in = new FileInputStream(file);){
                class_2487 nbt = MainUtil.readNBT(in);
                for (String key : nbt.method_10541()) {
                    this.gen.setElement(this.nbt, key, nbt.method_10580(key));
                }
                this.genEditor();
            }
            catch (Exception e) {
                NBTEditor.LOGGER.error("Error while importing a .nbt file", (Throwable)e);
            }
        }
    }

    @Override
    public boolean method_25421() {
        return true;
    }

    private void add() {
        this.gen.addElement(this, this.nbt, force -> {
            if (force == null) {
                this.genEditor();
            } else {
                this.field_22787.method_1507((class_437)new FancyConfirmScreen(value -> {
                    if (value) {
                        this.gen.addElement(this, this.nbt, success2 -> this.genEditor(), (String)force);
                    }
                    this.field_22787.method_1507((class_437)this);
                }, TextInst.translatable("nbteditor.nbt.overwrite.title", new Object[0]), TextInst.translatable("nbteditor.nbt.overwrite.desc", new Object[0]), TextInst.translatable("nbteditor.nbt.overwrite.yes", new Object[0]), TextInst.translatable("nbteditor.nbt.overwrite.no", new Object[0])));
            }
        }, null);
    }

    private void remove() {
        if (this.selectedValue != null) {
            this.gen.removeElement(this.nbt, this.selectedValue.getKey());
            this.genEditor();
        }
    }

    private void copy() {
        if (this.selectedValue != null) {
            copiedKey = this.selectedValue.getKey();
            copiedValue = this.gen.getElement(this.nbt, this.selectedValue.getKey()).method_10707();
        }
    }

    private void cut() {
        if (this.selectedValue != null) {
            copiedKey = this.selectedValue.getKey();
            copiedValue = this.gen.getElement(this.nbt, this.selectedValue.getKey()).method_10707();
            this.gen.removeElement(this.nbt, this.selectedValue.getKey());
            this.genEditor();
        }
    }

    private void paste() {
        if (copiedKey != null) {
            this.gen.pasteElement(this.nbt, copiedKey, copiedValue.method_10707());
            this.genEditor();
        }
    }

    private void rename() {
        if (this.selectedValue != null) {
            String selectedKey = this.selectedValue.getKey();
            this.getKey(selectedKey, key -> {
                if (this.gen.renameElement(this.nbt, selectedKey, (String)key, false)) {
                    this.genEditor();
                } else {
                    this.field_22787.method_1507((class_437)new FancyConfirmScreen(value -> {
                        if (value) {
                            this.gen.renameElement(this.nbt, selectedKey, (String)key, true);
                            this.genEditor();
                        }
                        this.field_22787.method_1507((class_437)this);
                    }, TextInst.translatable("nbteditor.nbt.overwrite.title", new Object[0]), TextInst.translatable("nbteditor.nbt.overwrite.desc", new Object[0]), TextInst.translatable("nbteditor.nbt.overwrite.yes", new Object[0]), TextInst.translatable("nbteditor.nbt.overwrite.no", new Object[0])));
                }
            });
        }
    }

    public void getKey(String defaultValue, Consumer<String> keyConsumer) {
        new StringInputScreen(this, keyConsumer, str -> !str.isEmpty()).show(defaultValue);
    }

    public void getKey(Consumer<String> keyConsumer) {
        this.getKey(null, keyConsumer);
    }

    private class RecursiveMenuGenerator
    implements MenuGenerator {
        private RecursiveMenuGenerator() {
        }

        @Override
        public List<NBTValue> getElements(NBTEditorScreen screen, class_2520 source) {
            return NBTEditorScreen.this.currentGen.getElements(screen, source);
        }

        @Override
        public class_2520 getElement(class_2520 source, String key) {
            return NBTEditorScreen.this.currentGen.getElement(source, key);
        }

        @Override
        public void setElement(class_2520 source, String key, class_2520 value) {
            NBTEditorScreen.this.currentGen.setElement(source, key, value);
            this.recursiveUpdate(source);
        }

        @Override
        public void addElement(NBTEditorScreen screen, class_2520 source, Consumer<String> requestOverwrite, String force) {
            NBTEditorScreen.this.currentGen.addElement(screen, source, request -> {
                if (request == null) {
                    this.recursiveUpdate(source);
                }
                requestOverwrite.accept((String)request);
            }, force);
        }

        @Override
        public void removeElement(class_2520 source, String key) {
            NBTEditorScreen.this.currentGen.removeElement(source, key);
            this.recursiveUpdate(source);
        }

        @Override
        public void pasteElement(class_2520 source, String key, class_2520 value) {
            NBTEditorScreen.this.currentGen.pasteElement(source, key, value);
            this.recursiveUpdate(source);
        }

        @Override
        public boolean renameElement(class_2520 source, String key, String newKey, boolean force) {
            boolean output = NBTEditorScreen.this.currentGen.renameElement(source, key, newKey, force);
            this.recursiveUpdate(source);
            return output;
        }

        private void recursiveUpdate(class_2520 source) {
            ArrayList<class_2520> path = new ArrayList<class_2520>();
            Object lastPart = NBTEditorScreen.this.item.method_7948();
            for (String part : NBTEditorScreen.this.realPath) {
                MenuGenerator gen = MenuGenerator.TYPES.get(lastPart.method_10711());
                if (gen == null) {
                    return;
                }
                lastPart = gen.getElement((class_2520)lastPart, part);
                path.add((class_2520)lastPart);
            }
            lastPart = source;
            for (int i = path.size() - 2; i >= 0; --i) {
                String part;
                part = (class_2520)path.get(i);
                MenuGenerator.TYPES.get(part.method_10711()).setElement((class_2520)part, NBTEditorScreen.this.realPath.get(i + 1), (class_2520)lastPart);
                lastPart = part;
            }
        }
    }
}

