/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens;

import com.luneruniverse.minecraft.mod.nbteditor.misc.MixinLink;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawableHelper;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.NBTEditorScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.nbtmenugenerators.MenuGenerator;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.List2D;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Consumer;
import net.minecraft.class_2483;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_4587;

public class NBTValue
extends List2D.List2DValue {
    private static final class_2960 BACK = new class_2960("nbteditor", "textures/nbt/back.png");
    private static final class_2960 BYTE = new class_2960("nbteditor", "textures/nbt/byte.png");
    private static final class_2960 SHORT = new class_2960("nbteditor", "textures/nbt/short.png");
    private static final class_2960 INT = new class_2960("nbteditor", "textures/nbt/int.png");
    private static final class_2960 LONG = new class_2960("nbteditor", "textures/nbt/long.png");
    private static final class_2960 FLOAT = new class_2960("nbteditor", "textures/nbt/float.png");
    private static final class_2960 DOUBLE = new class_2960("nbteditor", "textures/nbt/double.png");
    private static final class_2960 NUMBER = new class_2960("nbteditor", "textures/nbt/number.png");
    private static final class_2960 STRING = new class_2960("nbteditor", "textures/nbt/string.png");
    private static final class_2960 LIST = new class_2960("nbteditor", "textures/nbt/list.png");
    private static final class_2960 BYTE_ARRAY = new class_2960("nbteditor", "textures/nbt/byte_array.png");
    private static final class_2960 INT_ARRAY = new class_2960("nbteditor", "textures/nbt/int_array.png");
    private static final class_2960 LONG_ARRAY = new class_2960("nbteditor", "textures/nbt/long_array.png");
    private static final class_2960 COMPOUND = new class_2960("nbteditor", "textures/nbt/compound.png");
    private final NBTEditorScreen screen;
    private final String key;
    private class_2520 value;
    private class_2483<?> parentList;
    private boolean selected;
    private boolean unsafe;

    public NBTValue(NBTEditorScreen screen, String key, class_2520 value, class_2483<?> parentList) {
        this.screen = screen;
        this.key = key;
        this.value = value;
        this.parentList = parentList;
    }

    public NBTValue(NBTEditorScreen screen, String key, class_2520 value) {
        this(screen, key, value, null);
    }

    @Override
    public void render(class_4587 matrices, int mouseX, int mouseY, float delta) {
        class_2960 icon = null;
        if (this.key == null) {
            icon = BACK;
        } else if (this.value.method_10711() == 1) {
            icon = BYTE;
        } else if (this.value.method_10711() == 2) {
            icon = SHORT;
        } else if (this.value.method_10711() == 3) {
            icon = INT;
        } else if (this.value.method_10711() == 4) {
            icon = LONG;
        } else if (this.value.method_10711() == 5) {
            icon = FLOAT;
        } else if (this.value.method_10711() == 6) {
            icon = DOUBLE;
        } else if (this.value.method_10711() == 99) {
            icon = NUMBER;
        } else if (this.value.method_10711() == 8) {
            icon = STRING;
        } else if (this.value.method_10711() == 9) {
            icon = LIST;
        } else if (this.value.method_10711() == 7) {
            icon = BYTE_ARRAY;
        } else if (this.value.method_10711() == 11) {
            icon = INT_ARRAY;
        } else if (this.value.method_10711() == 12) {
            icon = LONG_ARRAY;
        } else if (this.value.method_10711() == 10) {
            icon = COMPOUND;
        }
        if (icon != null) {
            MVDrawableHelper.drawTexture(matrices, icon, 0, 0, 0.0f, 0.0f, 32, 32, 32, 32);
        }
        int color = -1;
        if (this.unsafe && this.selected || this.parentList != null && this.parentList.method_10601() != this.value.method_10711()) {
            color = -21965;
        } else if (this.selected) {
            color = -2143927;
        } else if (this.isHovering(mouseX, mouseY)) {
            color = -14321783;
        }
        if (color != -1) {
            MVDrawableHelper.fill(matrices, -4, -4, 36, 0, color);
            MVDrawableHelper.fill(matrices, -4, -4, 0, 36, color);
            MVDrawableHelper.fill(matrices, -4, 32, 36, 36, color);
            MVDrawableHelper.fill(matrices, 32, -4, 36, 36, color);
        }
        if (this.key == null) {
            return;
        }
        matrices.method_22903();
        matrices.method_22905((float)ConfigScreen.getKeyTextSize(), (float)ConfigScreen.getKeyTextSize(), 0.0f);
        double scale = 1.0 / ConfigScreen.getKeyTextSize();
        MainUtil.drawWrappingString(matrices, textRenderer, this.key, (int)(16.0 * scale), (int)(24.0 * scale), (int)(32.0 * scale), -1, true, true);
        matrices.method_22909();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.isHovering((int)mouseX, (int)mouseY)) {
            if (this.key == null) {
                this.screen.selectNbt(null, true);
                return true;
            }
            MenuGenerator menuGen = MenuGenerator.TYPES.get(this.value.method_10711());
            this.screen.selectNbt(this, this.selected && menuGen != null && !menuGen.hasEmptyKey(this.screen, this.value));
            this.selected = !this.selected;
            return this.selected;
        }
        this.selected = false;
        return false;
    }

    private boolean isHovering(int mouseX, int mouseY) {
        return this.isInsideList() && mouseX >= 0 && mouseY >= 0 && mouseX <= 32 && mouseY <= 32;
    }

    public void valueChanged(String str, Consumer<class_2520> onChange) {
        try {
            this.value = MixinLink.parseSpecialElement(new StringReader(str));
            onChange.accept(this.value);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
    }

    public String getKey() {
        return this.key;
    }

    public String getValueText() {
        return this.value.toString();
    }

    public void setUnsafe(boolean unsafe) {
        this.unsafe = unsafe;
    }

    public boolean isUnsafe() {
        return this.unsafe;
    }
}

