/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.configurable;

import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigPath;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigPathNamed;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigValue;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigValueListener;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.Configurable;
import com.luneruniverse.minecraft.mod.nbteditor.util.OrderedMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2561;

public abstract class ConfigGrouping<K, T extends ConfigGrouping<K, T>>
implements ConfigPathNamed {
    protected final class_2561 name;
    protected final OrderedMap<K, ConfigPath> paths;
    private final Constructor<K, T> cloneImpl;
    protected class_2561 namePrefix;
    protected final List<ConfigValueListener<ConfigValue<?, ?>>> onChanged;

    protected ConfigGrouping(class_2561 name, Constructor<K, T> cloneImpl) {
        this.name = name;
        this.paths = new OrderedMap();
        this.cloneImpl = cloneImpl;
        this.onChanged = new ArrayList();
    }

    @Override
    public class_2561 getName() {
        return this.name;
    }

    @Override
    public void setNamePrefix(class_2561 prefix) {
        this.namePrefix = prefix;
    }

    @Override
    public class_2561 getNamePrefix() {
        return this.namePrefix;
    }

    public T setConfigurable(K key, ConfigPath path) {
        this.paths.put(key, path);
        path.addValueListener((ConfigValue<?, ?> source) -> this.onChanged.forEach(listener -> listener.onValueChanged(source)));
        path.setParent(this);
        return (T)this;
    }

    public ConfigPath getConfigurable(K key) {
        return this.paths.get(key);
    }

    public Map<K, ConfigPath> getConfigurables() {
        return Collections.unmodifiableMap(this.paths);
    }

    public T sort(Comparator<K> sorter) {
        this.paths.sort(sorter);
        return (T)this;
    }

    public T setSorter(Comparator<K> sorter) {
        this.paths.setSorter(sorter);
        return (T)this;
    }

    @Override
    public boolean isValueValid() {
        return this.paths.values().stream().allMatch(Configurable::isValueValid);
    }

    public T addValueListener(ConfigValueListener<ConfigValue<?, ?>> listener) {
        this.onChanged.add(listener);
        return (T)this;
    }

    @Override
    public T clone(boolean defaults) {
        Object output = this.cloneImpl.newInstance(this.name);
        this.paths.forEach((key, path) -> output.setConfigurable(key, (ConfigPath)path.clone(defaults)));
        ((ConfigGrouping)output).onChanged.addAll(this.onChanged);
        return output;
    }

    public abstract boolean method_25402(double var1, double var3, int var5);

    public abstract boolean method_25406(double var1, double var3, int var5);

    public abstract void method_16014(double var1, double var3);

    public abstract boolean method_25403(double var1, double var3, int var5, double var6, double var8);

    public abstract boolean method_25401(double var1, double var3, double var5);

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        for (ConfigPath path : new ArrayList<ConfigPath>(this.paths.values())) {
            if (!path.method_25404(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        for (ConfigPath path : new ArrayList<ConfigPath>(this.paths.values())) {
            if (!path.method_16803(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25400(char chr, int modifiers) {
        for (ConfigPath path : new ArrayList<ConfigPath>(this.paths.values())) {
            if (!path.method_25400(chr, modifiers)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void tick() {
        for (ConfigPath path : new ArrayList<ConfigPath>(this.paths.values())) {
            path.tick();
        }
    }

    protected static interface Constructor<K, T extends ConfigGrouping<K, T>> {
        public T newInstance(class_2561 var1);
    }
}

