/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.configurable;

import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawableHelper;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigGrouping;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigPath;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.Configurable;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_4587;

public abstract class ConfigGroupingVertical<K, T extends ConfigGroupingVertical<K, T>>
extends ConfigGrouping<K, T> {
    protected ConfigGroupingVertical(class_2561 name, ConfigGrouping.Constructor<K, T> cloneImpl) {
        super(name, cloneImpl);
    }

    protected int getNameHeight() {
        int n;
        if (this.name == null) {
            n = 0;
        } else {
            Objects.requireNonNull(MainUtil.client.field_1772);
            n = 9 + 8;
        }
        return n;
    }

    @Override
    public void render(class_4587 matrices, int mouseX, int mouseY, float delta) {
        MVDrawableHelper.fill(matrices, 0, 0, 8, this.getSpacingHeight(), this.isValueValid() ? -5592406 : -2143927);
        int yOffset = 0;
        class_2561 fullName = this.getFullName();
        if (fullName != null) {
            MVDrawableHelper.drawTextWithShadow(matrices, MainUtil.client.field_1772, fullName, 16, 0, -1);
            yOffset += this.getNameHeight();
        }
        ArrayList paths = new ArrayList(this.paths.values());
        Collections.reverse(paths);
        for (ConfigPath path : paths) {
            yOffset += path.getSpacingHeight() + 8;
        }
        for (ConfigPath path : paths) {
            matrices.method_22903();
            matrices.method_22904(16.0, (double)(yOffset -= path.getSpacingHeight() + 8), 0.0);
            path.render(matrices, mouseX - 16, mouseY - yOffset, delta);
            matrices.method_22909();
        }
    }

    @Override
    public int getSpacingWidth() {
        int output = 0;
        for (ConfigPath path : this.paths.values()) {
            int width = path.getSpacingWidth();
            if (width <= output) continue;
            output = width;
        }
        return output;
    }

    @Override
    public int getSpacingHeight() {
        return this.getNameHeight() + this.paths.values().stream().mapToInt(Configurable::getSpacingHeight).reduce((a, b) -> a + 8 + b).orElse(0);
    }

    @Override
    public int getRenderWidth() {
        int output = 0;
        for (ConfigPath path : this.paths.values()) {
            int width = path.getRenderWidth();
            if (width <= output) continue;
            output = width;
        }
        return output;
    }

    @Override
    public int getRenderHeight() {
        int output;
        int yOffset = output = this.getNameHeight();
        for (ConfigPath path : this.paths.values()) {
            int bottomY = yOffset + path.getRenderHeight();
            if (bottomY > output) {
                output = bottomY;
            }
            yOffset += path.getSpacingHeight() + 8;
        }
        return output;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        int yOffset = this.getNameHeight();
        for (ConfigPath path : new ArrayList(this.paths.values())) {
            if (path.method_25402(mouseX - 16.0, mouseY - (double)yOffset, button)) {
                return true;
            }
            yOffset += path.getSpacingHeight() + 8;
        }
        return false;
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        int yOffset = this.getNameHeight();
        for (ConfigPath path : new ArrayList(this.paths.values())) {
            if (path.method_25406(mouseX - 16.0, mouseY - (double)yOffset, button)) {
                return true;
            }
            yOffset += path.getSpacingHeight() + 8;
        }
        return false;
    }

    @Override
    public void method_16014(double mouseX, double mouseY) {
        int yOffset = this.getNameHeight();
        for (ConfigPath path : new ArrayList(this.paths.values())) {
            path.method_16014(mouseX - 16.0, mouseY - (double)yOffset);
            yOffset += path.getSpacingHeight() + 8;
        }
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        int yOffset = this.getNameHeight();
        for (ConfigPath path : new ArrayList(this.paths.values())) {
            path.method_25403(mouseX - 16.0, mouseY - (double)yOffset, button, deltaX, deltaY);
            yOffset += path.getSpacingHeight() + 8;
        }
        return false;
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double amount) {
        int yOffset = this.getNameHeight();
        for (ConfigPath path : new ArrayList(this.paths.values())) {
            if (path.method_25401(mouseX - 16.0, mouseY - (double)yOffset, amount)) {
                return true;
            }
            yOffset += path.getSpacingHeight() + 8;
        }
        return false;
    }
}

