/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.configurable;

import com.luneruniverse.minecraft.mod.nbteditor.multiversion.ExtendableButtonWidget;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawableHelper;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigTooltipSupplier;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigValue;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigValueListener;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;

public class ConfigValueDropdown<T>
extends ExtendableButtonWidget
implements ConfigValue<T, ConfigValueDropdown<T>> {
    protected T value;
    protected boolean open;
    protected final T defaultValue;
    protected final List<T> allValues;
    protected final List<T> importantValues;
    protected final List<ConfigValueListener<ConfigValueDropdown<T>>> onChanged;

    public ConfigValueDropdown(T value, T defaultValue, List<T> allValues, List<T> importantValues) {
        int n = ConfigValueDropdown.getMaxWidth(allValues);
        Objects.requireNonNull(MainUtil.client.field_1772);
        super(0, 0, n + 9 * 2, 20, TextInst.of(value.toString()), (ExtendableButtonWidget btn) -> {
            ((ConfigValueDropdown)btn).open = !((ConfigValueDropdown)btn).open;
        });
        this.value = value;
        this.defaultValue = defaultValue;
        this.allValues = allValues;
        this.importantValues = importantValues;
        this.open = false;
        this.onChanged = new ArrayList<ConfigValueListener<ConfigValueDropdown<T>>>();
    }

    public ConfigValueDropdown(T value, T defaultValue, List<T> allValues) {
        this(value, defaultValue, allValues, new ArrayList());
    }

    private static int getMaxWidth(List<?> allValues) {
        return allValues.stream().map(Object::toString).mapToInt(arg_0 -> ((class_327)MainUtil.client.field_1772).method_1727(arg_0)).max().orElse(0);
    }

    private ConfigValueDropdown(T value, T defaultValue, List<T> allValues, List<T> importantValues, boolean open, List<ConfigValueListener<ConfigValueDropdown<T>>> onChanged) {
        this(value, defaultValue, allValues, importantValues);
        this.open = open;
        this.onChanged.addAll(onChanged);
    }

    @Override
    public void renderButton(class_4587 matrices, int mouseX, int mouseY, float delta) {
        float[] translation = MVMisc.getTranslation(matrices);
        matrices.method_22903();
        matrices.method_22904(0.0, 0.0, (double)(((float)MainUtil.client.method_22683().method_4502() - translation[1]) / 20.0f));
        super.renderButton(matrices, mouseX, mouseY, delta);
        if (this.open) {
            MVDrawableHelper.fill(matrices, this.field_22760, this.field_22759, this.field_22760 + this.field_22758, this.allValues.size() * this.field_22759, -16777216);
            boolean xHover = this.field_22763 && mouseX >= this.field_22760 && mouseX < this.field_22760 + this.field_22758;
            int i = 0;
            for (T option : this.allValues) {
                if (option.equals(this.value)) continue;
                int y = this.field_22761 + ++i * this.field_22759;
                int color = -1;
                if (xHover && mouseY >= y && mouseY < y + this.field_22759) {
                    color = -14321783;
                } else if (this.importantValues.contains(option)) {
                    color = -22016;
                }
                class_327 class_3272 = MainUtil.client.field_1772;
                class_2561 class_25612 = TextInst.of(option.toString());
                int n = this.field_22760 + this.field_22758 / 2;
                Objects.requireNonNull(MainUtil.client.field_1772);
                MVDrawableHelper.drawCenteredTextWithShadow(matrices, class_3272, class_25612, n, y + (this.field_22759 - 9) / 2, color);
                if (color == -1 || !(option instanceof ConfigTooltipSupplier)) continue;
                ((ConfigTooltipSupplier)option).getTooltip().render(matrices, mouseX, mouseY);
            }
        }
        if (this.method_25367() && this.value instanceof ConfigTooltipSupplier) {
            ((ConfigTooltipSupplier)this.value).getTooltip().render(matrices, mouseX, mouseY);
        }
        matrices.method_22909();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean output = super.method_25402(mouseX, mouseY, button);
        if (!output && this.field_22763 && this.field_22764 && this.open && mouseX >= (double)this.field_22760 && mouseX < (double)(this.field_22760 + this.field_22758)) {
            int i = 0;
            for (T option : this.allValues) {
                int y;
                if (option.equals(this.value) || !(mouseY >= (double)(y = this.field_22761 + ++i * this.field_22759)) || !(mouseY < (double)(y + this.field_22759))) continue;
                this.method_25354(class_310.method_1551().method_1483());
                this.setValue(option);
                this.open = false;
                return true;
            }
        }
        if (!output && this.open) {
            this.open = false;
        }
        return output;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public boolean isOpen() {
        return this.open;
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setValue(T value) {
        this.value = value;
        this.method_25355(TextInst.of(value.toString()));
        this.onChanged.forEach(listener -> listener.onValueChanged(this));
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public boolean isValueValid() {
        return true;
    }

    @Override
    public ConfigValueDropdown<T> addValueListener(ConfigValueListener<ConfigValueDropdown<T>> listener) {
        this.onChanged.add(listener);
        return this;
    }

    @Override
    public int getSpacingWidth() {
        return this.field_22758;
    }

    @Override
    public int getSpacingHeight() {
        return this.field_22759;
    }

    @Override
    public int getRenderHeight() {
        if (!this.open) {
            return this.getSpacingHeight();
        }
        return this.allValues.size() * this.field_22759;
    }

    @Override
    public ConfigValueDropdown<T> clone(boolean defaults) {
        return new ConfigValueDropdown<T>(defaults ? this.defaultValue : this.value, this.defaultValue, this.allValues, this.importantValues, this.open, this.onChanged);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return false;
    }
}

