/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.configurable;

import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigValue;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigValueListener;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.NamedTextFieldWidget;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class ConfigValueNumber<T extends Number>
extends NamedTextFieldWidget
implements ConfigValue<T, ConfigValueNumber<T>> {
    private final T defaultValue;
    private final T min;
    private final T max;
    private final Parser<T> parser;
    private final List<ConfigValueListener<ConfigValueNumber<T>>> onChanged;

    public static ConfigValueNumber<Integer> forInt(int value, int defaultValue, int min, int max) {
        return new ConfigValueNumber<Integer>(value, Integer.valueOf(defaultValue), Integer.valueOf(min), Integer.valueOf(max), Integer::parseInt, null);
    }

    public static ConfigValueNumber<Double> forDouble(double value, double defaultValue, double min, double max) {
        return new ConfigValueNumber<Double>(value, defaultValue, min, max, Double::parseDouble, null);
    }

    private ConfigValueNumber(T value, T defaultValue, T min, T max, Parser<T> parser, List<ConfigValueListener<ConfigValueNumber<T>>> onChanged) {
        super(MainUtil.client.field_1772, 0, 0, 200, 20, TextInst.of("" + value));
        this.method_1880(Integer.MAX_VALUE);
        this.name(TextInst.of("" + defaultValue));
        this.method_1852("" + value);
        this.method_1890(str -> {
            if (str.isEmpty() || str.equals("-") || str.equals("+")) {
                return true;
            }
            try {
                parser.parse((String)str);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
        this.defaultValue = defaultValue;
        this.min = min;
        this.max = max;
        this.parser = parser;
        this.onChanged = new ArrayList<ConfigValueListener<ConfigValueNumber<T>>>();
        if (onChanged != null) {
            this.onChanged.addAll(onChanged);
        }
        super.method_1863(str -> {
            boolean valid = this.isValueValid();
            this.setValid(valid);
            if (valid) {
                this.onChanged.forEach(listener -> listener.onValueChanged(this));
            }
        });
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean output = super.method_25402(mouseX, mouseY, button);
        this.method_25365(output);
        return output;
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setValue(T value) {
        this.method_1852("" + value);
    }

    @Override
    public T getValue() {
        try {
            return this.parser.parse(this.method_1882());
        }
        catch (NumberFormatException e) {
            this.setValue(this.defaultValue);
            return this.defaultValue;
        }
    }

    @Override
    public boolean isValueValid() {
        if (this.method_1882().isEmpty() || this.method_1882().equals("-") || this.method_1882().equals("+")) {
            return false;
        }
        Object value = this.getValue();
        return ((Number)this.min).doubleValue() <= ((Number)value).doubleValue() && ((Number)value).doubleValue() <= ((Number)this.max).doubleValue();
    }

    @Override
    public ConfigValueNumber<T> addValueListener(ConfigValueListener<ConfigValueNumber<T>> listener) {
        this.onChanged.add(listener);
        return this;
    }

    public void method_1863(Consumer<String> changedListener) {
        throw new UnsupportedOperationException("Use addValueListener instead!");
    }

    @Override
    public int getSpacingWidth() {
        return this.field_22758;
    }

    @Override
    public int getSpacingHeight() {
        return this.field_22759;
    }

    @Override
    public ConfigValueNumber<T> clone(boolean defaults) {
        return new ConfigValueNumber<T>(defaults ? this.defaultValue : this.getValue(), this.defaultValue, this.min, this.max, this.parser, this.onChanged);
    }

    private static interface Parser<T extends Number> {
        public T parse(String var1) throws NumberFormatException;
    }
}

