/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.containers;

import com.luneruniverse.minecraft.mod.nbteditor.NBTEditor;
import com.luneruniverse.minecraft.mod.nbteditor.NBTEditorClient;
import com.luneruniverse.minecraft.mod.nbteditor.itemreferences.ClientChestItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.EditableText;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.containers.ClientChestHandler;
import com.luneruniverse.minecraft.mod.nbteditor.screens.containers.ClientHandledScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.util.FancyConfirmScreen;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import com.luneruniverse.minecraft.mod.nbteditor.util.SaveQueue;
import java.lang.invoke.LambdaMetafactory;
import net.minecraft.class_1661;
import net.minecraft.class_1707;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_746;

public class ClientChestScreen
extends ClientHandledScreen {
    public static int PAGE = 0;
    public static int prevPageJumpTarget;
    public static int nextPageJumpTarget;
    private final SaveQueue saveQueue = new SaveQueue("Client Chest", request -> {
        try {
            NBTEditorClient.CLIENT_CHEST.setPage(request.page(), request.items());
        }
        catch (Exception e) {
            NBTEditor.LOGGER.error("Error while saving client chest", (Throwable)e);
            this.field_22787.field_1724.method_7353((class_2561)TextInst.translatable("nbteditor.client_chest.save_error", new Object[0]), false);
        }
    }, true);
    private boolean saved;
    private boolean navigationClicked;
    private class_4185 prevPage;
    private class_342 pageField;
    private class_4185 nextPage;
    private class_4185 prevPageJump;
    private class_4185 nextPageJump;

    public static void show() {
        if (!NBTEditorClient.CLIENT_CHEST.isLoaded()) {
            MainUtil.client.field_1724.method_7353((class_2561)TextInst.translatable("nbteditor.client_chest.not_ready", new Object[0]), false);
            return;
        }
        if (MainUtil.client.field_1755 instanceof ClientChestScreen) {
            ClientChestScreen screen = (ClientChestScreen)MainUtil.client.field_1755;
            ((ClientChestHandler)screen.field_2797).fillPage();
            screen.updatePageNavigation();
        } else {
            class_746 player = MainUtil.client.field_1724;
            ClientChestHandler handler = new ClientChestHandler(0, player.method_31548());
            MainUtil.client.method_1507((class_437)new ClientChestScreen(handler, player.method_31548(), TextInst.translatable("nbteditor.client_chest", new Object[0])));
            NBTEditorClient.CLIENT_CHEST.warnIfCorrupt();
        }
    }

    private ClientChestScreen(class_1707 handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
        this.dropCursorOnClose = false;
        this.saved = true;
    }

    @Override
    protected void method_25426() {
        this.method_37067();
        super.method_25426();
        this.field_2776 += 43;
        this.prevPage = MVMisc.newButton(this.field_2776 - 87, this.field_2800, 20, 20, TextInst.of("<"), btn -> {
            this.navigationClicked = true;
            this.pageField.method_1852("" + (--PAGE + 1));
            ClientChestScreen.show();
        });
        this.method_37063((class_364)this.prevPage);
        this.pageField = new class_342(this.field_22793, this.field_2776 - 63, this.field_2800 + 2, 35, 16, TextInst.of("")){

            public boolean method_25402(double mouseX, double mouseY, int button) {
                boolean output = super.method_25402(mouseX, mouseY, button);
                if (output) {
                    ClientChestScreen.this.navigationClicked = true;
                }
                return output;
            }
        };
        this.pageField.method_1880(("" + NBTEditorClient.CLIENT_CHEST.getPageCount()).length());
        this.pageField.method_1852("" + (PAGE + 1));
        this.pageField.method_1863(str -> {
            if (str.isEmpty()) {
                return;
            }
            int intVal = Integer.parseInt(str);
            if (intVal > 0) {
                PAGE = intVal - 1;
                ClientChestScreen.show();
            }
        });
        this.pageField.method_1890(MainUtil.intPredicate(() -> 0, NBTEditorClient.CLIENT_CHEST::getPageCount, true));
        this.method_37063((class_364)this.pageField);
        this.nextPage = MVMisc.newButton(this.field_2776 - 24, this.field_2800, 20, 20, TextInst.of(">"), btn -> {
            this.navigationClicked = true;
            this.pageField.method_1852("" + (++PAGE + 1));
            ClientChestScreen.show();
        });
        this.method_37063((class_364)this.nextPage);
        this.prevPageJump = MVMisc.newButton(this.field_2776 - 87, this.field_2800 + 24, 39, 20, TextInst.of("<<"), btn -> {
            this.navigationClicked = true;
            PAGE = prevPageJumpTarget;
            this.pageField.method_1852("" + (PAGE + 1));
            ClientChestScreen.show();
        });
        this.method_37063((class_364)this.prevPageJump);
        this.nextPageJump = MVMisc.newButton(this.field_2776 - 43, this.field_2800 + 24, 39, 20, TextInst.of(">>"), btn -> {
            this.navigationClicked = true;
            PAGE = nextPageJumpTarget;
            this.pageField.method_1852("" + (PAGE + 1));
            ClientChestScreen.show();
        });
        this.method_37063((class_364)this.nextPageJump);
        ((class_4185)this.method_37063((class_364)MVMisc.newButton((int)(this.field_2776 - 87), (int)(this.field_2800 + 48), (int)83, (int)20, (class_2561)(ConfigScreen.isLockSlots() ? TextInst.translatable((String)"nbteditor.client_chest.slots.unlock", (Object[])new Object[0]) : TextInst.translatable((String)"nbteditor.client_chest.slots.lock", (Object[])new Object[0])), (class_4185.class_4241)(class_4185.class_4241)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/class_4185;)V, lambda$init$7(net.minecraft.class_4185 ), (Lnet/minecraft/class_4185;)V)((ClientChestScreen)this)))).field_22763 = !ConfigScreen.isLockSlotsRequired();
        this.method_37063((class_364)MVMisc.newButton(this.field_2776 - 87, this.field_2800 + 72, 83, 20, TextInst.translatable("nbteditor.client_chest.reload_page", new Object[0]), btn -> {
            this.navigationClicked = true;
            try {
                NBTEditorClient.CLIENT_CHEST.loadSync(PAGE);
                ClientChestScreen.show();
            }
            catch (Exception e) {
                NBTEditorClient.CLIENT_CHEST.backupCorruptPage(PAGE);
                try {
                    NBTEditorClient.CLIENT_CHEST.loadSync(PAGE);
                }
                catch (Exception e2) {
                    RuntimeException toThrow = new RuntimeException("Error while reloading a corrupted client chest", e2);
                    toThrow.addSuppressed(e);
                    throw toThrow;
                }
                ClientChestScreen.show();
                NBTEditor.LOGGER.error("Error while reloading client chest", (Throwable)e);
            }
        }));
        this.method_37063((class_364)MVMisc.newButton(this.field_2776 - 87, this.field_2800 + 96, 83, 20, TextInst.translatable("nbteditor.client_chest.clear_page", new Object[0]), btn -> {
            this.navigationClicked = true;
            this.field_22787.method_1507((class_437)new FancyConfirmScreen(value -> {
                if (value) {
                    ((class_1707)this.field_2797).method_7629().method_5448();
                    this.save();
                }
                this.field_22787.method_1507((class_437)this);
            }, TextInst.translatable("nbteditor.client_chest.clear_page.title", new Object[0]), TextInst.translatable("nbteditor.client_chest.clear_page.desc", new Object[0]), TextInst.translatable("nbteditor.client_chest.clear_page.yes", new Object[0]), TextInst.translatable("nbteditor.client_chest.clear_page.no", new Object[0])));
        }));
        this.updatePageNavigation();
    }

    public void updatePageNavigation() {
        int[] jumps = NBTEditorClient.CLIENT_CHEST.getNearestItems(PAGE);
        int maxPage = NBTEditorClient.CLIENT_CHEST.getPageCount() - 1;
        int n = jumps[0] == -1 ? (PAGE == 0 ? -1 : 0) : (prevPageJumpTarget = jumps[0]);
        nextPageJumpTarget = jumps[1] == -1 ? (PAGE == maxPage ? -1 : maxPage) : jumps[1];
        this.prevPage.field_22763 = PAGE != 0;
        this.nextPage.field_22763 = PAGE != maxPage;
        this.prevPageJump.field_22763 = prevPageJumpTarget != -1;
        this.nextPageJump.field_22763 = nextPageJumpTarget != -1;
    }

    protected void method_37432() {
        this.pageField.method_1865();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.method_25419();
        }
        return !ClientChestScreen.handleKeybind(keyCode, this.field_2787, slot -> new ClientChestItemReference(PAGE, slot.method_34266())) && !this.pageField.method_25404(keyCode, scanCode, modifiers) && !this.pageField.method_20315() ? super.method_25404(keyCode, scanCode, modifiers) : true;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.navigationClicked = false;
        MVMisc.setKeyboardRepeatEvents(this.pageField.method_25402(mouseX, mouseY, button));
        super.method_25402(mouseX, mouseY, button);
        return true;
    }

    @Override
    protected void method_2383(class_1735 slot, int slotId, int button, class_1713 actionType) {
        if (this.navigationClicked) {
            return;
        }
        super.method_2383(slot, slotId, button, actionType);
    }

    @Override
    public boolean allowEnchantmentCombine(class_1735 slot) {
        return !ConfigScreen.isLockSlots() || slot.field_7871 == MainUtil.client.field_1724.method_31548();
    }

    @Override
    public void onEnchantmentCombine(class_1735 slot) {
        this.save();
    }

    @Override
    public boolean lockSlots() {
        return ConfigScreen.isLockSlots();
    }

    @Override
    public class_1799[] getPrevInventory() {
        return NBTEditorClient.CLIENT_CHEST.getPage(PAGE);
    }

    @Override
    public void onChange() {
        this.save();
    }

    private void save() {
        this.saved = false;
        class_1799[] items = new class_1799[54];
        for (int i = 0; i < ((class_1707)this.field_2797).method_7629().method_5439(); ++i) {
            items[i] = ((class_1707)this.field_2797).method_7629().method_5438(i).method_7972();
        }
        this.saveQueue.save(() -> {
            this.saved = true;
        }, new SaveRequest(PAGE, items));
    }

    @Override
    protected class_2561 getRenderedTitle() {
        EditableText title = TextInst.copy(this.field_22785).append(" (" + (PAGE + 1) + ")");
        return this.saved ? title : title.append("*");
    }

    @Override
    public boolean method_25421() {
        return true;
    }

    public void method_25432() {
        MVMisc.setKeyboardRepeatEvents(false);
    }

    private /* synthetic */ void lambda$init$7(class_4185 btn) {
        this.navigationClicked = true;
        ConfigScreen.setLockSlots(!ConfigScreen.isLockSlots());
        btn.method_25355((class_2561)(ConfigScreen.isLockSlots() ? TextInst.translatable("nbteditor.client_chest.slots.unlock", new Object[0]) : TextInst.translatable("nbteditor.client_chest.slots.lock", new Object[0])));
    }

    private record SaveRequest(int page, class_1799[] items) {
    }
}

