/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.containers;

import com.luneruniverse.minecraft.mod.nbteditor.NBTEditor;
import com.luneruniverse.minecraft.mod.nbteditor.commands.get.GetLostItemCommand;
import com.luneruniverse.minecraft.mod.nbteditor.containers.ContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.itemreferences.InventoryItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.itemreferences.ItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawableHelper;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.OldEventBehavior;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.NBTEditorScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.containers.ContainerScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.containers.CursorHistoryScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.factories.ItemFactoryScreen;
import com.luneruniverse.minecraft.mod.nbteditor.util.Enchants;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import java.util.function.Function;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1661;
import net.minecraft.class_1707;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_476;

public class ClientHandledScreen
extends class_476
implements OldEventBehavior {
    private static final class_2960 TEXTURE = new class_2960("textures/gui/container/generic_54.png");
    private static class_1263 SERVER_INV;
    private static class_1799 SERVER_CURSOR;
    protected boolean dropCursorOnClose = true;
    private class_1799 beforeClickItem;
    private class_1799 beforeClickCursor;

    public static void updateServerInventory() {
        if (!(MainUtil.client.field_1755 instanceof ClientHandledScreen)) {
            NBTEditor.LOGGER.warn("Attempted to update the server inventory when the client chest wasn't open!");
            return;
        }
        ClientHandledScreen screen = (ClientHandledScreen)MainUtil.client.field_1755;
        class_1661 clientInv = MainUtil.client.field_1724.method_31548();
        class_1799 clientCursor = ((class_1707)screen.field_2797).method_34255();
        for (int i = 0; i < clientInv.method_5439(); ++i) {
            class_1799 clientStack = clientInv.method_5438(i);
            if (class_1799.method_7973((class_1799)clientStack, (class_1799)SERVER_INV.method_5438(i))) continue;
            if (36 <= i && i <= 39) {
                SERVER_INV.method_5447(i, clientStack.method_7972());
                continue;
            }
            MainUtil.client.field_1761.method_2909(clientStack, i == 40 ? 45 : (i < 9 ? i + 36 : i));
            SERVER_INV.method_5447(i, clientStack.method_7972());
        }
        if (!class_1799.method_7973((class_1799)clientCursor, (class_1799)SERVER_CURSOR)) {
            SERVER_CURSOR = clientCursor.method_7972();
        }
    }

    public static boolean handleKeybind(int keyCode, class_1735 hoveredSlot, Function<class_1735, ItemReference> containerRef) {
        if (keyCode == 32 && hoveredSlot != null && (ConfigScreen.isAirEditable() || hoveredSlot.method_7677() != null && !hoveredSlot.method_7677().method_7960())) {
            int slot = hoveredSlot.method_34266();
            ItemReference ref = hoveredSlot.field_7871 == MainUtil.client.field_1724.method_31548() ? new InventoryItemReference(slot >= 36 ? slot - 36 : slot) : containerRef.apply(hoveredSlot);
            ClientHandledScreen.handleKeybind(hoveredSlot, ref);
            return true;
        }
        return false;
    }

    public static void handleKeybind(class_1735 hoveredSlot, ItemReference ref) {
        boolean notAir;
        boolean bl = notAir = hoveredSlot.method_7677() != null && !hoveredSlot.method_7677().method_7960();
        if (ClientHandledScreen.method_25441()) {
            if (notAir && ContainerIO.isContainer(hoveredSlot.method_7677())) {
                ContainerScreen.show(ref);
            }
        } else if (ClientHandledScreen.method_25442()) {
            if (notAir) {
                MainUtil.client.method_1507((class_437)new ItemFactoryScreen(ref));
            }
        } else {
            MainUtil.client.method_1507((class_437)new NBTEditorScreen(ref));
        }
    }

    public ClientHandledScreen(class_1707 handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
        handler.method_34256();
        MainUtil.client.field_1724.field_7512 = handler;
    }

    public static class_1707 createGenericScreenHandler(int rows) {
        class_1661 inv = MainUtil.client.field_1724.method_31548();
        switch (rows) {
            case 1: {
                return class_1707.method_19244((int)0, (class_1661)inv);
            }
            case 2: {
                return class_1707.method_19246((int)0, (class_1661)inv);
            }
            case 3: {
                return class_1707.method_19248((int)0, (class_1661)inv);
            }
            case 4: {
                return class_1707.method_19249((int)0, (class_1661)inv);
            }
            case 5: {
                return class_1707.method_19250((int)0, (class_1661)inv);
            }
            case 6: {
                return class_1707.method_19251((int)0, (class_1661)inv);
            }
        }
        throw new IllegalArgumentException("Rows are limited to 1 to 6!");
    }

    protected void method_25426() {
        super.method_25426();
        SERVER_INV = new class_1277(this.field_22787.field_1724.method_31548().method_5439());
        for (int i = 0; i < this.field_22787.field_1724.method_31548().method_5439(); ++i) {
            SERVER_INV.method_5447(i, this.field_22787.field_1724.method_31548().method_5438(i).method_7972());
        }
        SERVER_CURSOR = ((class_1707)this.field_2797).method_34255().method_7972();
    }

    protected void drawBackground(class_4587 matrices, float delta, int mouseX, int mouseY) {
        MVDrawableHelper.drawTexture(matrices, TEXTURE, this.field_2776, this.field_2800, 0.0f, 0.0f, this.field_2792, ((class_1707)this.field_2797).method_17388() * 18 + 17);
        MVDrawableHelper.drawTexture(matrices, TEXTURE, this.field_2776, this.field_2800 + ((class_1707)this.field_2797).method_17388() * 18 + 17, 0.0f, 126.0f, this.field_2792, 96);
        if (this.showLogo()) {
            MainUtil.renderLogo(matrices);
        }
    }

    protected final void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        this.drawBackground(MVDrawableHelper.getMatrices(context), delta, mouseX, mouseY);
    }

    protected final void method_2389(class_4587 matrices, float delta, int mouseX, int mouseY) {
        this.drawBackground(matrices, delta, mouseX, mouseY);
    }

    protected boolean showLogo() {
        return true;
    }

    protected void drawForeground(class_4587 matrices, int mouseX, int mouseY) {
        MVDrawableHelper.drawTextWithoutShadow(matrices, this.field_22793, this.getRenderedTitle(), this.field_25267, this.field_25268, 0x404040);
        MVDrawableHelper.drawTextWithoutShadow(matrices, this.field_22793, this.field_29347, this.field_25269, this.field_25270, 0x404040);
    }

    protected final void method_2388(class_332 context, int mouseX, int mouseY) {
        this.drawForeground(MVDrawableHelper.getMatrices(context), mouseX, mouseY);
    }

    protected final void method_2388(class_4587 matrices, int mouseX, int mouseY) {
        this.drawForeground(matrices, mouseX, mouseY);
    }

    protected class_2561 getRenderedTitle() {
        return this.field_22785;
    }

    public final boolean isPauseScreen() {
        return this.method_25421();
    }

    public boolean method_25421() {
        return false;
    }

    public final void onClose() {
        this.method_25419();
    }

    public void method_25419() {
        class_1799 cursor = ((class_1707)this.field_2797).method_34255();
        if (this.dropCursorOnClose && cursor != null && !cursor.method_7960()) {
            MainUtil.get(cursor, true);
        }
        this.field_22787.field_1724.method_7346();
        this.field_22787.method_1507(null);
    }

    protected void method_2383(class_1735 slot, int slotId, int button, class_1713 actionType) {
        if (slot != null) {
            this.beforeClickItem = slot.method_7677().method_7972();
        }
        this.beforeClickCursor = ((class_1707)this.field_2797).method_34255().method_7972();
        if (!this.beforeClickCursor.method_7960() && !(this instanceof CursorHistoryScreen)) {
            GetLostItemCommand.addToHistory(this.beforeClickCursor);
        }
        if (slot != null && this.allowEnchantmentCombine(slot) && class_437.method_25441() && this.tryCombineEnchantments(slot, actionType)) {
            this.onEnchantmentCombine(slot);
        } else {
            super.method_2383(slot, slotId, button, actionType);
        }
        class_1799[] prev = this.getPrevInventory();
        if (prev == null) {
            return;
        }
        boolean changed = false;
        boolean lockRevertUsed = false;
        boolean locked = this.lockSlots();
        for (int i = 0; i < ((class_1707)this.field_2797).method_7629().method_5439(); ++i) {
            if (class_1799.method_7973((class_1799)(prev[i] == null ? class_1799.field_8037 : prev[i]), (class_1799)((class_1707)this.field_2797).method_7629().method_5438(i))) continue;
            if (locked) {
                if (prev[i] == null || prev[i].method_7960()) {
                    changed = true;
                    continue;
                }
                ((class_1707)this.field_2797).method_7629().method_5447(i, prev[i].method_7972());
                lockRevertUsed = true;
                continue;
            }
            changed = true;
            break;
        }
        if (changed) {
            this.onChange();
        }
        if (lockRevertUsed && this.beforeClickCursor != null && !this.beforeClickCursor.method_7960() && this.field_22787.field_1724.method_7337()) {
            GetLostItemCommand.loseItem(this.beforeClickCursor);
        }
    }

    public void throwCursor() {
        this.field_22787.field_1761.method_2915(this.beforeClickCursor);
    }

    public void throwSlot(int slot, boolean fullStack) {
        class_1799 stack = this.beforeClickItem;
        if (!fullStack) {
            stack.method_7939(1);
        }
        this.field_22787.field_1761.method_2915(stack);
    }

    private boolean tryCombineEnchantments(class_1735 slot, class_1713 actionType) {
        if (actionType == class_1713.field_7790 && slot != null) {
            class_1799 cursor = ((class_1707)this.field_2797).method_34255();
            class_1799 item = slot.method_7677();
            if (cursor == null || cursor.method_7960() || item == null || item.method_7960()) {
                return false;
            }
            if (cursor.method_7909() == class_1802.field_8598 || item.method_7909() == class_1802.field_8598) {
                if (cursor.method_7909() != class_1802.field_8598) {
                    class_1799 temp = cursor;
                    cursor = item;
                    item = temp;
                }
                new Enchants(item).addEnchants(new Enchants(cursor).getEnchants());
                slot.method_7673(item);
                ((class_1707)this.field_2797).method_34254(class_1799.field_8037);
                return true;
            }
        }
        return false;
    }

    public boolean allowEnchantmentCombine(class_1735 slot) {
        return false;
    }

    public void onEnchantmentCombine(class_1735 slot) {
    }

    public boolean lockSlots() {
        return false;
    }

    public class_1799[] getPrevInventory() {
        return null;
    }

    public void onChange() {
    }
}

