/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.containers;

import com.luneruniverse.minecraft.mod.nbteditor.containers.ContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.itemreferences.ContainerItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.itemreferences.ItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVTooltip;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ConfigScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.containers.ClientHandledScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.containers.ContainerHandler;
import com.luneruniverse.minecraft.mod.nbteditor.screens.factories.ItemFactoryScreen;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import java.lang.invoke.LambdaMetafactory;
import net.minecraft.class_1661;
import net.minecraft.class_1707;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class ContainerScreen
extends ClientHandledScreen {
    private boolean saved = true;
    private final class_2561 unsavedTitle;
    private ItemReference ref;
    private class_1799 item;
    private int blockedInvSlot;
    private int blockedHotbarSlot;
    private int numSlots;
    private class_1799[] prevInv;
    private boolean navigationClicked;

    public ContainerScreen(class_1707 handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
        this.unsavedTitle = TextInst.copy(title).append("*");
    }

    private ContainerScreen build(ItemReference ref) {
        this.ref = ref;
        this.item = ref.getItem().method_7972();
        this.blockedInvSlot = ref.getBlockedInvSlot();
        if (this.blockedInvSlot != -1) {
            this.blockedInvSlot += 27;
        }
        this.blockedHotbarSlot = ref.getBlockedHotbarSlot();
        class_1799[] contents = ContainerIO.read(this.item);
        for (int i = 0; i < contents.length; ++i) {
            ((class_1707)this.field_2797).method_7611(i).method_7673(contents[i] == null ? class_1799.field_8037 : contents[i]);
        }
        this.numSlots = contents.length;
        return this;
    }

    public static void show(ItemReference ref) {
        class_1661 inv = MainUtil.client.field_1724.method_31548();
        MainUtil.client.method_1507((class_437)new ContainerScreen(new ContainerHandler(0, inv), inv, TextInst.translatable("nbteditor.container.title", new Object[0]).append(ref.getItem().method_7964())).build(ref));
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        if (this.ref.isLockable()) {
            ((class_4185)this.method_37063((class_364)MVMisc.newButton((int)16, (int)64, (int)83, (int)20, (class_2561)(ConfigScreen.isLockSlots() ? TextInst.translatable((String)"nbteditor.client_chest.slots.unlock", (Object[])new Object[0]) : TextInst.translatable((String)"nbteditor.client_chest.slots.lock", (Object[])new Object[0])), (class_4185.class_4241)(class_4185.class_4241)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/class_4185;)V, lambda$init$0(net.minecraft.class_4185 ), (Lnet/minecraft/class_4185;)V)((ContainerScreen)this)))).field_22763 = !ConfigScreen.isLockSlotsRequired();
        }
        this.method_37063((class_364)MVMisc.newTexturedButton(this.field_22789 - 36, 22, 20, 20, 20, ItemFactoryScreen.FACTORY_ICON, btn -> this.field_22787.method_1507((class_437)new ItemFactoryScreen(this.ref)), new MVTooltip("nbteditor.item_factory")));
    }

    @Override
    protected class_2561 getRenderedTitle() {
        return this.saved ? this.field_22785 : this.unsavedTitle;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.navigationClicked = false;
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    protected void method_2383(class_1735 slot, int slotId, int button, class_1713 actionType) {
        if (this.navigationClicked) {
            return;
        }
        if (slot != null && slot.field_7874 == this.blockedInvSlot) {
            return;
        }
        if (actionType == class_1713.field_7791 && button == this.blockedHotbarSlot) {
            return;
        }
        if (slot != null && slot.field_7874 >= this.numSlots && slot.field_7871 == ((class_1707)this.field_2797).method_7629() && (slot.method_7677() == null || slot.method_7677().method_7960())) {
            return;
        }
        this.prevInv = new class_1799[((class_1707)this.field_2797).method_7629().method_5439()];
        for (int i = 0; i < this.prevInv.length; ++i) {
            this.prevInv[i] = ((class_1707)this.field_2797).method_7629().method_5438(i).method_7972();
        }
        super.method_2383(slot, slotId, button, actionType);
    }

    @Override
    public boolean allowEnchantmentCombine(class_1735 slot) {
        return slot.field_7874 != this.blockedInvSlot;
    }

    @Override
    public void onEnchantmentCombine(class_1735 slot) {
        this.save();
    }

    @Override
    public boolean lockSlots() {
        return this.ref.isLocked();
    }

    @Override
    public class_1799[] getPrevInventory() {
        return this.prevInv;
    }

    @Override
    public void onChange() {
        this.save();
    }

    private void save() {
        class_1799[] contents = new class_1799[((class_1707)this.field_2797).method_7629().method_5439()];
        for (int i = 0; i < contents.length; ++i) {
            contents[i] = ((class_1707)this.field_2797).method_7629().method_5438(i);
        }
        ContainerIO.write(this.item, contents);
        this.saved = false;
        this.ref.saveItem(this.item, () -> {
            this.saved = true;
        });
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.ref.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 32 && this.field_2787 != null && (this.field_2787.field_7874 < this.numSlots || this.field_2787.field_7871 != ((class_1707)this.field_2797).method_7629()) && ContainerScreen.handleKeybind(keyCode, this.field_2787, slot -> new ContainerItemReference(this.ref, slot.method_34266()))) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean method_25421() {
        return true;
    }

    public ItemReference getReference() {
        return this.ref;
    }

    public void method_25432() {
        for (int i = this.numSlots; i < 27; ++i) {
            class_1799 item = ((class_1707)this.field_2797).method_7629().method_5438(i);
            if (item == null || item.method_7960()) continue;
            MainUtil.get(item, true);
        }
        super.method_25432();
    }

    private /* synthetic */ void lambda$init$0(class_4185 btn) {
        this.navigationClicked = true;
        ConfigScreen.setLockSlots(!ConfigScreen.isLockSlots());
        btn.method_25355((class_2561)(ConfigScreen.isLockSlots() ? TextInst.translatable("nbteditor.client_chest.slots.unlock", new Object[0]) : TextInst.translatable("nbteditor.client_chest.slots.lock", new Object[0])));
    }
}

