/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.factories;

import com.luneruniverse.minecraft.mod.nbteditor.itemreferences.ItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVRegistry;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVTooltip;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ItemEditorScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigBar;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigButton;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigCategory;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigHiddenData;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigHiddenDataNamed;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigItem;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigList;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigPanel;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigPath;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigValueDropdown;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigValueDropdownEnum;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigValueNumber;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1320;
import net.minecraft.class_1329;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class AttributesScreen
extends ItemEditorScreen {
    private static final Map<String, class_1320> ATTRIBUTES = MVRegistry.ATTRIBUTE.getEntrySet().stream().map(attribute -> Map.entry(((class_2960)attribute.getKey()).toString(), (class_1320)attribute.getValue())).sorted((a, b) -> ((String)a.getKey()).compareToIgnoreCase((String)b.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, LinkedHashMap::new));
    private static final ConfigHiddenDataNamed<ConfigCategory, UUID> ATTRIBUTE_ENTRY;
    private final ConfigList attributes;
    private ConfigPanel panel;

    private static ConfigValueDropdown<String> getConfigAttribute(ConfigCategory attribute) {
        return (ConfigValueDropdown)((ConfigItem)attribute.getConfigurable("attribute")).getValue();
    }

    private static ConfigValueDropdown<Operation> getConfigOperation(ConfigCategory attribute) {
        return (ConfigValueDropdown)((ConfigItem)attribute.getConfigurable("operation")).getValue();
    }

    private static ConfigValueNumber<Double> getConfigAmount(ConfigCategory attribute) {
        return (ConfigValueNumber)((ConfigItem)((ConfigBar)attribute.getConfigurable("amount")).getConfigurable("number")).getValue();
    }

    private static ConfigValueDropdown<Slot> getConfigSlot(ConfigCategory attribute) {
        return (ConfigValueDropdown)((ConfigItem)attribute.getConfigurable("slot")).getValue();
    }

    public AttributesScreen(ItemReference ref) {
        super(TextInst.of("Item Attributes"), ref);
        class_2487 nbt = this.item.method_7948();
        class_2499 attributesNbt = nbt.method_10554("AttributeModifiers", 10);
        this.attributes = new ConfigList(TextInst.translatable("nbteditor.attributes", new Object[0]), false, ATTRIBUTE_ENTRY);
        for (class_2520 element : attributesNbt) {
            class_2487 attributeNbt = (class_2487)element;
            ConfigHiddenData fullAttribute = ATTRIBUTE_ENTRY.clone(true);
            ConfigCategory attribute = (ConfigCategory)fullAttribute.getVisible();
            Object attributeName = attributeNbt.method_10558("AttributeName");
            if (!((String)attributeName).contains(":")) {
                attributeName = "minecraft:" + (String)attributeName;
            }
            if (!ATTRIBUTES.containsKey(attributeName)) continue;
            AttributesScreen.getConfigAttribute(attribute).setValue((String)attributeName);
            int operation = attributeNbt.method_10550("Operation");
            if (operation < 0 || operation >= Operation.values().length) continue;
            AttributesScreen.getConfigOperation(attribute).setValue(Operation.values()[operation]);
            AttributesScreen.getConfigAmount(attribute).setValue(attributeNbt.method_10574("Amount"));
            String slotStr = attributeNbt.method_10558("Slot");
            Slot slot = Slot.ALL;
            if (!slotStr.isEmpty()) {
                try {
                    slot = Slot.valueOf(slotStr.toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            AttributesScreen.getConfigSlot(attribute).setValue(slot);
            if (!attributeNbt.method_25928("UUID")) continue;
            fullAttribute.setData(attributeNbt.method_25926("UUID"));
            this.attributes.addConfigurable(fullAttribute);
        }
        this.attributes.addValueListener(source -> {
            attributesNbt.clear();
            for (ConfigPath path : this.attributes.getConfigurables().values()) {
                ConfigHiddenDataNamed fullAttribute = (ConfigHiddenDataNamed)path;
                ConfigCategory attribute = (ConfigCategory)fullAttribute.getVisible();
                class_2487 attributeNbt = new class_2487();
                attributeNbt.method_25927("UUID", (UUID)fullAttribute.getData());
                attributeNbt.method_10582("AttributeName", (String)AttributesScreen.getConfigAttribute(attribute).getValidValue());
                attributeNbt.method_10582("Name", attributeNbt.method_10558("AttributeName"));
                attributeNbt.method_10569("Operation", ((Operation)((Object)((Object)AttributesScreen.getConfigOperation(attribute).getValidValue()))).ordinal());
                attributeNbt.method_10549("Amount", ((Double)AttributesScreen.getConfigAmount(attribute).getValidValue()).doubleValue());
                Slot slot = (Slot)((Object)((Object)AttributesScreen.getConfigSlot(attribute).getValidValue()));
                if (slot != Slot.ALL) {
                    attributeNbt.method_10582("Slot", slot.name().toLowerCase());
                }
                attributesNbt.add((Object)attributeNbt);
            }
            if (attributesNbt.isEmpty()) {
                nbt.method_10551("AttributeModifiers");
            } else {
                nbt.method_10566("AttributeModifiers", (class_2520)attributesNbt);
            }
            this.checkSave();
        });
    }

    @Override
    protected void initEditor() {
        ConfigPanel newPanel = (ConfigPanel)this.method_37063(new ConfigPanel(16, 64, this.field_22789 - 32, this.field_22790 - 80, this.attributes));
        if (this.panel != null) {
            newPanel.setScroll(this.panel.getScroll());
        }
        this.panel = newPanel;
    }

    static {
        String firstAttribute = (String)ATTRIBUTES.keySet().stream().findFirst().get();
        ConfigCategory visible = new ConfigCategory();
        visible.setConfigurable("attribute", new ConfigItem<ConfigValueDropdown<String>>(TextInst.translatable("nbteditor.attributes.attribute", new Object[0]), new ConfigValueDropdown<String>(firstAttribute, firstAttribute, new ArrayList<String>(ATTRIBUTES.keySet()))));
        visible.setConfigurable("operation", new ConfigItem<ConfigValueDropdownEnum<Operation>>(TextInst.translatable("nbteditor.attributes.operation", new Object[0]), new ConfigValueDropdownEnum<Operation>(Operation.ADD, Operation.ADD, Operation.class)));
        visible.setConfigurable("amount", (ConfigPath)((ConfigBar)new ConfigBar().setConfigurable("number", new ConfigItem<ConfigValueNumber<Double>>(TextInst.translatable("nbteditor.attributes.amount", new Object[0]), ConfigValueNumber.forDouble(0.0, 0.0, -1.7976931348623157E308, Double.MAX_VALUE)))).setConfigurable("autofill", new MaxButton()));
        visible.setConfigurable("slot", new ConfigItem<ConfigValueDropdownEnum<Slot>>(TextInst.translatable("nbteditor.attributes.slot", new Object[0]), new ConfigValueDropdownEnum<Slot>(Slot.ALL, Slot.ALL, Slot.class)));
        ATTRIBUTE_ENTRY = new ConfigHiddenDataNamed<ConfigCategory, UUID>(visible, UUID.randomUUID(), (uuid, defaults) -> UUID.randomUUID());
    }

    private static enum Operation {
        ADD("Add"),
        MULTIPLY_BASE("Multiply Base"),
        MULTIPLY("Multiply");

        private final String name;

        private Operation(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private static enum Slot {
        ALL("All"),
        MAINHAND("Main Hand"),
        OFFHAND("Off Hand"),
        HEAD("Head"),
        CHEST("Chest"),
        LEGS("Legs"),
        FEET("Feet");

        private final String name;

        private Slot(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class MaxButton
    extends ConfigButton {
        private static final class_2561 MAX = TextInst.translatable("nbteditor.attributes.amount.max", new Object[0]);
        private static final class_2561 MIN = TextInst.translatable("nbteditor.attributes.amount.min", new Object[0]);
        private static final class_2561 INFINITY = TextInst.translatable("nbteditor.attributes.amount.infinity", new Object[0]);
        private static final class_2561 NEG_INFINITY = TextInst.translatable("nbteditor.attributes.amount.negative_infinity", new Object[0]);
        private static final MVTooltip TOOLTIP = new MVTooltip("nbteditor.attributes.amount.autofill_keybinds");

        public MaxButton() {
            super(100, MaxButton.getMaxMsg(), btn -> {
                ConfigCategory attribute = (ConfigCategory)btn.getParent().getParent();
                class_1320 type = ATTRIBUTES.get(AttributesScreen.getConfigAttribute(attribute).getValidValue());
                double max = Double.MAX_VALUE;
                double min = Double.MIN_VALUE;
                if (type instanceof class_1329) {
                    class_1329 clamped = (class_1329)type;
                    max = clamped.method_35062();
                    min = clamped.method_35061();
                }
                boolean shift = class_437.method_25442();
                boolean ctrl = class_437.method_25441();
                double value = !shift ? (!ctrl ? max : min) : (!ctrl ? Double.MAX_VALUE : -1.7976931348623157E308);
                AttributesScreen.getConfigAmount(attribute).setValue(value);
            }, TOOLTIP);
        }

        private static class_2561 getMaxMsg() {
            boolean shift = class_437.method_25442();
            boolean ctrl = class_437.method_25441();
            if (!shift) {
                if (!ctrl) {
                    return MAX;
                }
                return MIN;
            }
            if (!ctrl) {
                return INFINITY;
            }
            return NEG_INFINITY;
        }

        @Override
        public void render(class_4587 matrices, int mouseX, int mouseY, float delta) {
            this.method_25355(MaxButton.getMaxMsg());
            super.render(matrices, mouseX, mouseY, delta);
        }

        @Override
        public MaxButton clone(boolean defaults) {
            return new MaxButton();
        }
    }
}

