/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.factories;

import com.luneruniverse.minecraft.mod.nbteditor.itemreferences.ItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawableHelper;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ItemEditorScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigCategory;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigItem;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigPanel;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigValue;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigValueDropdown;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1747;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4587;

public class BlockStatesScreen
extends ItemEditorScreen {
    private final ConfigCategory blockStates;
    private final boolean hasBlockStates;
    private ConfigPanel panel;

    public BlockStatesScreen(ItemReference ref) {
        super(TextInst.of("Block States"), ref);
        class_2680 defaultState = ((class_1747)this.item.method_7909()).method_7711().method_9564();
        this.hasBlockStates = !defaultState.method_28501().isEmpty();
        this.blockStates = new ConfigCategory(this.hasBlockStates ? TextInst.translatable("nbteditor.block_states", new Object[0]) : null);
        class_2487 nbt = this.item.method_7948();
        class_2487 blockStatesNbt = nbt.method_10562("BlockStateTag");
        for (class_2769 property : defaultState.method_28501()) {
            String thisState = Optional.of(blockStatesNbt.method_10558(property.method_11899())).filter(state -> !state.isEmpty()).orElse("unset");
            List options = property.method_11898().stream().map(Object::toString).collect(Collectors.toList());
            options.add(0, "unset");
            if (!options.contains(thisState)) {
                thisState = "unset";
            }
            this.blockStates.setConfigurable(property.method_11899(), new ConfigItem<ConfigValue>(TextInst.literal(property.method_11899()), new ConfigValueDropdown<String>(thisState, defaultState.method_11654(property).toString(), options).addValueListener(dropdown -> {
                String value = (String)dropdown.getValidValue();
                if (value.equals("unset")) {
                    blockStatesNbt.method_10551(property.method_11899());
                } else {
                    blockStatesNbt.method_10582(property.method_11899(), value);
                }
                nbt.method_10566("BlockStateTag", (class_2520)blockStatesNbt);
                this.checkSave();
            })));
        }
    }

    @Override
    protected void initEditor() {
        ConfigPanel newPanel = (ConfigPanel)this.method_37063(new ConfigPanel(16, 64, this.field_22789 - 32, this.field_22790 - 80, this.blockStates));
        if (this.panel != null) {
            newPanel.setScroll(this.panel.getScroll());
        }
        this.panel = newPanel;
    }

    @Override
    public void renderEditor(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (!this.hasBlockStates) {
            MVDrawableHelper.drawTextWithShadow(matrices, this.field_22793, TextInst.translatable("nbteditor.block_states.none", new Object[0]), 16, 64, -1);
        }
    }
}

