/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.factories;

import com.luneruniverse.minecraft.mod.nbteditor.itemreferences.ItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.misc.MixinLink;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.EditableText;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVDrawableHelper;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVMisc;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVTooltip;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ItemEditorScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigValueDropdownEnum;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.AlertWidget;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.FormattedTextFieldWidget;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.GroupWidget;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.ImageToLoreWidget;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.NamedTextFieldWidget;
import com.luneruniverse.minecraft.mod.nbteditor.screens.widgets.TranslatedGroupWidget;
import com.luneruniverse.minecraft.mod.nbteditor.util.Lore;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3872;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class BookScreen
extends ItemEditorScreen {
    private int page;
    private GroupWidget group;
    private NamedTextFieldWidget title;
    private NamedTextFieldWidget author;
    private GroupWidget gen;
    private FormattedTextFieldWidget contents;

    public BookScreen(ItemReference ref, int page) {
        super(TextInst.of("Book"), ref);
        this.page = page;
    }

    public BookScreen(ItemReference ref) {
        this(ref, 0);
    }

    private String getBookTitle() {
        return this.item.method_7948().method_10558("title");
    }

    private void setBookTitle(String title) {
        this.item.method_7948().method_10582("title", title);
        this.item.method_7969().method_10551("filtered_title");
        this.checkSave();
    }

    private String getAuthor() {
        return this.item.method_7948().method_10558("author");
    }

    private void setAuthor(String author) {
        this.item.method_7948().method_10582("author", author);
        this.checkSave();
    }

    private Generation getGeneration() {
        int gen = this.item.method_7948().method_10550("generation");
        if (gen < 0 || gen >= 4) {
            return Generation.TATTERED;
        }
        return Generation.values()[gen];
    }

    private void setGeneration(Generation gen) {
        this.item.method_7948().method_10569("generation", gen.ordinal());
        this.checkSave();
    }

    private int getPageCount() {
        return this.item.method_7948().method_10554("pages", 8).size();
    }

    private class_2561 getPage() {
        EditableText output = TextInst.literal("");
        MixinLink.getActualContents(this.item).method_17563(this.page).method_27658((style, str) -> {
            output.append(TextInst.literal(str).setStyle(style));
            return Optional.empty();
        }, class_2583.field_24360);
        return output;
    }

    private void setPage(class_2561 contents) {
        class_2499 pages = this.item.method_7948().method_10554("pages", 8);
        class_2519 nbtContents = class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)contents));
        if (this.page < pages.size()) {
            pages.method_10606(this.page, (class_2520)nbtContents);
        } else {
            while (this.page > pages.size()) {
                pages.add((Object)class_2519.method_23256((String)"{\"text\":\"\"}"));
            }
            pages.add((Object)nbtContents);
        }
        this.item.method_7969().method_10566("pages", (class_2520)pages);
        if (this.item.method_7969().method_10573("filtered_pages", 10)) {
            this.item.method_7969().method_10562("filtered_pages").method_10551("" + this.page);
        }
        this.checkSave();
    }

    private void addPage() {
        class_2499 pages = this.item.method_7948().method_10554("pages", 8);
        if (this.page < pages.size()) {
            pages.method_10531(this.page, (class_2520)class_2519.method_23256((String)"{\"text\":\"\"}"));
            this.checkSave();
            this.refresh();
        }
    }

    private void removePage() {
        class_2499 pages = this.item.method_7948().method_10554("pages", 8);
        if (this.page < pages.size()) {
            pages.method_10536(this.page);
            this.checkSave();
            this.refresh();
        }
    }

    private void back() {
        if (this.page > 0) {
            --this.page;
            this.refresh();
        }
    }

    private void forward() {
        ++this.page;
        this.refresh();
    }

    private void refresh() {
        this.contents = null;
        this.method_37067();
        this.method_25426();
    }

    private class_3872.class_3931 getPreviewItem() {
        class_1799 output = this.item.method_7972();
        if (!output.method_7985()) {
            return new class_3872.class_3931(){

                public int method_17560() {
                    return 0;
                }

                public class_5348 method_17561(int page) {
                    return TextInst.of("");
                }
            };
        }
        class_2499 pages = output.method_7969().method_10554("pages", 8);
        final ArrayList<class_2561> previewPages = new ArrayList<class_2561>();
        for (int i = 0; i < pages.size(); ++i) {
            previewPages.add(this.makePreviewText((class_2561)class_2561.class_2562.method_10877((String)pages.method_10608(i))));
        }
        return new class_3872.class_3931(){

            public int method_17560() {
                return previewPages.size();
            }

            public class_5348 method_17561(int page) {
                return (class_5348)previewPages.get(page);
            }
        };
    }

    private class_2561 makePreviewText(class_2561 text) {
        EditableText output = TextInst.copy(text);
        output.setStyle(this.makePreviewStyle(output.method_10866()));
        output.method_10855().replaceAll(this::makePreviewText);
        return output;
    }

    private class_2583 makePreviewStyle(class_2583 style) {
        if (style.method_10970() == null) {
            return style;
        }
        return MixinLink.withRunClickEvent(style, () -> {
            class_3872 preview = (class_3872)this.getOverlay();
            this.setOverlay(new AlertWidget(() -> this.setOverlayScreen(preview, 200.0), TextInst.translatable("nbteditor.book.preview.click.title", new Object[0]), TextInst.of(""), TextInst.translatable("nbteditor.book.preview.click.action", style.method_10970().method_10845().method_10846()), TextInst.of(""), TextInst.translatable("nbteditor.book.preview.click.value", style.method_10970().method_10844())), 200.0);
        });
    }

    @Override
    protected void initEditor() {
        MVMisc.setKeyboardRepeatEvents(true);
        this.group = new GroupWidget();
        this.method_37063(this.group);
        this.title = this.group.addWidget(new NamedTextFieldWidget(this.field_22793, 16, 66, 100, 16, TextInst.of("")).name(TextInst.translatable("nbteditor.book.title", new Object[0])));
        this.title.method_1880(32);
        this.title.method_1852(this.getBookTitle());
        this.title.method_1863(this::setBookTitle);
        this.author = this.group.addWidget(new NamedTextFieldWidget(this.field_22793, 124, 66, 100, 16, TextInst.of("")).name(TextInst.translatable("nbteditor.book.author", new Object[0])));
        this.author.method_1880(Integer.MAX_VALUE);
        this.author.method_1852(this.getAuthor());
        this.author.method_1863(this::setAuthor);
        this.gen = this.group.addElement(TranslatedGroupWidget.forWidget(new ConfigValueDropdownEnum<Generation>(this.getGeneration(), Generation.ORIGINAL, Generation.class).addValueListener(value -> this.setGeneration((Generation)((Object)((Object)value.getValidValue())))), 232.0, 64.0, 0.0));
        this.group.addWidget(MVMisc.newButton(336, 64, 20, 20, TextInst.translatable("nbteditor.book.add", new Object[0]), btn -> this.addPage()));
        this.group.addWidget(MVMisc.newButton(360, 64, 20, 20, TextInst.translatable("nbteditor.book.remove", new Object[0]), btn -> this.removePage()));
        this.group.addWidget(MVMisc.newButton(384, 64, 20, 20, TextInst.translatable("nbteditor.book.preview.icon", new Object[0]), btn -> {
            class_3872 preview = new class_3872(this.getPreviewItem()){

                public boolean method_25404(int keyCode, int scanCode, int modifiers) {
                    if (keyCode == 256) {
                        BookScreen.this.setOverlay(null);
                        return true;
                    }
                    return super.method_25404(keyCode, scanCode, modifiers);
                }
            };
            this.setOverlayScreen(preview, 200.0);
            preview.method_17556(this.page);
        }, new MVTooltip("nbteditor.book.preview")));
        this.contents = this.group.addWidget(FormattedTextFieldWidget.create(this.contents, 40, 88, this.field_22789 - 32 - 48, this.field_22790 - 80 - 24, this.getPage(), true, class_2583.field_24360.method_10977(class_124.field_1074), this::setPage));
        this.contents.setBackgroundColor(-132885);
        this.contents.setCursorColor(-16777216);
        this.contents.setSelectionColor(0x55000000);
        this.contents.setShadow(false);
        this.group.addDrawable(this.gen);
        this.group.addWidget(MVMisc.newButton((int)16, (int)88, (int)20, (int)(this.field_22790 - 80 - 24), (class_2561)TextInst.translatable((String)"nbteditor.book.back", (Object[])new Object[0]), (class_4185.class_4241)(class_4185.class_4241)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/class_4185;)V, lambda$initEditor$7(net.minecraft.class_4185 ), (Lnet/minecraft/class_4185;)V)((BookScreen)this))).field_22763 = this.page > 0;
        this.group.addWidget(MVMisc.newButton(this.field_22789 - 16 - 20, 88, 20, this.field_22790 - 80 - 24, TextInst.translatable("nbteditor.book.forward", new Object[0]), btn -> this.forward()));
    }

    @Override
    protected void renderEditor(class_4587 matrices, int fdf8eb, int mouseY, float delta) {
        EditableText editableText = TextInst.translatable("nbteditor.book.page", this.page + 1, this.getPageCount());
        Objects.requireNonNull(this.field_22793);
        MVDrawableHelper.drawTextWithShadow(matrices, this.field_22793, editableText, 408, 74 - 9 / 2, -1);
        this.renderTip(matrices, "nbteditor.formatted_text.tip");
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        return switch (keyCode) {
            case 266 -> {
                this.back();
                yield true;
            }
            case 267 -> {
                this.forward();
                yield true;
            }
            default -> false;
        };
    }

    public void method_29638(List<Path> paths) {
        AtomicReference newPage = new AtomicReference();
        Lore.LoreConsumer loreConsumer = Lore.LoreConsumer.createAppendPage(this.getPage(), newPage::setPlain);
        ImageToLoreWidget.openImportFiles(paths, file -> loreConsumer, () -> this.contents.setText((class_2561)newPage.getPlain()));
    }

    public void method_25432() {
        MVMisc.setKeyboardRepeatEvents(false);
    }

    private /* synthetic */ void lambda$initEditor$7(class_4185 btn) {
        this.back();
    }

    private static enum Generation {
        ORIGINAL,
        COPY_OF_ORIGINAL,
        COPY_OF_COPY,
        TATTERED;


        public String toString() {
            return TextInst.translatable("book.generation." + this.ordinal(), new Object[0]).getString();
        }
    }
}

