/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.factories;

import com.luneruniverse.minecraft.mod.nbteditor.itemreferences.ItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.MVRegistry;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ItemEditorScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigCategory;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigItem;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigList;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigPanel;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigPath;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigValueDropdown;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigValueNumber;
import com.luneruniverse.minecraft.mod.nbteditor.util.Enchants;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2960;
import net.minecraft.class_4587;

public class EnchantmentsScreen
extends ItemEditorScreen {
    private static final Map<String, class_1887> ENCHANTMENTS = MVRegistry.ENCHANTMENT.getEntrySet().stream().map(enchant -> Map.entry(((class_2960)enchant.getKey()).toString(), (class_1887)enchant.getValue())).sorted((a, b) -> ((String)a.getKey()).compareToIgnoreCase((String)b.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, LinkedHashMap::new));
    private final ConfigList config;
    private ConfigPanel panel;

    private static ConfigValueDropdown<String> getConfigEnchantment(ConfigCategory enchant) {
        return (ConfigValueDropdown)((ConfigItem)enchant.getConfigurable("enchantment")).getValue();
    }

    private static ConfigValueNumber<Integer> getConfigLevel(ConfigCategory enchant) {
        return (ConfigValueNumber)((ConfigItem)enchant.getConfigurable("level")).getValue();
    }

    public EnchantmentsScreen(ItemReference ref) {
        super(TextInst.of("Enchantments"), ref);
        class_1799 inputItem = ref.getItem();
        ConfigCategory entry = new ConfigCategory();
        List<String> orderedEnchants = ENCHANTMENTS.entrySet().stream().map(enchant -> Map.entry((String)enchant.getKey(), ((class_1887)enchant.getValue()).method_8192(inputItem))).sorted((a, b) -> {
            if (((Boolean)a.getValue()).booleanValue()) {
                if (!((Boolean)b.getValue()).booleanValue()) {
                    return -1;
                }
            } else if (((Boolean)b.getValue()).booleanValue()) {
                return 1;
            }
            return ((String)a.getKey()).compareToIgnoreCase((String)b.getKey());
        }).map(Map.Entry::getKey).toList();
        String firstEnchant = orderedEnchants.get(0);
        entry.setConfigurable("enchantment", new ConfigItem<ConfigValueDropdown<String>>(TextInst.translatable("nbteditor.enchantments.enchantment", new Object[0]), new ConfigValueDropdown<String>(firstEnchant, firstEnchant, orderedEnchants, ENCHANTMENTS.entrySet().stream().filter(enchant -> ((class_1887)enchant.getValue()).method_8192(inputItem)).map(Map.Entry::getKey).toList())));
        entry.setConfigurable("level", new ConfigItem<ConfigValueNumber<Integer>>(TextInst.translatable("nbteditor.enchantments.level", new Object[0]), ConfigValueNumber.forInt(1, 1, 1, Short.MAX_VALUE)));
        this.config = new ConfigList(TextInst.translatable("nbteditor.enchantments", new Object[0]), false, entry);
        new Enchants(this.item).getEnchants().forEach(enchant -> {
            ConfigCategory enchantConfig = (ConfigCategory)entry.clone(true);
            EnchantmentsScreen.getConfigEnchantment(enchantConfig).setValue(MVRegistry.ENCHANTMENT.getId(enchant.enchant()).toString());
            EnchantmentsScreen.getConfigLevel(enchantConfig).setValue(enchant.level());
            this.config.addConfigurable(enchantConfig);
        });
        this.config.addValueListener(source -> {
            ArrayList<Enchants.EnchantWithLevel> newEnchants = new ArrayList<Enchants.EnchantWithLevel>();
            for (ConfigPath path : this.config.getConfigurables().values()) {
                ConfigCategory enchant = (ConfigCategory)path;
                newEnchants.add(new Enchants.EnchantWithLevel(ENCHANTMENTS.get(EnchantmentsScreen.getConfigEnchantment(enchant).getValidValue()), (Integer)EnchantmentsScreen.getConfigLevel(enchant).getValidValue()));
            }
            new Enchants(this.item).replaceEnchants(newEnchants);
            this.checkSave();
        });
    }

    @Override
    protected void initEditor() {
        ConfigPanel newPanel = (ConfigPanel)this.method_37063(new ConfigPanel(16, 64, this.field_22789 - 32, this.field_22790 - 80, this.config));
        if (this.panel != null) {
            newPanel.setScroll(this.panel.getScroll());
        }
        this.panel = newPanel;
    }

    @Override
    protected void renderEditor(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.renderTip(matrices, "nbteditor.enchantments.tip");
    }
}

