/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.factories;

import com.luneruniverse.minecraft.mod.nbteditor.itemreferences.ItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.ScreenTexts;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ItemEditorScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigButton;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigCategory;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigItem;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigPanel;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigValueBoolean;
import com.luneruniverse.minecraft.mod.nbteditor.screens.factories.DisplayScreen;
import net.minecraft.class_2561;

public class HideFlagsScreen
extends ItemEditorScreen {
    private final ConfigCategory config = new ConfigCategory(TextInst.translatable("nbteditor.hide_flags", new Object[0]));
    private ConfigPanel panel;

    public HideFlagsScreen(ItemReference ref) {
        super(TextInst.of("Hide Flags"), ref);
        this.config.setConfigurable("disable_all", new ConfigButton(100, TextInst.translatable("nbteditor.hide_flags.show_all", new Object[0]), btn -> this.setCode(0)));
        this.config.setConfigurable("enable_all", new ConfigButton(100, TextInst.translatable("nbteditor.hide_flags.hide_all", new Object[0]), btn -> this.setCode(127)));
        int code = this.item.method_7948().method_10550("HideFlags");
        for (Flag flag : Flag.values()) {
            this.config.setConfigurable(flag.name(), new ConfigItem<ConfigValueBoolean>(flag.getText(), new ConfigValueBoolean(flag.isEnabled(code), false, 100, ScreenTexts.ON, ScreenTexts.OFF)));
        }
        this.config.addValueListener(source -> {
            int newCode = 0;
            for (Flag flag : Flag.values()) {
                if (!((Boolean)((ConfigValueBoolean)((ConfigItem)this.config.getConfigurable(flag.name())).getValue()).getValidValue()).booleanValue()) continue;
                newCode = flag.toggle(newCode);
            }
            this.item.method_7948().method_10569("HideFlags", newCode);
            this.checkSave();
        });
    }

    private void setCode(int code) {
        for (Flag flag : Flag.values()) {
            ((ConfigValueBoolean)((ConfigItem)this.config.getConfigurable(flag.name())).getValue()).setValue(flag.isEnabled(code));
        }
    }

    @Override
    protected ItemEditorScreen.FactoryLink getFactoryLink() {
        return new ItemEditorScreen.FactoryLink("nbteditor.display", DisplayScreen::new);
    }

    @Override
    protected void initEditor() {
        ConfigPanel newPanel = (ConfigPanel)this.method_37063(new ConfigPanel(16, 64, this.field_22789 - 32, this.field_22790 - 80, this.config));
        if (this.panel != null) {
            newPanel.setScroll(this.panel.getScroll());
        }
        this.panel = newPanel;
    }

    private static enum Flag {
        ENCHANTMENTS(TextInst.translatable("nbteditor.hide_flags.enchantments", new Object[0]), 1),
        ATTRIBUTE_MODIFIERS(TextInst.translatable("nbteditor.hide_flags.attribute_modifiers", new Object[0]), 2),
        UNBREAKABLE(TextInst.translatable("nbteditor.hide_flags.unbreakable", new Object[0]), 4),
        CAN_DESTORY(TextInst.translatable("nbteditor.hide_flags.can_destroy", new Object[0]), 8),
        CAN_PLACE_ON(TextInst.translatable("nbteditor.hide_flags.can_place_on", new Object[0]), 16),
        MISC(TextInst.translatable("nbteditor.hide_flags.misc", new Object[0]), 32),
        DYED_COLOR(TextInst.translatable("nbteditor.hide_flags.dyed_color", new Object[0]), 64);

        private final class_2561 text;
        private final int code;

        private Flag(class_2561 text, int code) {
            this.text = text;
            this.code = code;
        }

        public class_2561 getText() {
            return this.text;
        }

        public int toggle(int code) {
            return code & ~this.code | ~code & this.code;
        }

        public boolean isEnabled(int code) {
            return (code & this.code) != 0;
        }
    }
}

