/*
 * Decompiled with CFR 0.152.
 */
package com.luneruniverse.minecraft.mod.nbteditor.screens.factories;

import com.luneruniverse.minecraft.mod.nbteditor.containers.ContainerIO;
import com.luneruniverse.minecraft.mod.nbteditor.itemreferences.ItemReference;
import com.luneruniverse.minecraft.mod.nbteditor.multiversion.TextInst;
import com.luneruniverse.minecraft.mod.nbteditor.screens.ItemEditorScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.NBTEditorScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigButton;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigCategory;
import com.luneruniverse.minecraft.mod.nbteditor.screens.configurable.ConfigPanel;
import com.luneruniverse.minecraft.mod.nbteditor.screens.containers.ContainerScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.factories.AttributesScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.factories.BlockStatesScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.factories.BookScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.factories.DisplayScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.factories.EnchantmentsScreen;
import com.luneruniverse.minecraft.mod.nbteditor.screens.factories.SignboardScreen;
import com.luneruniverse.minecraft.mod.nbteditor.util.MainUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1747;
import net.minecraft.class_1802;
import net.minecraft.class_1822;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;

public class ItemFactoryScreen
extends ItemEditorScreen {
    public static final class_2960 FACTORY_ICON = new class_2960("nbteditor", "textures/factory.png");
    public static final List<ItemFactoryReference> BASIC_FACTORIES = new ArrayList<ItemFactoryReference>();
    private final ConfigCategory config = new ConfigCategory();
    private ConfigPanel panel;

    private static void addFactory(String key, Predicate<ItemReference> supported, Function<ItemReference, class_437> screen) {
        BASIC_FACTORIES.add(new ItemFactoryReference(TextInst.translatable(key, new Object[0]), supported, ref -> MainUtil.client.method_1507((class_437)screen.apply((ItemReference)ref))));
    }

    private static void addFactory(String key, Function<ItemReference, class_437> screen) {
        ItemFactoryScreen.addFactory(key, ref -> true, screen);
    }

    public ItemFactoryScreen(ItemReference ref) {
        super(TextInst.of("Item Factories"), ref);
        for (ItemFactoryReference factory : BASIC_FACTORIES) {
            if (!factory.supported().test(ref)) continue;
            this.config.setConfigurable(factory.buttonText().getString(), new ConfigButton(150, factory.buttonText(), btn -> factory.factory().accept(ref)));
        }
    }

    @Override
    protected boolean isSaveRequried() {
        return false;
    }

    @Override
    protected ItemEditorScreen.FactoryLink getFactoryLink() {
        return null;
    }

    @Override
    protected void initEditor() {
        ConfigPanel newPanel = (ConfigPanel)this.method_37063(new ConfigPanel(16, 64, this.field_22789 - 32, this.field_22790 - 80, this.config));
        if (this.panel != null) {
            newPanel.setScroll(this.panel.getScroll());
        }
        this.panel = newPanel;
    }

    static {
        ItemFactoryScreen.addFactory("nbteditor", NBTEditorScreen::new);
        BASIC_FACTORIES.add(new ItemFactoryReference(TextInst.translatable("nbteditor.container", new Object[0]), ref -> ContainerIO.isContainer(ref.getItem()), ContainerScreen::show));
        ItemFactoryScreen.addFactory("nbteditor.book", ref -> ref.getItem().method_7909() == class_1802.field_8360, BookScreen::new);
        ItemFactoryScreen.addFactory("nbteditor.display", DisplayScreen::new);
        ItemFactoryScreen.addFactory("nbteditor.signboard", ref -> ref.getItem().method_7909() instanceof class_1822, SignboardScreen::new);
        ItemFactoryScreen.addFactory("nbteditor.enchantments", EnchantmentsScreen::new);
        ItemFactoryScreen.addFactory("nbteditor.attributes", AttributesScreen::new);
        ItemFactoryScreen.addFactory("nbteditor.block_states", ref -> ref.getItem().method_7909() instanceof class_1747, BlockStatesScreen::new);
    }

    public record ItemFactoryReference(class_2561 buttonText, Predicate<ItemReference> supported, Consumer<ItemReference> factory) {
    }
}

